/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.ControllerInput;
import com.mrcrayfish.controllable.client.binding.ButtonBinding;
import com.mrcrayfish.controllable.client.gui.screens.ControllerLayoutScreen;
import com.mrcrayfish.controllable.client.gui.screens.SettingsScreen;
import com.mrcrayfish.controllable.client.input.ButtonStates;
import com.mrcrayfish.controllable.client.input.Buttons;
import com.mrcrayfish.controllable.client.input.Controller;
import com.mrcrayfish.controllable.client.input.ControllerManager;
import com.mrcrayfish.framework.api.event.IFrameworkEvent;
import com.mrcrayfish.framework.api.event.TickEvents;
import com.mrcrayfish.framework.event.ITickEvent;
import java.util.ArrayDeque;
import java.util.Queue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;

public class InputProcessor {
    private static InputProcessor instance;
    private final Queue<ButtonStates> inputQueue = new ArrayDeque<ButtonStates>();
    private final ControllerInput input = new ControllerInput();
    private final ControllerManager manager = Controllable.getManager();

    public static InputProcessor instance() {
        if (instance == null) {
            instance = new InputProcessor();
        }
        return instance;
    }

    private InputProcessor() {
        TickEvents.START_RENDER.register((IFrameworkEvent)((ITickEvent.StartRender)partialTick -> this.pollControllerInput(false)));
        TickEvents.END_RENDER.register((IFrameworkEvent)((ITickEvent.EndRender)partialTick -> this.pollControllerInput(false)));
        TickEvents.START_CLIENT.register((IFrameworkEvent)((ITickEvent.StartClient)() -> this.pollControllerInput(true)));
        TickEvents.END_CLIENT.register((IFrameworkEvent)((ITickEvent.EndClient)() -> this.pollControllerInput(false)));
    }

    private void pollControllerInput(boolean process) {
        this.gatherAndQueueControllerInput();
        if (process) {
            this.processButtonStates();
        }
    }

    private void gatherAndQueueControllerInput() {
        if (this.manager == null) {
            return;
        }
        this.manager.tick();
        Controller currentController = this.manager.getActiveController();
        if (currentController == null) {
            return;
        }
        this.inputQueue.offer(currentController.createButtonsStates());
    }

    private void processButtonStates() {
        ButtonBinding.tick();
        while (!this.inputQueue.isEmpty()) {
            ButtonStates states = this.inputQueue.poll();
            for (int i = 0; i < Buttons.BUTTONS.length; ++i) {
                this.processButton(Buttons.BUTTONS[i], states);
            }
        }
    }

    private void processButton(int index, ButtonStates newStates) {
        boolean state = newStates.getState(index);
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof ControllerLayoutScreen) {
            ((ControllerLayoutScreen)screen).processButton(index, newStates);
            return;
        }
        Controller controller = this.manager.getActiveController();
        if (controller == null) {
            return;
        }
        if (index == -1) {
            return;
        }
        ButtonStates states = controller.getButtonsStates();
        if (state) {
            if (!states.getState(index)) {
                SettingsScreen settings;
                states.setState(index, true);
                if (screen instanceof SettingsScreen && (settings = (SettingsScreen)screen).isWaitingForButtonInput() && settings.processButton(index)) {
                    return;
                }
                this.input.handleButtonInput(controller, index, true, false);
            }
        } else if (states.getState(index)) {
            states.setState(index, false);
            this.input.handleButtonInput(controller, index, false, false);
        }
    }

    public static void queueInputsWait() {
        Minecraft mc = Minecraft.m_91087_();
        int fps = mc.f_91073_ != null || mc.f_91080_ == null && mc.m_91265_() == null ? mc.m_91268_().m_85434_() : 60;
        int captureCount = 4;
        for (int i = 0; i < captureCount; ++i) {
            RenderSystem.limitDisplayFPS((int)(fps * captureCount));
            InputProcessor.instance().gatherAndQueueControllerInput();
        }
    }

    public ControllerInput getInput() {
        return this.input;
    }
}

