/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.gui.widget;

import java.text.DecimalFormat;
import java.util.function.Consumer;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class LazySlider
extends AbstractSliderButton {
    private static final DecimalFormat FORMATTER = new DecimalFormat("###0.###");
    private final Component label;
    private final double minValue;
    private final double maxValue;
    private final double step;
    private final Consumer<Double> onChange;
    private boolean pressed = false;
    private boolean valueOnly = false;

    public LazySlider(int x, int y, int width, int height, Component label, double initialValue, double minValue, double maxValue, double step, Consumer<Double> onChange) {
        super(x, y, width, height, label, LazySlider.parseValue(initialValue, step, minValue, maxValue));
        this.label = label;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.step = step;
        this.onChange = onChange;
        this.m_5695_();
    }

    public void valueOnly() {
        this.valueOnly = true;
        this.m_5695_();
    }

    public void m_5716_(double mouseX, double mouseY) {
        super.m_5716_(mouseX, mouseY);
        this.pressed = true;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.m_7972_(button) && this.pressed) {
            this.onChange.accept(this.getValue());
            this.pressed = false;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public double getValue() {
        double scale = 1.0 / this.step;
        double value = this.minValue + (this.maxValue - this.minValue) * this.f_93577_;
        return (double)Mth.m_14107_((double)(value * scale)) / scale;
    }

    protected void m_5695_() {
        if (this.valueOnly) {
            this.m_93666_((Component)Component.m_237119_().m_130946_(FORMATTER.format(this.getValue())));
        } else {
            this.m_93666_((Component)Component.m_237119_().m_7220_(this.label).m_130946_(": ").m_130946_(FORMATTER.format(this.getValue())));
        }
    }

    protected void m_5697_() {
    }

    private static double parseValue(double value, double step, double minValue, double maxValue) {
        double range = Math.abs(maxValue - minValue);
        value -= minValue;
        return value /= range;
    }

    public void stepForward() {
        if (this.f_93577_ < 1.0) {
            this.f_93577_ = Mth.m_14008_((double)(this.f_93577_ + this.step / (this.maxValue - this.minValue)), (double)0.0, (double)1.0);
            this.m_5695_();
        }
    }

    public void stepBackward() {
        if (this.f_93577_ > 0.0) {
            this.f_93577_ = Mth.m_14008_((double)(this.f_93577_ - this.step / (this.maxValue - this.minValue)), (double)0.0, (double)1.0);
            this.m_5695_();
        }
    }

    public void triggerChangeCallback() {
        this.onChange.accept(this.getValue());
    }
}

