/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.settings;

import com.mrcrayfish.controllable.Config;
import com.mrcrayfish.controllable.client.ActionVisibility;
import com.mrcrayfish.controllable.client.ButtonIcons;
import com.mrcrayfish.controllable.client.CursorType;
import com.mrcrayfish.controllable.client.Thumbstick;
import com.mrcrayfish.controllable.client.settings.ControllerEnumSetting;
import com.mrcrayfish.controllable.client.settings.ControllerSetting;
import com.mrcrayfish.controllable.client.settings.ControllerSliderSetting;
import com.mrcrayfish.controllable.client.settings.ControllerToggleSetting;
import com.mrcrayfish.controllable.client.settings.VanillaSetting;
import com.mrcrayfish.framework.api.config.BoolProperty;
import com.mrcrayfish.framework.api.config.DoubleProperty;
import com.mrcrayfish.framework.api.config.EnumProperty;
import com.mrcrayfish.framework.api.config.validate.NumberRange;
import com.mrcrayfish.framework.api.config.validate.Validator;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;

public class ControllerOptions {
    public static final ControllerSetting<Boolean> AUTO_SELECT = ControllerOptions.createToggleSetting("controllable.options.autoSelect", Config.CLIENT.client.options.autoSelect);
    public static final ControllerSetting<Boolean> RENDER_MINI_PLAYER = ControllerOptions.createToggleSetting("controllable.options.renderMiniPlayer", Config.CLIENT.client.options.renderMiniPlayer);
    public static final ControllerSetting<Boolean> VIRTUAL_MOUSE = ControllerOptions.createToggleSetting("controllable.options.virtualMouse", Config.CLIENT.client.options.virtualCursor);
    public static final ControllerSetting<Boolean> CONSOLE_HOTBAR = ControllerOptions.createToggleSetting("controllable.options.consoleHotbar", Config.CLIENT.client.options.consoleHotbar);
    public static final ControllerSetting<CursorType> CURSOR_TYPE = ControllerOptions.createValuesSetting("controllable.options.cursorType", CursorType.class, Config.CLIENT.client.options.cursorType);
    public static final ControllerSetting<ButtonIcons> CONTROLLER_ICONS = ControllerOptions.createValuesSetting("controllable.options.controllerIcons", ButtonIcons.class, Config.CLIENT.client.options.controllerIcons);
    public static final ControllerSetting<Boolean> INVERT_LOOK = ControllerOptions.createToggleSetting("controllable.options.invertLook", Config.CLIENT.client.options.invertLook);
    public static final ControllerSetting<Boolean> INVERT_ROTATION = ControllerOptions.createToggleSetting("controllable.options.invertRotation", Config.CLIENT.client.options.invertRotation);
    public static final ControllerSetting<Double> DEAD_ZONE = ControllerOptions.createSliderSetting("controllable.options.deadZone", Config.CLIENT.client.options.thumbstickDeadZone, 0.01);
    public static final ControllerSetting<Double> ROTATION_SPEED = ControllerOptions.createSliderSetting("controllable.options.rotationSpeed", Config.CLIENT.client.options.rotationSpeed, 1.0);
    public static final ControllerSetting<Double> PITCH_SENSITIVITY = ControllerOptions.createSliderSetting("controllable.options.pitchSensitivity", Config.CLIENT.client.options.pitchSensitivity, 0.01);
    public static final ControllerSetting<Double> YAW_SENSITIVITY = ControllerOptions.createSliderSetting("controllable.options.yawSensitivity", Config.CLIENT.client.options.yawSensitivity, 0.01);
    public static final ControllerSetting<Double> MOUSE_SPEED = ControllerOptions.createSliderSetting("controllable.options.mouseSpeed", Config.CLIENT.client.options.cursorSpeed, 1.0);
    public static final ControllerSetting<Boolean> QUICK_CRAFT = ControllerOptions.createToggleSetting("controllable.options.quickCraft", Config.CLIENT.client.options.quickCraft);
    public static final ControllerSetting<Boolean> UI_SOUNDS = ControllerOptions.createToggleSetting("controllable.options.uiSounds", Config.CLIENT.client.options.uiSounds);
    public static final ControllerSetting<Double> HOVER_MODIFIER = ControllerOptions.createSliderSetting("controllable.options.hoverModifier", Config.CLIENT.client.options.hoverModifier, 0.05);
    public static final ControllerSetting<ActionVisibility> SHOW_ACTIONS = ControllerOptions.createValuesSetting("controllable.options.showActions", ActionVisibility.class, Config.CLIENT.client.options.showButtonHints);
    public static final ControllerSetting<Thumbstick> RADIAL_THUMBSTICK = ControllerOptions.createValuesSetting("controllable.options.radialThumbstick", Thumbstick.class, Config.CLIENT.client.options.radialThumbstick);
    public static final VanillaSetting<Boolean> SNEAK_MODE = ControllerOptions.createVanillaSetting(() -> Minecraft.m_91087_().f_91066_.m_231831_());
    public static final VanillaSetting<Boolean> SPRINT_MODE = ControllerOptions.createVanillaSetting(() -> Minecraft.m_91087_().f_91066_.m_231832_());
    public static final ControllerSetting<Thumbstick> CURSOR_THUMBSTICK = ControllerOptions.createValuesSetting("controllable.options.cursorThumbstick", Thumbstick.class, Config.CLIENT.client.options.cursorThumbstick);
    public static final ControllerSetting<Boolean> FPS_POLLING_FIX = ControllerOptions.createToggleSetting("controllable.options.fpsPollingFix", Config.CLIENT.client.options.fpsPollingFix);
    public static final ControllerSetting<Boolean> HINT_BACKGROUND = ControllerOptions.createToggleSetting("controllable.options.hintBackground", Config.CLIENT.client.options.drawHintBackground);
    public static final ControllerSetting<Double> LIST_SCROLL_SPEED = ControllerOptions.createSliderSetting("controllable.options.listScrollSpeed", Config.CLIENT.client.options.listScrollSpeed, 1.0);

    public static ControllerSetting<Boolean> createToggleSetting(String key, BoolProperty property) {
        return new ControllerToggleSetting(key, property);
    }

    public static <T extends Enum<T>> ControllerSetting<T> createValuesSetting(String key, Class<T> clazz, EnumProperty<T> property) {
        return new ControllerEnumSetting<T>(key, clazz, property);
    }

    public static ControllerSetting<Double> createSliderSetting(String key, DoubleProperty property, double stepSize) {
        Validator validator = property.getValidator();
        if (!(validator instanceof NumberRange)) {
            throw new IllegalArgumentException("Double property must have a number range");
        }
        NumberRange range = (NumberRange)validator;
        return new ControllerSliderSetting(key, property, (Double)range.minValue(), (Double)range.maxValue(), stepSize);
    }

    public static <T> VanillaSetting<T> createVanillaSetting(Supplier<OptionInstance<T>> optionSupplier) {
        return new VanillaSetting<T>(optionSupplier);
    }
}

