/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.gui.screen.monitor.music_manager;

import dev.architectury.networking.NetworkManager;
import dev.felnull.imp.blockentity.MusicManagerBlockEntity;
import dev.felnull.imp.client.gui.screen.MusicManagerScreen;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.DeleteBaseMMMonitor;
import dev.felnull.imp.music.resource.Music;
import dev.felnull.imp.networking.IMPPackets;
import dev.felnull.otyacraftengine.networking.existence.BlockEntityExistence;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeleteMusicMMMonitor
extends DeleteBaseMMMonitor {
    public DeleteMusicMMMonitor(MusicManagerBlockEntity.MonitorType type, MusicManagerScreen screen) {
        super(type, screen);
    }

    @Override
    public void onDelete() {
        BlockEntity blockEntity = this.getScreen().getBlockEntity();
        if (blockEntity instanceof MusicManagerBlockEntity) {
            MusicManagerBlockEntity musicManagerBlock = (MusicManagerBlockEntity)blockEntity;
            NetworkManager.sendToServer((ResourceLocation)IMPPackets.MUSIC_OR_PLAYLIST_DELETE, (FriendlyByteBuf)new IMPPackets.MusicOrPlayListDeleteMessage(this.getSelectedPlayList(musicManagerBlock), this.getSelectedMusicRaw(musicManagerBlock), BlockEntityExistence.getByBlockEntity((BlockEntity)this.getScreen().getBlockEntity()), true).toFBB());
        }
    }

    @Override
    @NotNull
    public String getWaringName(MusicManagerBlockEntity musicManagerBlockEntity) {
        Music sm = this.getSelectedMusic(musicManagerBlockEntity);
        if (sm != null) {
            return sm.getName();
        }
        return "";
    }

    @Override
    @Nullable
    protected MusicManagerBlockEntity.MonitorType getParentType() {
        return MusicManagerBlockEntity.MonitorType.DETAIL_MUSIC;
    }

    @Nullable
    private Music getSelectedMusic(MusicManagerBlockEntity musicManagerBlockEntity) {
        List<Music> sms;
        UUID id = this.getSelectedMusicRaw(musicManagerBlockEntity);
        UUID pl = this.getSelectedPlayList(musicManagerBlockEntity);
        if (id != null && pl != null && (sms = this.getSyncManager().getMusics(pl)) != null) {
            return sms.stream().filter(n -> id.equals(n.getUuid())).findFirst().orElse(null);
        }
        return null;
    }

    @Nullable
    private UUID getSelectedPlayList(MusicManagerBlockEntity musicManagerBlockEntity) {
        return musicManagerBlockEntity.getSelectedPlayList((Player)DeleteMusicMMMonitor.mc.f_91074_);
    }

    @Nullable
    private UUID getSelectedMusicRaw(MusicManagerBlockEntity musicManagerBlockEntity) {
        return musicManagerBlockEntity.getSelectedMusic((Player)DeleteMusicMMMonitor.mc.f_91074_);
    }
}

