/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.gui.screen.monitor.music_manager;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.felnull.imp.blockentity.MusicManagerBlockEntity;
import dev.felnull.imp.client.gui.components.SmartButton;
import dev.felnull.imp.client.gui.components.YoutubePlayListMusicsFixedListWidget;
import dev.felnull.imp.client.gui.screen.MusicManagerScreen;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.CreatePlayListMMMonitor;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.MusicManagerMonitor;
import dev.felnull.imp.client.lava.LavaPlayerManager;
import dev.felnull.imp.client.music.media.IMPMusicMedias;
import dev.felnull.imp.client.music.media.MusicMediaResult;
import dev.felnull.imp.client.util.YoutubeUtil;
import dev.felnull.imp.include.com.github.kiulian.downloader.model.playlist.PlaylistInfo;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioPlaylist;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import dev.felnull.imp.music.resource.ImageInfo;
import dev.felnull.imp.music.resource.MusicSource;
import dev.felnull.otyacraftengine.client.util.OERenderUtils;
import dev.felnull.otyacraftengine.util.FlagThread;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.commons.lang3.tuple.Pair;

public abstract class ImportYoutubePlayListBaseMMMonitor
extends MusicManagerMonitor {
    private static final ResourceLocation IMPORT_YOUTUBE_PLAY_LIST_TEXTURE = new ResourceLocation("iammusicplayer", "textures/gui/container/music_manager/monitor/import_youtube_play_list.png");
    private static final Component BACK_TEXT = Component.m_237115_((String)"gui.back");
    private static final Component LOADING_TEXT = Component.m_237115_((String)"imp.text.playlistLoading");
    private final List<YoutubePlayListEntry> youtubePlayListEntries = new ArrayList<YoutubePlayListEntry>();
    private SmartButton importButton;
    private PlayListLoadThread playListLoader;
    private EditBox playlistIdentifierEditBox;
    private YoutubePlayListMusicsFixedListWidget youtubePlayListMusicsFixedButtonsList;

    public ImportYoutubePlayListBaseMMMonitor(MusicManagerBlockEntity.MonitorType type, MusicManagerScreen screen) {
        super(type, screen);
    }

    @Override
    public void init(int leftPos, int topPos) {
        super.init(leftPos, topPos);
        this.addRenderWidget(new SmartButton(this.getStartX() + 5, this.getStartY() + 180, 87, 15, BACK_TEXT, n -> {
            if (this.getParentType() != null) {
                this.insMonitor(this.getParentType());
            }
            this.resetImport();
        }));
        this.importButton = this.addRenderWidget(new SmartButton(this.getStartX() + 95, this.getStartY() + 180, 87, 15, CreatePlayListMMMonitor.IMPORT_TEXT, n -> this.onImport()));
        this.importButton.f_93623_ = this.canImport();
        this.playlistIdentifierEditBox = this.addRenderWidget(new EditBox(ImportYoutubePlayListBaseMMMonitor.mc.f_91062_, this.getStartX() + 6, this.getStartY() + 164, 175, 12, (Component)Component.m_237115_((String)"imp.editBox.youtubePlaylistIdentifier")));
        this.playlistIdentifierEditBox.m_94199_(300);
        this.playlistIdentifierEditBox.m_94151_(this::startPlayListLoad);
        this.playlistIdentifierEditBox.m_94144_(this.getImportPlayList());
        this.youtubePlayListMusicsFixedButtonsList = this.addRenderWidget(new YoutubePlayListMusicsFixedListWidget(this.getStartX() + 1, this.getStartY() + 10, 368, 148, (Component)Component.m_237115_((String)"imp.fixedList.youtubePlayListMusics"), 4, this.youtubePlayListEntries, this.youtubePlayListMusicsFixedButtonsList));
        this.startPlayListLoad(this.getImportPlayList());
    }

    protected abstract void onImport();

    @Override
    public void render(GuiGraphics guiGraphics, float f, int mouseX, int mouseY) {
        super.render(guiGraphics, f, mouseX, mouseY);
        OERenderUtils.drawTexture((ResourceLocation)IMPORT_YOUTUBE_PLAY_LIST_TEXTURE, (PoseStack)guiGraphics.m_280168_(), (float)this.getStartX(), (float)this.getStartY(), (float)0.0f, (float)0.0f, (float)this.width, (float)this.height, (float)this.width, (float)this.height);
        if (this.isPlayListLoading()) {
            this.drawSmartText(guiGraphics, LOADING_TEXT, this.getStartX() + 2, this.getStartY() + 11);
        }
        this.drawSmartText(guiGraphics, (Component)Component.m_237113_((String)this.getImportPlayListName()), this.getStartX() + 200, this.getStartY() + 167);
        this.drawSmartText(guiGraphics, (Component)Component.m_237113_((String)this.getImportPlayListAuthor()), this.getStartX() + 200, this.getStartY() + 183);
    }

    @Override
    public void renderAppearance(MusicManagerBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int j, float f, float monitorWidth, float monitorHeight) {
        super.renderAppearance(blockEntity, poseStack, multiBufferSource, i, j, f, monitorWidth, monitorHeight);
        float onPxW = monitorWidth / (float)this.width;
        float onPxH = monitorHeight / (float)this.height;
        OERenderUtils.renderTextureSprite((ResourceLocation)IMPORT_YOUTUBE_PLAY_LIST_TEXTURE, (PoseStack)poseStack, (MultiBufferSource)multiBufferSource, (float)0.0f, (float)0.0f, (float)0.002f, (float)0.0f, (float)0.0f, (float)0.0f, (float)monitorWidth, (float)monitorHeight, (float)0.0f, (float)0.0f, (float)this.width, (float)this.height, (float)this.width, (float)this.height, (int)i, (int)j);
        this.renderSmartButtonSprite(poseStack, multiBufferSource, 5.0f, 180.0f, 0.004f, 87.0f, 15.0f, i, j, onPxW, onPxH, monitorHeight, BACK_TEXT, true);
        this.renderSmartButtonSprite(poseStack, multiBufferSource, 95.0f, 180.0f, 0.004f, 87.0f, 15.0f, i, j, onPxW, onPxH, monitorHeight, CreatePlayListMMMonitor.IMPORT_TEXT, true, !this.canImport(blockEntity));
        this.renderSmartEditBoxSprite(poseStack, multiBufferSource, 6.0f, 164.0f, 0.004f, 175.0f, 12.0f, i, j, onPxW, onPxH, monitorHeight, this.getImportPlayList(blockEntity));
        this.renderSmartTextSprite(poseStack, multiBufferSource, (Component)Component.m_237113_((String)this.getImportPlayListName(blockEntity)), 200.0f, 167.0f, 0.002f, onPxW, onPxH, monitorHeight, i);
        this.renderSmartTextSprite(poseStack, multiBufferSource, (Component)Component.m_237113_((String)this.getImportPlayListAuthor(blockEntity)), 200.0f, 183.0f, 0.002f, onPxW, onPxH, monitorHeight, i);
        this.renderScrollbarSprite(poseStack, multiBufferSource, 360.0f, 10.0f, 0.002f, 148.0f, i, j, onPxW, onPxH, monitorHeight, 1, 1);
    }

    @Override
    public void tick() {
        super.tick();
        this.importButton.f_93623_ = this.canImport();
    }

    protected int getImportPlayListMusicCount() {
        BlockEntity blockEntity = this.getScreen().getBlockEntity();
        if (blockEntity instanceof MusicManagerBlockEntity) {
            MusicManagerBlockEntity musicManagerBlockEntity = (MusicManagerBlockEntity)blockEntity;
            return this.getImportPlayListMusicCount(musicManagerBlockEntity);
        }
        return 0;
    }

    protected int getImportPlayListMusicCount(MusicManagerBlockEntity blockEntity) {
        return blockEntity.getImportPlayListMusicCount((Player)ImportYoutubePlayListBaseMMMonitor.mc.f_91074_);
    }

    protected String getImportPlayListAuthor() {
        BlockEntity blockEntity = this.getScreen().getBlockEntity();
        if (blockEntity instanceof MusicManagerBlockEntity) {
            MusicManagerBlockEntity musicManagerBlockEntity = (MusicManagerBlockEntity)blockEntity;
            return this.getImportPlayListAuthor(musicManagerBlockEntity);
        }
        return "";
    }

    protected String getImportPlayListAuthor(MusicManagerBlockEntity blockEntity) {
        return blockEntity.getImportPlayListAuthor((Player)ImportYoutubePlayListBaseMMMonitor.mc.f_91074_);
    }

    protected String getImportPlayList() {
        BlockEntity blockEntity = this.getScreen().getBlockEntity();
        if (blockEntity instanceof MusicManagerBlockEntity) {
            MusicManagerBlockEntity musicManagerBlockEntity = (MusicManagerBlockEntity)blockEntity;
            return this.getImportPlayList(musicManagerBlockEntity);
        }
        return "";
    }

    protected String getImportPlayList(MusicManagerBlockEntity blockEntity) {
        return blockEntity.getImportIdentifier((Player)ImportYoutubePlayListBaseMMMonitor.mc.f_91074_);
    }

    protected String getImportPlayListName() {
        BlockEntity blockEntity = this.getScreen().getBlockEntity();
        if (blockEntity instanceof MusicManagerBlockEntity) {
            MusicManagerBlockEntity musicManagerBlockEntity = (MusicManagerBlockEntity)blockEntity;
            return this.getImportPlayListName(musicManagerBlockEntity);
        }
        return "";
    }

    protected String getImportPlayListName(MusicManagerBlockEntity blockEntity) {
        return blockEntity.getImportPlayListName((Player)ImportYoutubePlayListBaseMMMonitor.mc.f_91074_);
    }

    protected boolean canImport() {
        BlockEntity blockEntity = this.getScreen().getBlockEntity();
        if (blockEntity instanceof MusicManagerBlockEntity) {
            MusicManagerBlockEntity musicManagerBlockEntity = (MusicManagerBlockEntity)blockEntity;
            return this.canImport(musicManagerBlockEntity);
        }
        return false;
    }

    protected boolean canImport(MusicManagerBlockEntity blockEntity) {
        return !this.getImportPlayList(blockEntity).isEmpty() && this.getImportPlayListMusicCount(blockEntity) > 0;
    }

    protected boolean isPlayListLoading() {
        return this.playListLoader != null && this.playListLoader.isAlive();
    }

    protected void setImportPlayListAuthor(String author) {
        this.getScreen().insImportPlayListAuthor(author);
    }

    protected void setImportPlayListMusicCount(int count) {
        this.getScreen().insImportPlayListMusicCount(count);
    }

    protected void setImportPlayListName(String name) {
        this.getScreen().insImportPlayListName(name);
    }

    protected void setImportPlayList(String id) {
        this.getScreen().insImportIdentifier(id);
    }

    @Override
    protected void onBackParent() {
        super.onBackParent();
        this.resetImport();
    }

    protected void resetImport() {
        this.setImportPlayList("");
        this.setImportPlayListAuthor("");
        this.setImportPlayListName("");
        this.setImportPlayListMusicCount(0);
    }

    protected void startPlayListLoad(String id) {
        this.stopPlayListLoad();
        this.youtubePlayListEntries.clear();
        this.resetImport();
        this.playListLoader = new PlayListLoadThread(id);
        this.playListLoader.start();
    }

    protected void stopPlayListLoad() {
        if (this.playListLoader != null) {
            this.playListLoader.stopped();
            this.playListLoader = null;
        }
    }

    private class PlayListLoadThread
    extends FlagThread {
        private final String id;

        public PlayListLoadThread(String id) {
            this.id = id;
        }

        public void run() {
            if (this.isStopped()) {
                return;
            }
            String sid = "";
            String sname = "";
            String satuhor = "";
            int sct = 0;
            try {
                Pair<AudioPlaylist, List<AudioTrack>> pl = LavaPlayerManager.getInstance().loadTracks(this.id);
                if (pl.getLeft() == null) {
                    throw new IllegalStateException("Not PlayList");
                }
                for (AudioTrack track : (List)pl.getRight()) {
                    if (!track.getInfo().isStream) {
                        MusicMediaResult ret = IMPMusicMedias.YOUTUBE.createResult(track);
                        YoutubePlayListEntry en = new YoutubePlayListEntry(ret.name(), ret.author(), ret.source(), ret.imageInfo());
                        ImportYoutubePlayListBaseMMMonitor.this.youtubePlayListEntries.add(en);
                    }
                    if (!this.isStopped()) continue;
                    return;
                }
                sid = this.id;
                sct = ImportYoutubePlayListBaseMMMonitor.this.youtubePlayListEntries.size();
                sname = ((AudioPlaylist)pl.getLeft()).getName();
                if (this.isStopped()) {
                    return;
                }
                String pid = YoutubeUtil.getPlayListID(this.id);
                if (pid != null) {
                    PlaylistInfo ypl = YoutubeUtil.getYoutubePlayList(pid);
                    satuhor = ypl.details().author();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.isStopped()) {
                return;
            }
            ImportYoutubePlayListBaseMMMonitor.this.setImportPlayList(sid);
            ImportYoutubePlayListBaseMMMonitor.this.setImportPlayListMusicCount(sct);
            ImportYoutubePlayListBaseMMMonitor.this.setImportPlayListName(sname);
            ImportYoutubePlayListBaseMMMonitor.this.setImportPlayListAuthor(satuhor);
        }
    }

    public record YoutubePlayListEntry(String name, String artist, MusicSource source, ImageInfo imageInfo) {
    }
}

