/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.music.media;

import com.google.gson.JsonObject;
import dev.felnull.imp.client.lava.LavaPlayerManager;
import dev.felnull.imp.client.music.media.MusicMedia;
import dev.felnull.imp.client.music.media.MusicMediaResult;
import dev.felnull.imp.client.music.media.NetEaseCloudMusicManager;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import dev.felnull.imp.music.resource.ImageInfo;
import dev.felnull.imp.music.resource.MusicSource;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;

public class NetEaseCloudMusicMedia
implements MusicMedia {
    private static final Component MEDIA_NAME = Component.m_237115_((String)"imp.loaderType.neteasecloudmusic");
    private static final Component NECM_ENTER_TEXT = Component.m_237115_((String)"imp.text.enterText.neteasecloudmusic");
    public static final ResourceLocation ICON = new ResourceLocation("iammusicplayer", "textures/gui/container/music_manager/loader_types/neteasecloudmusic.png");

    @Override
    public Component getMediaName() {
        return MEDIA_NAME;
    }

    @Override
    public Component getEnterText() {
        return NECM_ENTER_TEXT;
    }

    @Override
    public ResourceLocation getIcon() {
        return ICON;
    }

    @Override
    public boolean isSearchable() {
        return true;
    }

    @Override
    public List<MusicMediaResult> search(String searchText) {
        if (searchText.isEmpty()) {
            return new ArrayList<MusicMediaResult>();
        }
        try {
            ArrayList<MusicMediaResult> ret = new ArrayList<MusicMediaResult>();
            List<JsonObject> sr = NetEaseCloudMusicManager.getInstance().getSearchSongs(searchText);
            for (JsonObject jo : sr) {
                ret.add(this.createResult(jo, String.valueOf(jo.get("id").getAsInt()), jo.get("dt").getAsLong()));
            }
            return ret;
        }
        catch (IOException | URISyntaxException e) {
            return new ArrayList<MusicMediaResult>();
        }
    }

    @Override
    public MusicMediaResult load(String sourceName) throws Exception {
        LavaPlayerManager lm = LavaPlayerManager.getInstance();
        Optional<AudioTrack> otrack = lm.loadTrack(NetEaseCloudMusicManager.getInstance().getMp3Url(sourceName));
        if (otrack.isEmpty() || otrack.get().getInfo().isStream) {
            return null;
        }
        JsonObject sj = NetEaseCloudMusicManager.getInstance().getSongJson(sourceName);
        return this.createResult(sj, sourceName, otrack.get().getDuration());
    }

    private MusicMediaResult createResult(JsonObject songJson, String songId, long duration) {
        Pair<String, List<String>> naa = NetEaseCloudMusicManager.getInstance().getNameAndArtist(songJson);
        return new MusicMediaResult(new MusicSource("netease_cloud_music", songId, duration), new ImageInfo(ImageInfo.ImageType.NETEASE_CLOUD_MUSIC_PICTURE, songId), (String)naa.getLeft(), String.join((CharSequence)", ", (Iterable)naa.getRight()));
    }
}

