/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.com.github.kiulian.downloader.model;

import dev.felnull.imp.include.com.alibaba.fastjson.JSONArray;
import dev.felnull.imp.include.com.alibaba.fastjson.JSONObject;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Utils {
    private static final char[] ILLEGAL_FILENAME_CHARACTERS = new char[]{'/', '\n', '\r', '\t', '\u0000', '\f', '`', '?', '*', '\\', '<', '>', '|', '\"', ':'};

    public static String removeIllegalChars(String fileName) {
        for (char c : ILLEGAL_FILENAME_CHARACTERS) {
            fileName = fileName.replace(c, '_');
        }
        return fileName;
    }

    public static void createOutDir(File outDir) throws IOException {
        boolean mkdirs;
        if (!outDir.exists() && !(mkdirs = outDir.mkdirs())) {
            throw new IOException("Could not create output directory: " + outDir);
        }
    }

    public static void closeSilently(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static int parseLengthSeconds(String text) {
        try {
            int length = 0;
            int beginIndex = 0;
            if (text.length() > 2) {
                int endIndex;
                if (text.length() > 5) {
                    endIndex = text.indexOf(58);
                    length += Integer.parseInt(text.substring(0, endIndex)) * 3600;
                    beginIndex = endIndex + 1;
                }
                endIndex = text.indexOf(58, beginIndex);
                length += Integer.parseInt(text.substring(beginIndex, endIndex)) * 60;
                beginIndex = endIndex + 1;
            }
            return length += Integer.parseInt(text.substring(beginIndex));
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
            return -1;
        }
    }

    public static long parseViewCount(String text) {
        if (text == null || text.isEmpty()) {
            return 0L;
        }
        String value = text.replaceAll("[^0-9]", "");
        if (!value.isEmpty()) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0L;
    }

    public static String parseRuns(JSONObject container) {
        if (container == null) {
            return null;
        }
        JSONArray runs = container.getJSONArray("runs");
        if (runs == null) {
            return null;
        }
        if (runs.size() == 1) {
            return runs.getJSONObject(0).getString("text");
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < runs.size(); ++i) {
            builder.append(runs.getJSONObject(i).getString("text"));
        }
        return builder.toString();
    }

    public static List<String> parseThumbnails(JSONObject container) {
        if (container == null) {
            return null;
        }
        JSONArray jsonThumbnails = container.getJSONArray("thumbnails");
        if (jsonThumbnails == null) {
            return null;
        }
        ArrayList<String> thumbnails = new ArrayList<String>(jsonThumbnails.size());
        for (int i = 0; i < jsonThumbnails.size(); ++i) {
            JSONObject jsonThumbnail = jsonThumbnails.getJSONObject(i);
            if (!jsonThumbnail.containsKey("url")) continue;
            thumbnails.add(jsonThumbnail.getString("url"));
        }
        return thumbnails;
    }
}

