/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.matroska;

import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.MediaContainerDetection;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.MediaContainerDetectionResult;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.MediaContainerHints;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.MediaContainerProbe;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.matroska.MatroskaAudioTrack;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.matroska.MatroskaStreamingFile;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.matroska.format.MatroskaFileTrack;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.io.SeekableInputStream;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioReference;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import dev.felnull.imp.include.org.slf4j.Logger;
import dev.felnull.imp.include.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class MatroskaContainerProbe
implements MediaContainerProbe {
    private static final Logger log = LoggerFactory.getLogger(MatroskaContainerProbe.class);
    public static final String OPUS_CODEC = "A_OPUS";
    public static final String VORBIS_CODEC = "A_VORBIS";
    public static final String AAC_CODEC = "A_AAC";
    private static final int[] EBML_TAG = new int[]{26, 69, 223, 163};
    private static final List<String> supportedCodecs = Arrays.asList("A_OPUS", "A_VORBIS", "A_AAC");

    @Override
    public String getName() {
        return "matroska/webm";
    }

    @Override
    public boolean matchesHints(MediaContainerHints hints) {
        return false;
    }

    @Override
    public MediaContainerDetectionResult probe(AudioReference reference, SeekableInputStream inputStream) throws IOException {
        if (!MediaContainerDetection.checkNextBytes(inputStream, EBML_TAG)) {
            return null;
        }
        log.debug("Track {} is a matroska file.", (Object)reference.identifier);
        MatroskaStreamingFile file = new MatroskaStreamingFile(inputStream);
        file.readFile();
        if (!this.hasSupportedAudioTrack(file)) {
            return MediaContainerDetectionResult.unsupportedFormat(this, "No supported audio tracks present in the file.");
        }
        String title = file.getTitle();
        String actualTitle = title == null || title.isEmpty() ? "Unknown title" : title;
        String artist = file.getArtist();
        String actualArtist = artist == null || artist.isEmpty() ? "Unknown artist" : artist;
        return MediaContainerDetectionResult.supportedFormat(this, null, new AudioTrackInfo(actualTitle, actualArtist, (long)file.getDuration(), reference.identifier, false, reference.identifier, null, null));
    }

    private boolean hasSupportedAudioTrack(MatroskaStreamingFile file) {
        for (MatroskaFileTrack track : file.getTrackList()) {
            if (track.type != MatroskaFileTrack.Type.AUDIO || !supportedCodecs.contains(track.codecId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public AudioTrack createTrack(String parameters, AudioTrackInfo trackInfo, SeekableInputStream inputStream) {
        return new MatroskaAudioTrack(trackInfo, inputStream);
    }
}

