/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.matroska.format;

import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.matroska.format.MatroskaBlock;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.matroska.format.MatroskaEbmlReader;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.matroska.format.MatroskaElement;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.matroska.format.MatroskaElementType;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.matroska.format.MutableMatroskaBlock;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.matroska.format.MutableMatroskaElement;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.io.SeekableInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class MatroskaFileReader {
    private final SeekableInputStream inputStream;
    private final DataInput dataInput;
    private final MutableMatroskaElement[] levels;
    private final MutableMatroskaBlock mutableBlock;

    public MatroskaFileReader(SeekableInputStream inputStream) {
        this.inputStream = inputStream;
        this.dataInput = new DataInputStream(inputStream);
        this.levels = new MutableMatroskaElement[8];
        this.mutableBlock = new MutableMatroskaBlock();
    }

    public MatroskaElement readNextElement(MatroskaElement parent) throws IOException {
        long remaining;
        long position = this.inputStream.getPosition();
        long l = remaining = parent != null ? parent.getRemaining(position) : this.inputStream.getContentLength() - position;
        if (remaining == 0L) {
            return null;
        }
        if (remaining < 0L) {
            throw new IllegalStateException("Current position is beyond this element");
        }
        long id = MatroskaEbmlReader.readEbmlInteger(this.dataInput, null);
        long dataSize = MatroskaEbmlReader.readEbmlInteger(this.dataInput, null);
        long dataPosition = this.inputStream.getPosition();
        int level = parent == null ? 0 : parent.getLevel() + 1;
        MutableMatroskaElement element = this.levels[level];
        if (element == null) {
            element = this.levels[level] = new MutableMatroskaElement(level);
        }
        element.setId(id);
        element.setType(MatroskaElementType.find(id));
        element.setPosition(position);
        element.setHeaderSize((int)(dataPosition - position));
        element.setDataSize((int)dataSize);
        return element;
    }

    public MatroskaBlock readBlockHeader(MatroskaElement parent, int trackFilter) throws IOException {
        if (!this.mutableBlock.parseHeader(this, parent, trackFilter)) {
            return null;
        }
        return this.mutableBlock;
    }

    public int asInteger(MatroskaElement element) throws IOException {
        if (element.is(MatroskaElementType.DataType.UNSIGNED_INTEGER)) {
            long value = MatroskaEbmlReader.readFixedSizeEbmlInteger(this.dataInput, element.dataSize, null);
            if (value < 0L || value > Integer.MAX_VALUE) {
                throw new ArithmeticException("Cannot convert unsigned value to integer.");
            }
            return (int)value;
        }
        if (element.is(MatroskaElementType.DataType.SIGNED_INTEGER)) {
            return Math.toIntExact(MatroskaEbmlReader.readFixedSizeEbmlInteger(this.dataInput, element.dataSize, MatroskaEbmlReader.Type.SIGNED));
        }
        throw new IllegalArgumentException("Not an integer element.");
    }

    public long asLong(MatroskaElement element) throws IOException {
        if (element.is(MatroskaElementType.DataType.UNSIGNED_INTEGER)) {
            return MatroskaEbmlReader.readFixedSizeEbmlInteger(this.dataInput, element.dataSize, null);
        }
        if (element.is(MatroskaElementType.DataType.SIGNED_INTEGER)) {
            return MatroskaEbmlReader.readFixedSizeEbmlInteger(this.dataInput, element.dataSize, MatroskaEbmlReader.Type.SIGNED);
        }
        throw new IllegalArgumentException("Not an integer element.");
    }

    public float asFloat(MatroskaElement element) throws IOException {
        if (element.is(MatroskaElementType.DataType.FLOAT)) {
            if (element.dataSize == 4) {
                return this.dataInput.readFloat();
            }
            if (element.dataSize == 8) {
                return (float)this.dataInput.readDouble();
            }
            throw new IllegalStateException("Float element has invalid size.");
        }
        throw new IllegalArgumentException("Not a float element.");
    }

    public double asDouble(MatroskaElement element) throws IOException {
        if (element.is(MatroskaElementType.DataType.FLOAT)) {
            if (element.dataSize == 4) {
                return this.dataInput.readFloat();
            }
            if (element.dataSize == 8) {
                return this.dataInput.readDouble();
            }
            throw new IllegalStateException("Float element has invalid size.");
        }
        throw new IllegalArgumentException("Not a float element.");
    }

    public String asString(MatroskaElement element) throws IOException {
        if (element.is(MatroskaElementType.DataType.STRING)) {
            return new String(this.asBytes(element), StandardCharsets.US_ASCII);
        }
        if (element.is(MatroskaElementType.DataType.UTF8_STRING)) {
            return new String(this.asBytes(element), StandardCharsets.UTF_8);
        }
        throw new IllegalArgumentException("Not a string element.");
    }

    public byte[] asBytes(MatroskaElement element) throws IOException {
        byte[] bytes = new byte[element.dataSize];
        this.dataInput.readFully(bytes);
        return bytes;
    }

    public void skip(MatroskaElement element) throws IOException {
        long remaining = element.getRemaining(this.inputStream.getPosition());
        if (remaining > 0L) {
            this.inputStream.skipFully(remaining);
        } else if (remaining < 0L) {
            throw new IllegalStateException("Current position is beyond this element");
        }
    }

    public long getPosition() {
        return this.inputStream.getPosition();
    }

    public void seek(long position) throws IOException {
        this.inputStream.seek(position);
    }

    public DataInput getDataInput() {
        return this.dataInput;
    }
}

