/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.nico;

import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.io.PersistentHttpStream;
import dev.felnull.imp.include.org.apache.commons.io.IOUtils;
import dev.felnull.imp.include.org.apache.http.client.methods.CloseableHttpResponse;
import dev.felnull.imp.include.org.apache.http.client.methods.HttpPost;
import dev.felnull.imp.include.org.apache.http.entity.StringEntity;
import dev.felnull.imp.include.org.slf4j.Logger;
import dev.felnull.imp.include.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class HeartbeatingHttpStream
extends PersistentHttpStream {
    private static final Logger log = LoggerFactory.getLogger(HeartbeatingHttpStream.class);
    private static final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private String heartbeatUrl;
    private int heartbeatInterval;
    private String heartbeatPayload;
    private ScheduledFuture<?> heartbeatFuture;

    public HeartbeatingHttpStream(HttpInterface httpInterface, URI contentUrl, Long contentLength, String heartbeatUrl, int heartbeatInterval, String heartbeatPayload) {
        super(httpInterface, contentUrl, contentLength);
        this.heartbeatUrl = heartbeatUrl;
        this.heartbeatInterval = heartbeatInterval;
        this.heartbeatPayload = heartbeatPayload;
        this.setupHeartbeat();
    }

    protected void setupHeartbeat() {
        log.debug("Heartbeat every {} milliseconds to URL: {}", (Object)this.heartbeatInterval, (Object)this.heartbeatUrl);
        this.heartbeatFuture = executor.scheduleAtFixedRate(() -> {
            try {
                this.sendHeartbeat();
            }
            catch (Throwable t) {
                log.error("Heartbeat error!", t);
                IOUtils.closeQuietly(this);
            }
        }, this.heartbeatInterval, this.heartbeatInterval, TimeUnit.MILLISECONDS);
    }

    protected void sendHeartbeat() throws IOException {
        HttpPost request = new HttpPost(this.heartbeatUrl);
        request.addHeader("Host", "api.dmc.nico");
        request.addHeader("Connection", "keep-alive");
        request.addHeader("Content-Type", "application/json");
        request.addHeader("Origin", "https://www.nicovideo.jp");
        request.setEntity(new StringEntity(this.heartbeatPayload));
        try (CloseableHttpResponse response = this.httpInterface.execute(request);){
            HttpClientTools.assertSuccessWithContent(response, "heartbeat page");
            this.heartbeatPayload = JsonBrowser.parse(response.getEntity().getContent()).get("data").format();
        }
    }

    @Override
    public void close() throws IOException {
        this.heartbeatFuture.cancel(false);
        super.close();
    }
}

