/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.youtube;

import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.youtube.DefaultYoutubeTrackDetailsLoader;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import dev.felnull.imp.include.org.slf4j.Logger;
import dev.felnull.imp.include.org.slf4j.LoggerFactory;
import java.util.List;

public class YoutubeTrackJsonData {
    private static final Logger log = LoggerFactory.getLogger(DefaultYoutubeTrackDetailsLoader.class);
    public final JsonBrowser playerResponse;
    public final JsonBrowser polymerArguments;
    public final String playerScriptUrl;

    public YoutubeTrackJsonData(JsonBrowser playerResponse, JsonBrowser polymerArguments, String playerScriptUrl) {
        this.playerResponse = playerResponse;
        this.polymerArguments = polymerArguments;
        this.playerScriptUrl = playerScriptUrl;
    }

    public YoutubeTrackJsonData withPlayerScriptUrl(String playerScriptUrl) {
        return new YoutubeTrackJsonData(this.playerResponse, this.polymerArguments, playerScriptUrl);
    }

    public static YoutubeTrackJsonData fromMainResult(JsonBrowser result) {
        try {
            JsonBrowser playerInfo = JsonBrowser.NULL_BROWSER;
            JsonBrowser playerResponse = JsonBrowser.NULL_BROWSER;
            List<JsonBrowser> json = result.values();
            JsonBrowser lastElement = json.get(result.values().size() - 1);
            if (!lastElement.get("page").isNull()) {
                for (JsonBrowser child : result.values()) {
                    if (!child.isMap()) continue;
                    if (playerInfo.isNull()) {
                        playerInfo = child.get("player");
                    }
                    if (!playerResponse.isNull()) continue;
                    playerResponse = child.get("playerResponse");
                }
            } else if (playerResponse.isNull()) {
                playerResponse = result;
            }
            if (!playerInfo.isNull()) {
                return YoutubeTrackJsonData.fromPolymerPlayerInfo(playerInfo, playerResponse);
            }
            if (!playerResponse.isNull()) {
                return new YoutubeTrackJsonData(playerResponse, JsonBrowser.NULL_BROWSER, null);
            }
        }
        catch (Exception e) {
            throw ExceptionTools.throwWithDebugInfo(log, e, "Error parsing result", "json", result.format());
        }
        throw ExceptionTools.throwWithDebugInfo(log, null, "Neither player nor playerResponse in result", "json", result.format());
    }

    private static YoutubeTrackJsonData fromPolymerPlayerInfo(JsonBrowser playerInfo, JsonBrowser playerResponse) {
        JsonBrowser args = playerInfo.get("args");
        String playerScriptUrl = playerInfo.get("assets").get("js").text();
        String playerResponseText = args.get("player_response").text();
        if (playerResponseText == null) {
            return new YoutubeTrackJsonData(playerResponse, args, playerScriptUrl);
        }
        return new YoutubeTrackJsonData(YoutubeTrackJsonData.parsePlayerResponse(playerResponseText), args, playerScriptUrl);
    }

    private static JsonBrowser parsePlayerResponse(String playerResponseText) {
        try {
            return JsonBrowser.parse(playerResponseText);
        }
        catch (Exception e) {
            throw ExceptionTools.throwWithDebugInfo(log, e, "Failed to parse player_response", "value", playerResponseText);
        }
    }
}

