/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.dev.lavalink.youtube;

import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.io.HttpInterfaceManager;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioItem;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioReference;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import dev.felnull.imp.include.dev.lavalink.youtube.CannotBeLoaded;
import dev.felnull.imp.include.dev.lavalink.youtube.UrlTools;
import dev.felnull.imp.include.dev.lavalink.youtube.cipher.SignatureCipherManager;
import dev.felnull.imp.include.dev.lavalink.youtube.clients.Android;
import dev.felnull.imp.include.dev.lavalink.youtube.clients.Music;
import dev.felnull.imp.include.dev.lavalink.youtube.clients.TvHtml5Embedded;
import dev.felnull.imp.include.dev.lavalink.youtube.clients.Web;
import dev.felnull.imp.include.dev.lavalink.youtube.clients.skeleton.Client;
import dev.felnull.imp.include.dev.lavalink.youtube.http.YoutubeAccessTokenTracker;
import dev.felnull.imp.include.dev.lavalink.youtube.http.YoutubeHttpContextFilter;
import dev.felnull.imp.include.dev.lavalink.youtube.track.YoutubeAudioTrack;
import dev.felnull.imp.include.org.apache.http.client.methods.CloseableHttpResponse;
import dev.felnull.imp.include.org.apache.http.client.methods.HttpGet;
import dev.felnull.imp.include.org.slf4j.Logger;
import dev.felnull.imp.include.org.slf4j.LoggerFactory;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YoutubeAudioSourceManager
implements AudioSourceManager {
    private static final Logger log = LoggerFactory.getLogger(YoutubeAudioSourceManager.class);
    public static final String SEARCH_PREFIX = "ytsearch:";
    public static final String MUSIC_SEARCH_PREFIX = "ytmsearch:";
    private static final String PROTOCOL_REGEX = "(?:http://|https://|)";
    private static final String DOMAIN_REGEX = "(?:www\\.|m\\.|music\\.|)youtube\\.com";
    private static final String SHORT_DOMAIN_REGEX = "(?:www\\.|)youtu\\.be";
    private static final String VIDEO_ID_REGEX = "(?<v>[a-zA-Z0-9_-]{11})";
    private static final String PLAYLIST_ID_REGEX = "(?<list>(PL|UU)[a-zA-Z0-9_-]+)";
    private static final Pattern directVideoIdPattern = Pattern.compile("^(?<v>[a-zA-Z0-9_-]{11})$");
    private static final Pattern directPlaylistIdPattern = Pattern.compile("^(?<list>(PL|UU)[a-zA-Z0-9_-]+)$");
    private static final Pattern mainDomainPattern = Pattern.compile("^(?:http://|https://|)(?:www\\.|m\\.|music\\.|)youtube\\.com/.*");
    private static final Pattern shortHandPattern = Pattern.compile("^(?:http://|https://|)(?:(?:www\\.|m\\.|music\\.|)youtube\\.com/(?:live|embed|shorts)|(?:www\\.|)youtu\\.be)/(?<videoId>.*)");
    protected final HttpInterfaceManager httpInterfaceManager = HttpClientTools.createDefaultThreadLocalManager();
    protected final boolean allowSearch;
    protected final boolean allowDirectVideoIds;
    protected final boolean allowDirectPlaylistIds;
    protected final Client[] clients;
    protected final SignatureCipherManager cipherManager;

    public YoutubeAudioSourceManager() {
        this(true);
    }

    public YoutubeAudioSourceManager(boolean allowSearch) {
        this(allowSearch, true, true);
    }

    public YoutubeAudioSourceManager(boolean allowSearch, boolean allowDirectVideoIds, boolean allowDirectPlaylistIds) {
        this(allowSearch, allowDirectVideoIds, allowDirectPlaylistIds, new Music(), new Web(), new Android(), new TvHtml5Embedded());
    }

    public YoutubeAudioSourceManager(Client ... clients) {
        this(true, true, true, clients);
    }

    public YoutubeAudioSourceManager(boolean allowSearch, Client ... clients) {
        this(allowSearch, true, true, clients);
    }

    public YoutubeAudioSourceManager(boolean allowSearch, boolean allowDirectVideoIds, boolean allowDirectPlaylistIds, Client ... clients) {
        this.allowSearch = allowSearch;
        this.allowDirectVideoIds = allowDirectVideoIds;
        this.allowDirectPlaylistIds = allowDirectPlaylistIds;
        this.clients = clients;
        this.cipherManager = new SignatureCipherManager();
        YoutubeAccessTokenTracker tokenTracker = new YoutubeAccessTokenTracker(this.httpInterfaceManager);
        YoutubeHttpContextFilter youtubeHttpContextFilter = new YoutubeHttpContextFilter();
        youtubeHttpContextFilter.setTokenTracker(tokenTracker);
        this.httpInterfaceManager.setHttpContextFilter(youtubeHttpContextFilter);
    }

    @Override
    public String getSourceName() {
        return "youtube";
    }

    public void setPlaylistPageCount(int count) {
        for (Client client : this.clients) {
            client.setPlaylistPageCount(count);
        }
    }

    @Override
    @Nullable
    public AudioItem loadItem(@NotNull AudioPlayerManager manager, @NotNull AudioReference reference) {
        try {
            return this.loadItemOnce(reference);
        }
        catch (FriendlyException exception) {
            if (HttpClientTools.isRetriableNetworkException(exception.getCause())) {
                return this.loadItemOnce(reference);
            }
            throw exception;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    protected AudioItem loadItemOnce(@NotNull AudioReference reference) {
        Throwable lastException = null;
        try (HttpInterface httpInterface = this.httpInterfaceManager.getInterface();){
            Router router = this.getRouter(httpInterface, reference.identifier);
            if (router == null) {
                AudioItem audioItem = null;
                return audioItem;
            }
            if (router == Router.none) {
                AudioReference audioReference = AudioReference.NO_TRACK;
                return audioReference;
            }
            for (Client client : this.clients) {
                if (!client.canHandleRequest(reference.identifier)) continue;
                log.debug("Attempting to load {} with client \"{}\"", (Object)reference.identifier, (Object)client.getIdentifier());
                try {
                    AudioItem item = router.route(client);
                    if (item == null) continue;
                    AudioItem audioItem = item;
                    return audioItem;
                }
                catch (CannotBeLoaded cbl) {
                    throw ExceptionTools.wrapUnfriendlyExceptions("This video cannot be loaded.", FriendlyException.Severity.SUSPICIOUS, cbl.getCause());
                }
                catch (Throwable t) {
                    log.debug("Client \"{}\" threw a non-fatal exception, storing and proceeding...", (Object)client.getIdentifier(), (Object)t);
                    lastException = t;
                }
            }
        }
        catch (IOException e) {
            throw ExceptionTools.toRuntimeException(e);
        }
        if (lastException == null) return null;
        throw ExceptionTools.wrapUnfriendlyExceptions("This video cannot be loaded.", FriendlyException.Severity.SUSPICIOUS, lastException);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    protected Router getRouter(@NotNull HttpInterface httpInterface, @NotNull String identifier) {
        if (identifier.startsWith(SEARCH_PREFIX)) {
            if (!this.allowSearch) return null;
            String trimmed = identifier.substring(SEARCH_PREFIX.length()).trim();
            if (!trimmed.isEmpty()) return client -> client.loadSearch(this, httpInterface, identifier.substring(SEARCH_PREFIX.length()).trim());
            return Router.none;
        }
        if (identifier.startsWith(MUSIC_SEARCH_PREFIX)) {
            if (!this.allowSearch) return null;
            String trimmed = identifier.substring(MUSIC_SEARCH_PREFIX.length()).trim();
            if (!trimmed.isEmpty()) return client -> client.loadSearchMusic(this, httpInterface, identifier.substring(MUSIC_SEARCH_PREFIX.length()).trim());
            return Router.none;
        }
        Matcher mainDomainMatcher = mainDomainPattern.matcher(identifier);
        if (mainDomainMatcher.matches()) {
            String videoIds;
            UrlTools.UrlInfo urlInfo = UrlTools.getUrlInfo(identifier, false);
            if ("/watch".equals(urlInfo.path)) {
                String videoId = urlInfo.parameters.get("v");
                if (videoId != null) {
                    return this.routeFromVideoId(httpInterface, videoId, urlInfo);
                }
            } else if ("/playlist".equals(urlInfo.path)) {
                String playlistId = urlInfo.parameters.get("list");
                if (playlistId != null) {
                    return client -> client.loadPlaylist(this, httpInterface, playlistId, null);
                }
            } else if ("/watch_videos".equals(urlInfo.path) && (videoIds = urlInfo.parameters.get("video_ids")) != null) {
                try (CloseableHttpResponse response = httpInterface.execute(new HttpGet("https://www.youtube.com/watch_videos?video_ids=" + videoIds));){
                    HttpClientTools.assertSuccessWithContent(response, "playlist response");
                    List<URI> redirects = httpInterface.getContext().getRedirectLocations();
                    if (redirects == null) throw new FriendlyException("Unable to process youtube watch_videos link", FriendlyException.Severity.SUSPICIOUS, new IllegalStateException("Expected youtube to redirect watch_videos link to a watch?v={id}&list={list_id} link, but it did not redirect at all"));
                    if (redirects.isEmpty()) throw new FriendlyException("Unable to process youtube watch_videos link", FriendlyException.Severity.SUSPICIOUS, new IllegalStateException("Expected youtube to redirect watch_videos link to a watch?v={id}&list={list_id} link, but it did not redirect at all"));
                    Router router = this.getRouter(httpInterface, redirects.get(0).toString());
                    return router;
                }
                catch (Exception e) {
                    throw ExceptionTools.wrapUnfriendlyExceptions(e);
                }
            }
        }
        Matcher directVideoIdMatcher = directVideoIdPattern.matcher(identifier);
        if (this.allowDirectVideoIds && directVideoIdMatcher.matches()) {
            return this.routeFromVideoId(httpInterface, identifier, null);
        }
        Matcher playlistIdMatcher = directPlaylistIdPattern.matcher(identifier);
        if (this.allowDirectPlaylistIds && playlistIdMatcher.matches()) {
            return client -> client.loadPlaylist(this, httpInterface, identifier, null);
        }
        Matcher shortHandMatcher = shortHandPattern.matcher(identifier);
        if (!shortHandMatcher.matches()) return null;
        return this.routeFromVideoId(httpInterface, shortHandMatcher.group("videoId"), null);
    }

    @Nullable
    protected Router routeFromVideoId(@NotNull HttpInterface httpInterface, @NotNull String videoId, @Nullable UrlTools.UrlInfo urlInfo) {
        String trimmedId;
        String string = trimmedId = videoId.length() > 11 ? videoId.substring(0, 11) : videoId;
        if (!directVideoIdPattern.matcher(trimmedId).matches()) {
            return Router.none;
        }
        if (urlInfo != null && urlInfo.parameters.containsKey("list")) {
            String playlistId = urlInfo.parameters.get("list");
            if (playlistId.startsWith("RD")) {
                return client -> client.loadMix(this, httpInterface, playlistId, trimmedId);
            }
            if (!(playlistId.startsWith("LL") || playlistId.startsWith("WL") || playlistId.startsWith("LM"))) {
                return client -> client.loadPlaylist(this, httpInterface, playlistId, trimmedId);
            }
        }
        return client -> client.loadVideo(this, httpInterface, trimmedId);
    }

    @NotNull
    public YoutubeAudioTrack buildAudioTrack(AudioTrackInfo trackInfo) {
        return new YoutubeAudioTrack(trackInfo, this);
    }

    @NotNull
    public SignatureCipherManager getCipherManager() {
        return this.cipherManager;
    }

    @Nullable
    public <T extends Client> T getClient(@NotNull Class<T> cls) {
        for (Client client : this.clients) {
            if (!cls.isAssignableFrom(client.getClass())) continue;
            return (T)((Client)cls.cast(client));
        }
        return null;
    }

    @NotNull
    public Client[] getClients() {
        return this.clients;
    }

    @NotNull
    public HttpInterfaceManager getHttpInterfaceManager() {
        return this.httpInterfaceManager;
    }

    @NotNull
    public HttpInterface getInterface() {
        return this.httpInterfaceManager.getInterface();
    }

    @Override
    public boolean isTrackEncodable(AudioTrack track) {
        return true;
    }

    @Override
    public void encodeTrack(AudioTrack track, DataOutput output) {
    }

    @Override
    @NotNull
    public AudioTrack decodeTrack(@NotNull AudioTrackInfo trackInfo, @NotNull DataInput input) {
        return new YoutubeAudioTrack(trackInfo, this);
    }

    @Override
    public void shutdown() {
        ExceptionTools.closeWithWarnings(this.httpInterfaceManager);
    }

    @FunctionalInterface
    protected static interface Router {
        public static final Router none = unused -> AudioReference.NO_TRACK;

        @Nullable
        public AudioItem route(@NotNull Client var1) throws CannotBeLoaded, IOException;
    }
}

