/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.dev.lavalink.youtube.clients.skeleton;

import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.ThumbnailTools;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.Units;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioItem;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import dev.felnull.imp.include.dev.lavalink.youtube.CannotBeLoaded;
import dev.felnull.imp.include.dev.lavalink.youtube.YoutubeAudioSourceManager;
import dev.felnull.imp.include.dev.lavalink.youtube.clients.skeleton.NonMusicClient;
import dev.felnull.imp.include.dev.lavalink.youtube.track.TemporalInfo;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ThumbnailNonMusicClient
extends NonMusicClient {
    @Override
    protected void extractPlaylistTracks(@NotNull JsonBrowser json, @NotNull List<AudioTrack> tracks, @NotNull YoutubeAudioSourceManager source) {
        if (!json.get("contents").isNull()) {
            json = json.get("contents");
        }
        if (json.isNull()) {
            return;
        }
        for (JsonBrowser track : json.values()) {
            JsonBrowser item = track.get("playlistVideoRenderer");
            JsonBrowser authorJson = item.get("shortBylineText");
            if (item.get("isPlayable").isNull() || authorJson.isNull()) continue;
            String videoId = item.get("videoId").text();
            JsonBrowser titleField = item.get("title");
            String title = titleField.get("simpleText").textOrDefault(titleField.get("runs").index(0).get("text").text());
            String author = authorJson.get("runs").index(0).get("text").textOrDefault("Unknown artist");
            long duration = Units.secondsToMillis(item.get("lengthSeconds").asLong(Long.MAX_VALUE));
            String thumbnailUrl = ThumbnailTools.getYouTubeThumbnail(item, videoId);
            AudioTrackInfo info = new AudioTrackInfo(title, author, duration, videoId, false, "https://www.youtube.com/watch?v=" + videoId, thumbnailUrl, null);
            tracks.add(source.buildAudioTrack(info));
        }
    }

    @Override
    @Nullable
    protected AudioTrack extractAudioTrack(@NotNull JsonBrowser json, @NotNull YoutubeAudioSourceManager source) {
        if (json.isNull() || json.get("lengthText").isNull() || !json.get("unplayableText").isNull()) {
            return null;
        }
        String videoId = json.get("videoId").text();
        JsonBrowser titleJson = json.get("title");
        String title = titleJson.get("runs").index(0).get("text").textOrDefault(titleJson.get("simpleText").text());
        String author = json.get("longBylineText").get("runs").index(0).get("text").text();
        JsonBrowser durationJson = json.get("lengthText");
        String durationText = durationJson.get("runs").index(0).get("text").textOrDefault(durationJson.get("simpleText").text());
        long duration = DataFormatTools.durationTextToMillis(durationText);
        String thumbnailUrl = ThumbnailTools.getYouTubeThumbnail(json, videoId);
        AudioTrackInfo info = new AudioTrackInfo(title, author, duration, videoId, false, "https://www.youtube.com/watch?v=" + videoId, thumbnailUrl, null);
        return source.buildAudioTrack(info);
    }

    @Override
    public AudioItem loadVideo(@NotNull YoutubeAudioSourceManager source, @NotNull HttpInterface httpInterface, @NotNull String videoId) throws CannotBeLoaded, IOException {
        JsonBrowser json = this.loadTrackInfoFromInnertube(source, httpInterface, videoId, null);
        JsonBrowser playabilityStatus = json.get("playabilityStatus");
        JsonBrowser videoDetails = json.get("videoDetails");
        String title = videoDetails.get("title").text();
        String author = videoDetails.get("author").text();
        TemporalInfo temporalInfo = TemporalInfo.fromRawData(!playabilityStatus.get("liveStreamability").isNull(), videoDetails.get("lengthSeconds"), false);
        String thumbnailUrl = ThumbnailTools.getYouTubeThumbnail(videoDetails, videoId);
        AudioTrackInfo info = new AudioTrackInfo(title, author, temporalInfo.durationMillis, videoId, temporalInfo.isActiveStream, "https://www.youtube.com/watch?v=" + videoId, thumbnailUrl, null);
        return source.buildAudioTrack(info);
    }
}

