/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.dev.lavalink.youtube.clients.skeleton;

import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import dev.felnull.imp.include.dev.lavalink.youtube.CannotBeLoaded;
import dev.felnull.imp.include.dev.lavalink.youtube.YoutubeAudioSourceManager;
import dev.felnull.imp.include.dev.lavalink.youtube.cipher.SignatureCipherManager;
import dev.felnull.imp.include.dev.lavalink.youtube.clients.skeleton.ThumbnailNonMusicClient;
import dev.felnull.imp.include.dev.lavalink.youtube.track.format.StreamFormat;
import dev.felnull.imp.include.dev.lavalink.youtube.track.format.TrackFormats;
import dev.felnull.imp.include.org.apache.http.entity.ContentType;
import dev.felnull.imp.include.org.slf4j.Logger;
import dev.felnull.imp.include.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class ThumbnailStreamingNonMusicClient
extends ThumbnailNonMusicClient {
    private static final Logger log = LoggerFactory.getLogger(ThumbnailStreamingNonMusicClient.class);
    protected static String DEFAULT_SIGNATURE_KEY = "signature";

    @Override
    public TrackFormats loadFormats(@NotNull YoutubeAudioSourceManager source, @NotNull HttpInterface httpInterface, @NotNull String videoId) throws CannotBeLoaded, IOException {
        JsonBrowser json = this.loadTrackInfoFromInnertube(source, httpInterface, videoId, null);
        JsonBrowser playabilityStatus = json.get("playabilityStatus");
        JsonBrowser videoDetails = json.get("videoDetails");
        SignatureCipherManager.CachedPlayerScript playerScript = source.getCipherManager().getCachedPlayerScript(httpInterface);
        boolean isLive = videoDetails.get("isLive").asBoolean(false);
        if ("OK".equals(playabilityStatus.get("status").text()) && playabilityStatus.get("reason").safeText().contains("This live event has ended")) {
            isLive = true;
        }
        JsonBrowser streamingData = json.get("streamingData");
        JsonBrowser mergedFormats = streamingData.get("formats");
        JsonBrowser adaptiveFormats = streamingData.get("adaptiveFormats");
        ArrayList<StreamFormat> formats = new ArrayList<StreamFormat>();
        boolean anyFailures = false;
        for (JsonBrowser merged : mergedFormats.values()) {
            anyFailures = anyFailures || !this.extractFormat(merged, formats, isLive);
        }
        for (JsonBrowser adaptive : adaptiveFormats.values()) {
            anyFailures = anyFailures || !this.extractFormat(adaptive, formats, isLive);
        }
        if (formats.isEmpty() && anyFailures) {
            log.warn("Loading formats either failed to load or were skipped due to missing fields, json: {}", (Object)streamingData.format());
        }
        return new TrackFormats(formats, playerScript.url);
    }

    protected boolean extractFormat(@NotNull JsonBrowser formatJson, @NotNull List<StreamFormat> formats, boolean isLive) {
        if (formatJson.isNull() || !formatJson.isMap()) {
            return false;
        }
        String url = formatJson.get("url").text();
        String cipher = formatJson.get("signatureCipher").text();
        Map cipherInfo = cipher != null ? DataFormatTools.decodeUrlEncodedItems(cipher, true) : Collections.emptyMap();
        Map<String, String> urlMap = DataFormatTools.isNullOrEmpty(url) ? DataFormatTools.decodeUrlEncodedItems((String)cipherInfo.get("url"), false) : DataFormatTools.decodeUrlEncodedItems(url, false);
        try {
            long contentLength = formatJson.get("contentLength").asLong(Long.MAX_VALUE);
            if (contentLength == Long.MAX_VALUE && !isLive) {
                log.debug("Track is not a live stream, but no contentLength in format {}, skipping", (Object)formatJson.format());
                return true;
            }
            formats.add(new StreamFormat(ContentType.parse(formatJson.get("mimeType").text()), formatJson.get("bitrate").asLong(-1L), contentLength, formatJson.get("audioChannels").asLong(2L), cipherInfo.getOrDefault("url", url), urlMap.get("n"), (String)cipherInfo.get("s"), cipherInfo.getOrDefault("sp", DEFAULT_SIGNATURE_KEY), formatJson.get("audioTrack").get("audioIsDefault").asBoolean(true), formatJson.get("isDrc").asBoolean(false)));
            return true;
        }
        catch (RuntimeException e) {
            log.debug("Failed to parse format {}, skipping", (Object)formatJson, (Object)e);
            return false;
        }
    }
}

