/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.dev.lavalink.youtube.http;

import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.http.HttpContextRetryCounter;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import dev.felnull.imp.include.dev.lavalink.youtube.http.BaseYoutubeHttpContextFilter;
import dev.felnull.imp.include.dev.lavalink.youtube.http.YoutubeAccessTokenTracker;
import dev.felnull.imp.include.org.apache.http.HttpResponse;
import dev.felnull.imp.include.org.apache.http.client.CookieStore;
import dev.felnull.imp.include.org.apache.http.client.methods.HttpUriRequest;
import dev.felnull.imp.include.org.apache.http.client.protocol.HttpClientContext;
import dev.felnull.imp.include.org.apache.http.impl.client.BasicCookieStore;
import dev.felnull.imp.include.org.slf4j.Logger;
import dev.felnull.imp.include.org.slf4j.LoggerFactory;
import org.jetbrains.annotations.NotNull;

public class YoutubeHttpContextFilter
extends BaseYoutubeHttpContextFilter {
    private static final Logger log = LoggerFactory.getLogger(YoutubeHttpContextFilter.class);
    private static final String ATTRIBUTE_RESET_RETRY = "isResetRetry";
    public static final String ATTRIBUTE_USER_AGENT_SPECIFIED = "clientUserAgent";
    private static final HttpContextRetryCounter retryCounter = new HttpContextRetryCounter("yt-token-retry");
    private YoutubeAccessTokenTracker tokenTracker;

    public void setTokenTracker(@NotNull YoutubeAccessTokenTracker tokenTracker) {
        this.tokenTracker = tokenTracker;
    }

    @Override
    public void onContextOpen(HttpClientContext context) {
        CookieStore cookieStore = context.getCookieStore();
        if (cookieStore == null) {
            cookieStore = new BasicCookieStore();
            context.setCookieStore(cookieStore);
        }
        cookieStore.clear();
    }

    @Override
    public void onRequest(HttpClientContext context, HttpUriRequest request, boolean isRepetition) {
        if (!isRepetition) {
            context.removeAttribute(ATTRIBUTE_RESET_RETRY);
        }
        retryCounter.handleUpdate(context, isRepetition);
        if (this.tokenTracker.isTokenFetchContext(context)) {
            return;
        }
        String userAgent = context.getAttribute(ATTRIBUTE_USER_AGENT_SPECIFIED, String.class);
        if (userAgent != null) {
            request.setHeader("User-Agent", userAgent);
            request.setHeader("X-Goog-Visitor-Id", this.tokenTracker.getVisitorId());
            context.removeAttribute(ATTRIBUTE_USER_AGENT_SPECIFIED);
        }
    }

    @Override
    public boolean onRequestResponse(HttpClientContext context, HttpUriRequest request, HttpResponse response) {
        if (response.getStatusLine().getStatusCode() == 429) {
            throw new FriendlyException("This IP address has been blocked by YouTube (429).", FriendlyException.Severity.COMMON, null);
        }
        return false;
    }

    @Override
    public boolean onRequestException(HttpClientContext context, HttpUriRequest request, Throwable error) {
        if (HttpClientTools.isConnectionResetException(error) && context.getAttribute(ATTRIBUTE_RESET_RETRY) == null) {
            context.setAttribute(ATTRIBUTE_RESET_RETRY, true);
            return true;
        }
        return false;
    }
}

