/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.dev.lavalink.youtube.track;

import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.matroska.MatroskaAudioTrack;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.mpeg.MpegAudioTrack;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.io.PersistentHttpStream;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.DelegatedAudioTrack;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.playback.LocalAudioTrackExecutor;
import dev.felnull.imp.include.dev.lavalink.youtube.CannotBeLoaded;
import dev.felnull.imp.include.dev.lavalink.youtube.UrlTools;
import dev.felnull.imp.include.dev.lavalink.youtube.YoutubeAudioSourceManager;
import dev.felnull.imp.include.dev.lavalink.youtube.clients.skeleton.Client;
import dev.felnull.imp.include.dev.lavalink.youtube.track.YoutubeMpegStreamAudioTrack;
import dev.felnull.imp.include.dev.lavalink.youtube.track.YoutubePersistentHttpStream;
import dev.felnull.imp.include.dev.lavalink.youtube.track.format.StreamFormat;
import dev.felnull.imp.include.dev.lavalink.youtube.track.format.TrackFormats;
import dev.felnull.imp.include.org.slf4j.Logger;
import dev.felnull.imp.include.org.slf4j.LoggerFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YoutubeAudioTrack
extends DelegatedAudioTrack {
    private static final Logger log = LoggerFactory.getLogger(YoutubeAudioTrack.class);
    private final YoutubeAudioSourceManager sourceManager;

    public YoutubeAudioTrack(@NotNull AudioTrackInfo trackInfo, @NotNull YoutubeAudioSourceManager sourceManager) {
        super(trackInfo);
        this.sourceManager = sourceManager;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void process(LocalAudioTrackExecutor localExecutor) throws Exception {
        Client[] clients = this.sourceManager.getClients();
        if (Arrays.stream(clients).noneMatch(Client::supportsFormatLoading)) {
            throw new FriendlyException("This video cannot be played", FriendlyException.Severity.COMMON, new RuntimeException("None of the registered clients supports loading of formats"));
        }
        try {
            HttpInterface httpInterface = this.sourceManager.getInterface();
            RuntimeException lastException = null;
            for (Client client : clients) {
                if (!client.supportsFormatLoading()) continue;
                try {
                    this.processWithClient(localExecutor, httpInterface, client, 0L);
                    return;
                }
                catch (FriendlyException e) {
                    lastException = e;
                }
                catch (RuntimeException e) {
                    lastException = e;
                    String message = e.getMessage();
                    if ("Not success status code: 403".equals(message) || "Invalid status code for player api response: 400".equals(message) || message.contains("No supported audio streams available")) continue;
                    throw e;
                }
            }
            if (lastException == null) return;
            if (!(lastException instanceof FriendlyException)) throw ExceptionTools.toRuntimeException(lastException);
            throw lastException;
            finally {
                if (httpInterface != null) {
                    httpInterface.close();
                }
            }
        }
        catch (CannotBeLoaded e) {
            throw ExceptionTools.wrapUnfriendlyExceptions("This video is unavailable", FriendlyException.Severity.COMMON, e.getCause());
        }
    }

    private void processWithClient(LocalAudioTrackExecutor localExecutor, HttpInterface httpInterface, Client client, long streamPosition) throws CannotBeLoaded, Exception {
        FormatWithUrl augmentedFormat = this.loadBestFormatWithUrl(httpInterface, client);
        log.debug("Starting track with URL from client {}: {}", (Object)client.getIdentifier(), (Object)augmentedFormat.signedUrl);
        try {
            if (this.trackInfo.isStream || augmentedFormat.format.getContentLength() == Long.MAX_VALUE) {
                this.processStream(localExecutor, httpInterface, augmentedFormat);
            } else {
                this.processStatic(localExecutor, httpInterface, augmentedFormat, streamPosition);
            }
        }
        catch (StreamExpiredException e) {
            this.processWithClient(localExecutor, httpInterface, client, e.lastStreamPosition);
        }
        catch (RuntimeException e) {
            if ("Not success status code: 403".equals(e.getMessage()) && localExecutor.getPosition() < 3000L) {
                throw e;
            }
            throw e;
        }
    }

    private void processStatic(LocalAudioTrackExecutor localExecutor, HttpInterface httpInterface, FormatWithUrl augmentedFormat, long streamPosition) throws Exception {
        try (PersistentHttpStream stream = null;){
            stream = new YoutubePersistentHttpStream(httpInterface, augmentedFormat.signedUrl, augmentedFormat.format.getContentLength());
            if (streamPosition > 0L) {
                stream.seek(streamPosition);
            }
            if (augmentedFormat.format.getType().getMimeType().endsWith("/webm")) {
                this.processDelegate(new MatroskaAudioTrack(this.trackInfo, stream), localExecutor);
            } else {
                this.processDelegate(new MpegAudioTrack(this.trackInfo, stream), localExecutor);
            }
        }
    }

    private void processStream(LocalAudioTrackExecutor localExecutor, HttpInterface httpInterface, FormatWithUrl augmentedFormat) throws Exception {
        if ("audio/webm".equals(augmentedFormat.format.getType().getMimeType())) {
            throw new FriendlyException("YouTube WebM streams are currently not supported.", FriendlyException.Severity.COMMON, null);
        }
        this.processDelegate(new YoutubeMpegStreamAudioTrack(this.trackInfo, httpInterface, augmentedFormat.signedUrl), localExecutor);
    }

    @NotNull
    private FormatWithUrl loadBestFormatWithUrl(@NotNull HttpInterface httpInterface, @NotNull Client client) throws CannotBeLoaded, Exception {
        if (!client.supportsFormatLoading()) {
            throw new RuntimeException(client.getIdentifier() + " does not support loading of formats!");
        }
        TrackFormats formats = client.loadFormats(this.sourceManager, httpInterface, this.getIdentifier());
        if (formats == null) {
            throw new FriendlyException("This video cannot be played", FriendlyException.Severity.COMMON, null);
        }
        StreamFormat format = formats.getBestFormat();
        URI signedUrl = this.sourceManager.getCipherManager().resolveFormatUrl(httpInterface, formats.getPlayerScriptUrl(), format);
        return new FormatWithUrl(format, signedUrl);
    }

    @Override
    protected AudioTrack makeShallowClone() {
        return new YoutubeAudioTrack(this.trackInfo, this.sourceManager);
    }

    @Override
    public AudioSourceManager getSourceManager() {
        return this.sourceManager;
    }

    @Override
    public boolean isSeekable() {
        return true;
    }

    private static class FormatWithUrl {
        private final StreamFormat format;
        private final URI signedUrl;

        private FormatWithUrl(@NotNull StreamFormat format, @NotNull URI signedUrl) {
            this.format = format;
            this.signedUrl = signedUrl;
        }

        public boolean isExpired() {
            UrlTools.UrlInfo urlInfo = UrlTools.getUrlInfo(this.signedUrl.toString(), true);
            String expire = urlInfo.parameters.get("expire");
            if (expire == null) {
                return false;
            }
            long expiresAbsMillis = Long.parseLong(expire) * 1000L;
            return System.currentTimeMillis() >= expiresAbsMillis;
        }

        @Nullable
        public FormatWithUrl getFallback() {
            String signedString = this.signedUrl.toString();
            Map<String, String> urlParameters = DataFormatTools.decodeUrlEncodedItems(signedString, false);
            String mn = urlParameters.get("mn");
            if (mn == null) {
                return null;
            }
            CharSequence[] hosts = mn.split(",");
            if (hosts.length < 2) {
                log.warn("Cannot fallback, available hosts: {}", (Object)String.join((CharSequence)", ", hosts));
                return null;
            }
            String newUrl = signedString.replaceFirst(hosts[0], (String)hosts[1]);
            try {
                URI uri = new URI(newUrl);
                return new FormatWithUrl(this.format, uri);
            }
            catch (URISyntaxException e) {
                return null;
            }
        }
    }

    private static class StreamExpiredException
    extends RuntimeException {
        private final long lastStreamPosition;

        private StreamExpiredException(long lastStreamPosition, @NotNull Exception cause) {
            super(cause);
            this.lastStreamPosition = lastStreamPosition;
        }
    }
}

