/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.net.sourceforge.jaad.mp4;

import dev.felnull.imp.include.net.sourceforge.jaad.mp4.MP4Input;
import java.io.EOFException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;

public abstract class MP4InputReader
implements MP4Input {
    private static final int BYTE_ORDER_MASK = 65279;

    protected abstract int read() throws IOException;

    protected abstract int read(byte[] var1, int var2, int var3) throws IOException;

    protected abstract long skip(int var1) throws IOException;

    @Override
    public int readByte() throws IOException {
        int i = this.read();
        if (i == -1) {
            throw new EOFException();
        }
        return i;
    }

    @Override
    public void readBytes(byte[] b, int off, int len) throws IOException {
        int i;
        for (int read = 0; read < len; read += i) {
            i = this.read(b, off + read, len - read);
            if (i >= 0) continue;
            throw new EOFException();
        }
    }

    @Override
    public long readBytes(int n) throws IOException {
        if (n < 1 || n > 8) {
            throw new IndexOutOfBoundsException("invalid number of bytes to read: " + n);
        }
        byte[] b = new byte[n];
        this.readBytes(b, 0, n);
        long result = 0L;
        for (int i = 0; i < n; ++i) {
            result = result << 8 | (long)(b[i] & 0xFF);
        }
        return result;
    }

    @Override
    public void readBytes(byte[] b) throws IOException {
        this.readBytes(b, 0, b.length);
    }

    @Override
    public String readString(int n) throws IOException {
        int pos;
        int i = -1;
        char[] c = new char[n];
        for (pos = 0; pos < n; ++pos) {
            i = this.readByte();
            c[pos] = (char)i;
        }
        return new String(c, 0, pos);
    }

    @Override
    public String readUTFString(int max, String encoding) throws IOException {
        return new String(this.readTerminated(max, 0), Charset.forName(encoding));
    }

    @Override
    public String readUTFString(int max) throws IOException {
        byte[] bom = new byte[2];
        this.readBytes(bom, 0, 2);
        if (bom[0] == 0 || bom[1] == 0) {
            return "";
        }
        int i = bom[0] << 8 | bom[1];
        byte[] b = this.readTerminated(max - 2, 0);
        byte[] b2 = new byte[b.length + bom.length];
        System.arraycopy(bom, 0, b2, 0, bom.length);
        System.arraycopy(b, 0, b2, bom.length, b.length);
        return new String(b2, Charset.forName(i == 65279 ? "UTF-16" : "UTF-8"));
    }

    @Override
    public byte[] readTerminated(int max, int terminator) throws IOException {
        byte[] b = new byte[max];
        int pos = 0;
        int i = 0;
        while (pos < max && i != -1) {
            i = this.readByte();
            if (i == -1) continue;
            b[pos++] = (byte)i;
        }
        return Arrays.copyOf(b, pos);
    }

    @Override
    public double readFixedPoint(int m, int n) throws IOException {
        int bits = m + n;
        if (bits % 8 != 0) {
            throw new IllegalArgumentException("number of bits is not a multiple of 8: " + (m + n));
        }
        long l = this.readBytes(bits / 8);
        double x = Math.pow(2.0, n);
        double d = (double)l / x;
        return d;
    }

    @Override
    public void skipBytes(long n) throws IOException {
        for (long l = 0L; l < n; l += this.skip((int)(n - l))) {
        }
    }
}

