/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.net.sourceforge.jaad.mp4;

import dev.felnull.imp.include.net.sourceforge.jaad.mp4.MP4InputReader;
import java.io.IOException;
import java.io.InputStream;

public class MP4InputStream
extends MP4InputReader {
    private final InputStream in;
    private long offset;

    MP4InputStream(InputStream in) {
        this.in = in;
        this.offset = 0L;
    }

    @Override
    protected int read() throws IOException {
        int i = this.in.read();
        if (i >= 0) {
            ++this.offset;
        }
        return i;
    }

    @Override
    protected int read(byte[] b, int off, int len) throws IOException {
        int i = this.in.read(b, off, len);
        if (i > 0) {
            this.offset += (long)i;
        }
        return i;
    }

    @Override
    protected long skip(int n) throws IOException {
        long i = this.in.skip(n);
        if (i > 0L) {
            this.offset += i;
        }
        return i;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public void seek(long pos) throws IOException {
        throw new IOException("could not seek: no random access");
    }

    @Override
    public boolean hasRandomAccess() {
        return false;
    }

    @Override
    public boolean hasLeft() throws IOException {
        return this.in.available() > 0;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

