/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.client.event.v1;

import fuzs.puzzleslib.api.event.v1.core.EventInvoker;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;

public final class ScreenEvents {
    public static final EventInvoker<BeforeInit> BEFORE_INIT = EventInvoker.lookup(BeforeInit.class);
    public static final EventInvoker<AfterInit> AFTER_INIT = EventInvoker.lookup(AfterInit.class);

    private ScreenEvents() {
    }

    public static <T extends Screen> EventInvoker<Remove<T>> remove(Class<T> screen) {
        Objects.requireNonNull(screen, "screen type is null");
        return EventInvoker.lookup(Remove.class, screen);
    }

    public static <T extends Screen> EventInvoker<BeforeRender<T>> beforeRender(Class<T> screen) {
        Objects.requireNonNull(screen, "screen type is null");
        return EventInvoker.lookup(BeforeRender.class, screen);
    }

    public static <T extends Screen> EventInvoker<AfterRender<T>> afterRender(Class<T> screen) {
        Objects.requireNonNull(screen, "screen type is null");
        return EventInvoker.lookup(AfterRender.class, screen);
    }

    @FunctionalInterface
    public static interface Remove<T extends Screen> {
        public void onRemove(T var1);
    }

    @FunctionalInterface
    public static interface BeforeRender<T extends Screen> {
        public void onBeforeRender(T var1, GuiGraphics var2, int var3, int var4, float var5);
    }

    @FunctionalInterface
    public static interface AfterRender<T extends Screen> {
        public void onAfterRender(T var1, GuiGraphics var2, int var3, int var4, float var5);
    }

    @FunctionalInterface
    public static interface BeforeInit {
        public void onBeforeInit(Minecraft var1, Screen var2, int var3, int var4, List<AbstractWidget> var5);
    }

    @FunctionalInterface
    public static interface AfterInit {
        public void onAfterInit(Minecraft var1, Screen var2, int var3, int var4, List<AbstractWidget> var5, Consumer<AbstractWidget> var6, Consumer<AbstractWidget> var7);
    }
}

