/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.config.v3.serialization;

import fuzs.puzzleslib.api.core.v1.Proxy;
import fuzs.puzzleslib.impl.config.serialization.ConfigDataSetImpl;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ConfigDataSet<T>
extends Collection<T> {
    public static final String CONFIG_DESCRIPTION = "Format for every entry is \"<namespace>:<path>\". Tags are supported, must be in the format of \"#<namespace>:<path>\". Namespace may be omitted to use \"minecraft\" by default. May use asterisk as wildcard parameter via pattern matching, e.g. \"minecraft:*_shulker_box\" to match all shulker boxes no matter of color.";

    public Map<T, Object[]> toMap();

    public Set<T> toSet();

    @Nullable
    public Object[] get(T var1);

    public <V> V get(T var1, int var2);

    public <V> Optional<V> getOptional(T var1, int var2);

    @Override
    @Deprecated
    public boolean add(T var1);

    @Override
    @Deprecated
    public boolean remove(Object var1);

    @Override
    @Deprecated
    public boolean addAll(@NotNull Collection<? extends T> var1);

    @Override
    @Deprecated
    public boolean removeAll(@NotNull Collection<?> var1);

    @Override
    @Deprecated
    public boolean retainAll(@NotNull Collection<?> var1);

    @Override
    @Deprecated
    public void clear();

    public static <T> ConfigDataSet<T> from(ResourceKey<? extends Registry<T>> registryKey, List<String> values, Class<?> ... types) {
        return ConfigDataSet.from(registryKey, values, (Integer index, Object value) -> true, types);
    }

    public static <T> ConfigDataSet<T> from(ResourceKey<? extends Registry<T>> registryKey, List<String> values, BiPredicate<Integer, Object> filter, Class<?> ... types) {
        return new ConfigDataSetImpl<T>(ConfigDataSet.findRegistry(registryKey, false), values, filter, types);
    }

    @SafeVarargs
    public static <T> List<String> toString(ResourceKey<? extends Registry<T>> registryKey, T ... entries) {
        Registry<T> registry = ConfigDataSet.findRegistry(registryKey, false);
        return Stream.of(entries).peek(Objects::requireNonNull).map(arg_0 -> registry.m_7981_(arg_0)).filter(Objects::nonNull).map(ResourceLocation::toString).collect(Collectors.toList());
    }

    public static <T> Registry<T> findRegistry(ResourceKey<? extends Registry<T>> registryKey, boolean dynamicRegistries) {
        Registry registry = (Registry)BuiltInRegistries.f_257047_.m_7745_(registryKey.m_135782_());
        if (registry != null) {
            return registry;
        }
        if (dynamicRegistries && Proxy.INSTANCE.getGameServer() != null && (registry = (Registry)Proxy.INSTANCE.getGameServer().m_206579_().m_6632_(registryKey).orElse(null)) != null) {
            return registry;
        }
        throw new IllegalArgumentException("Registry for key %s not found".formatted(registryKey));
    }
}

