/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.resources.v1;

import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.function.Supplier;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.BuiltInMetadata;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.world.flag.FeatureFlagSet;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractModPackResources
implements PackResources {
    private String logoModId;
    private final String modLogoPath;
    private String id;
    private BuiltInMetadata metadata;

    protected AbstractModPackResources() {
        this(null);
    }

    protected AbstractModPackResources(@Nullable String logoModId) {
        this(logoModId, "mod_logo.png");
    }

    protected AbstractModPackResources(@Nullable String logoModId, String modLogoPath) {
        this.logoModId = logoModId;
        this.modLogoPath = modLogoPath;
    }

    @Nullable
    public IoSupplier<InputStream> m_8017_(String ... elements) {
        String path = String.join((CharSequence)"/", elements);
        if ("pack.png".equals(path)) {
            return ModLoaderEnvironment.INSTANCE.findModResource(this.logoModId, this.modLogoPath).map(modResource -> () -> Files.newInputStream(modResource, new OpenOption[0])).orElse(null);
        }
        return null;
    }

    public void m_8031_(PackType packType, String namespace, String path, PackResources.ResourceOutput resourceOutput) {
    }

    @Nullable
    public <T> T m_5550_(MetadataSectionSerializer<T> deserializer) {
        return (T)this.metadata.m_245920_(deserializer);
    }

    public String m_5542_() {
        return this.id;
    }

    public boolean m_246538_() {
        return true;
    }

    public void close() {
    }

    @ApiStatus.Internal
    static Pack buildPack(PackType packType, Supplier<AbstractModPackResources> factory, String id, Component title, Component description, boolean required, boolean fixedPosition) {
        PackMetadataSection metadataSection = new PackMetadataSection(description, SharedConstants.m_183709_().m_264084_(packType));
        BuiltInMetadata metadata = BuiltInMetadata.m_246652_((MetadataSectionSerializer)PackMetadataSection.f_243696_, (Object)metadataSection);
        Pack.Info info = new Pack.Info(description, metadataSection.m_10374_(), FeatureFlagSet.m_246902_());
        return Pack.m_245512_((String)id, (Component)title, (boolean)required, $ -> {
            AbstractModPackResources packResources = (AbstractModPackResources)factory.get();
            packResources.id = id;
            packResources.metadata = metadata;
            if (packResources.logoModId == null) {
                packResources.logoModId = id;
            }
            return packResources;
        }, (Pack.Info)info, (PackType)packType, (Pack.Position)Pack.Position.TOP, (boolean)fixedPosition, (PackSource)PackSource.f_10528_);
    }
}

