/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.core;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.mojang.serialization.Codec;
import fuzs.puzzleslib.api.biome.v1.BiomeLoadingContext;
import fuzs.puzzleslib.api.biome.v1.BiomeLoadingPhase;
import fuzs.puzzleslib.api.biome.v1.BiomeModificationContext;
import fuzs.puzzleslib.impl.biome.BiomeLoadingContextForge;
import fuzs.puzzleslib.impl.biome.ClimateSettingsContextForge;
import fuzs.puzzleslib.impl.biome.GenerationSettingsContextForge;
import fuzs.puzzleslib.impl.biome.MobSpawnSettingsContextForge;
import fuzs.puzzleslib.impl.biome.SpecialEffectsContextForge;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class BiomeLoadingHandler {
    private static final Map<BiomeModifier.Phase, BiomeLoadingPhase> BIOME_MODIFIER_PHASE_CONVERSIONS = Maps.immutableEnumMap((Map)new HashMap<BiomeModifier.Phase, BiomeLoadingPhase>(){
        {
            this.put(BiomeModifier.Phase.ADD, BiomeLoadingPhase.ADDITIONS);
            this.put(BiomeModifier.Phase.REMOVE, BiomeLoadingPhase.REMOVALS);
            this.put(BiomeModifier.Phase.MODIFY, BiomeLoadingPhase.MODIFICATIONS);
            this.put(BiomeModifier.Phase.AFTER_EVERYTHING, BiomeLoadingPhase.POST_PROCESSING);
        }
    });

    public static void register(String modId, IEventBus modEventBus, Multimap<BiomeLoadingPhase, BiomeModification> biomeModifications) {
        DeferredRegister deferredRegister = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)modId);
        deferredRegister.register(modEventBus);
        deferredRegister.register("biome_modifications", new BiomeModifierImpl(biomeModifications)::codec);
    }

    private record BiomeModifierImpl(Multimap<BiomeLoadingPhase, BiomeModification> biomeModifications, Codec<? extends BiomeModifier> codec) implements BiomeModifier
    {
        private BiomeModifierImpl(Multimap<BiomeLoadingPhase, BiomeModification> biomeModifications, @Nullable Codec<? extends BiomeModifier> codec) {
            this.biomeModifications = biomeModifications;
            this.codec = Codec.unit((Object)this);
        }

        public BiomeModifierImpl(Multimap<BiomeLoadingPhase, BiomeModification> biomeModifications) {
            this(biomeModifications, null);
        }

        private static BiomeModificationContext createBuilderBackedContext(ModifiableBiomeInfo.BiomeInfo.Builder builder) {
            ClimateSettingsContextForge climateSettings = new ClimateSettingsContextForge(builder.getClimateSettings());
            SpecialEffectsContextForge specialEffects = new SpecialEffectsContextForge(builder.getSpecialEffects());
            GenerationSettingsContextForge generationSettings = GenerationSettingsContextForge.create(builder.getGenerationSettings());
            MobSpawnSettingsContextForge mobSpawnSettings = new MobSpawnSettingsContextForge(builder.getMobSpawnSettings());
            return new BiomeModificationContext(climateSettings, specialEffects, generationSettings, mobSpawnSettings);
        }

        public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
            BiomeLoadingPhase loadingPhase = BIOME_MODIFIER_PHASE_CONVERSIONS.get(phase);
            if (loadingPhase == null) {
                return;
            }
            Collection modifications = this.biomeModifications.get((Object)loadingPhase);
            if (modifications.isEmpty()) {
                return;
            }
            BiomeLoadingContext filter = BiomeLoadingContextForge.create(biome);
            BiomeModificationContext context = BiomeModifierImpl.createBuilderBackedContext(builder);
            for (BiomeModification modification : modifications) {
                modification.tryApply(filter, context);
            }
        }
    }

    public record BiomeModification(Predicate<BiomeLoadingContext> selector, Consumer<BiomeModificationContext> modifier) {
        public void tryApply(BiomeLoadingContext filter, BiomeModificationContext context) {
            if (this.selector().test(filter)) {
                this.modifier().accept(context);
            }
        }
    }
}

