/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.init;

import fuzs.puzzleslib.api.init.v2.PotionBrewingRegistry;
import fuzs.puzzleslib.mixin.accessor.PotionBrewingForgeAccessor;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.common.brewing.VanillaBrewingRecipe;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public final class PotionBrewingRegistryForge
implements PotionBrewingRegistry {
    @Override
    public void registerContainerRecipe(PotionItem from, Ingredient ingredient, PotionItem to) {
        Objects.requireNonNull(ingredient, "ingredient is null");
        Objects.requireNonNull(from, "from item is null");
        Objects.requireNonNull(to, "to item is null");
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new MixBrewingRecipe<Item>(ForgeRegistries.ITEMS, (Item)from, ingredient, (Item)to){

            @Override
            Optional<ItemStack> mix(PotionBrewing.Mix<Item> mix, ItemStack ingredient, Potion potion, Item item) {
                if (mix.f_43532_.get() == item && mix.f_43533_.test(ingredient)) {
                    return Optional.of(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)mix.f_43534_.get()), (Potion)potion));
                }
                return Optional.empty();
            }
        });
    }

    @Override
    public synchronized void registerPotionContainer(PotionItem container) {
        Objects.requireNonNull(container, "container is null");
        PotionBrewingForgeAccessor.puzzleslib$getAllowedContainers().add(Ingredient.m_43929_((ItemLike[])new ItemLike[]{container}));
    }

    @Override
    public void registerPotionRecipe(Potion from, Ingredient ingredient, Potion to) {
        Objects.requireNonNull(ingredient, "ingredient is null");
        Objects.requireNonNull(from, "from potion is null");
        Objects.requireNonNull(to, "to potion is null");
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new MixBrewingRecipe<Potion>(ForgeRegistries.POTIONS, from, ingredient, to){

            @Override
            Optional<ItemStack> mix(PotionBrewing.Mix<Potion> mix, ItemStack ingredient, Potion potion, Item item) {
                if (mix.f_43532_.get() == potion && mix.f_43533_.test(ingredient)) {
                    return Optional.of(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)item), (Potion)((Potion)mix.f_43534_.get())));
                }
                return Optional.empty();
            }
        });
    }

    private static abstract class MixBrewingRecipe<T>
    extends VanillaBrewingRecipe {
        private final PotionBrewing.Mix<T> mix;

        public MixBrewingRecipe(IForgeRegistry<T> registry, T from, Ingredient ingredient, T to) {
            this.mix = new PotionBrewing.Mix(registry, from, ingredient, to);
        }

        public boolean isIngredient(ItemStack stack) {
            return this.mix.f_43533_.test(stack);
        }

        public ItemStack getOutput(ItemStack input, ItemStack ingredient) {
            if (!input.m_41619_()) {
                Potion potion = PotionUtils.m_43579_((ItemStack)input);
                Item item = input.m_41720_();
                return this.mix(this.mix, ingredient, potion, item).orElse(ItemStack.f_41583_);
            }
            return ItemStack.f_41583_;
        }

        abstract Optional<ItemStack> mix(PotionBrewing.Mix<T> var1, ItemStack var2, Potion var3, Item var4);
    }
}

