/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.fluids;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.fluids.BuiltInSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.FluidContainerList;
import net.mehvahdjukaar.moonlight.api.fluids.FoodProvider;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidColors;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.fluids.forge.SoftFluidStackImpl;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.PotionNBTHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.fluid.SoftFluidInternal;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoftFluidStack {
    public static final Codec<SoftFluidStack> CODEC = RecordCodecBuilder.create(i -> i.group((App)SoftFluid.HOLDER_CODEC.fieldOf("id").forGetter(SoftFluidStack::getHolder), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(SoftFluidStack::getCount), (App)CompoundTag.f_128325_.optionalFieldOf("tag", null).forGetter(SoftFluidStack::getTag)).apply((Applicative)i, SoftFluidStack::of));
    private static SoftFluidStack cachedEmptyInstance = null;
    private final Holder<SoftFluid> fluidHolder;
    private final SoftFluid fluid;
    private int count;
    @Nullable
    private CompoundTag tag;
    private boolean isEmptyCache;

    @Deprecated(forRemoval=true)
    @ApiStatus.Internal
    public SoftFluidStack(Holder<SoftFluid> fluid, int count, @Nullable CompoundTag tag) {
        this.fluidHolder = fluid;
        this.fluid = (SoftFluid)this.fluidHolder.m_203334_();
        this.tag = tag;
        this.setCount(count);
        if (fluid.m_203373_(BuiltInSoftFluids.POTION.getID()) && (this.tag == null || PotionNBTHelper.getPotionType(this.tag) == null)) {
            PotionNBTHelper.Type.REGULAR.applyToTag(this.getOrCreateTag());
        }
    }

    @Deprecated(forRemoval=true)
    public SoftFluidStack(Holder<SoftFluid> fluid, int count) {
        this(fluid, count, null);
    }

    @Deprecated(forRemoval=true)
    public SoftFluidStack(Holder<SoftFluid> fluid) {
        this(fluid, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static SoftFluidStack of(Holder<SoftFluid> fluid, int count, @Nullable CompoundTag tag) {
        void var2_2;
        void var1_1;
        return SoftFluidStackImpl.of(fluid, (int)var1_1, (CompoundTag)var2_2);
    }

    public static SoftFluidStack of(Holder<SoftFluid> fluid, int count) {
        return SoftFluidStack.of(fluid, count, null);
    }

    public static SoftFluidStack of(Holder<SoftFluid> fluid) {
        return SoftFluidStack.of(fluid, 1, null);
    }

    public static SoftFluidStack bucket(Holder<SoftFluid> fluid) {
        return SoftFluidStack.of(fluid, SoftFluid.BUCKET_COUNT);
    }

    public static SoftFluidStack bowl(Holder<SoftFluid> fluid) {
        return SoftFluidStack.of(fluid, SoftFluid.BOWL_COUNT);
    }

    public static SoftFluidStack bottle(Holder<SoftFluid> fluid) {
        return SoftFluidStack.of(fluid, SoftFluid.BOTTLE_COUNT);
    }

    public static SoftFluidStack empty() {
        if (cachedEmptyInstance == null) {
            cachedEmptyInstance = SoftFluidStack.of(SoftFluidRegistry.getEmpty(), 0, null);
        }
        return cachedEmptyInstance;
    }

    @ApiStatus.Internal
    public static void invalidateEmptyInstance() {
        cachedEmptyInstance = null;
    }

    public CompoundTag save(CompoundTag compoundTag) {
        compoundTag.m_128359_("id", ((ResourceKey)this.getHolder().m_203543_().get()).m_135782_().toString());
        compoundTag.m_128344_("count", (byte)this.count);
        if (this.tag != null) {
            compoundTag.m_128365_("tag", (Tag)this.tag.m_6426_());
        }
        return compoundTag;
    }

    public static SoftFluidStack load(CompoundTag tag) {
        if (tag.m_128441_("Fluid")) {
            tag.m_128359_("id", tag.m_128461_("Fluid"));
            tag.m_128473_("Fluid");
        }
        if (tag.m_128441_("NBT")) {
            tag.m_128365_("tag", tag.m_128423_("NBT"));
            tag.m_128473_("NBT");
        }
        if (tag.m_128441_("Count")) {
            tag.m_128344_("count", (byte)tag.m_128451_("Count"));
            tag.m_128473_("count");
        }
        Holder<SoftFluid> fluid = SoftFluidRegistry.getHolder(new ResourceLocation(tag.m_128461_("id")));
        byte amount = tag.m_128445_("count");
        CompoundTag nbt = null;
        if (tag.m_128425_("tag", 10)) {
            nbt = tag.m_128469_("tag");
        }
        return SoftFluidStack.of(fluid, amount, nbt);
    }

    public boolean is(TagKey<SoftFluid> tag) {
        return this.getHolder().m_203656_(tag);
    }

    public boolean is(SoftFluid fluid) {
        return this.fluid() == fluid;
    }

    public boolean is(Holder<SoftFluid> fluid) {
        return this.is((SoftFluid)fluid.m_203334_());
    }

    @Deprecated(forRemoval=true)
    public final Holder<SoftFluid> getFluid() {
        return this.isEmptyCache ? SoftFluidRegistry.getEmpty() : this.fluidHolder;
    }

    public final Holder<SoftFluid> getHolder() {
        return this.isEmptyCache ? SoftFluidRegistry.getEmpty() : this.fluidHolder;
    }

    public final SoftFluid fluid() {
        return this.isEmptyCache ? SoftFluidRegistry.empty() : this.fluid;
    }

    public boolean isEmpty() {
        return this.isEmptyCache;
    }

    protected void updateEmpty() {
        this.isEmptyCache = this.fluid.isEmptyFluid() || this.count <= 0;
    }

    public int getCount() {
        return this.isEmptyCache ? 0 : this.count;
    }

    public void setCount(int count) {
        if (this == cachedEmptyInstance) {
            if (PlatHelper.isDev()) {
                throw new AssertionError();
            }
            return;
        }
        this.count = count;
        this.updateEmpty();
    }

    public void grow(int amount) {
        this.setCount(this.count + amount);
    }

    public void shrink(int amount) {
        this.setCount(this.count - amount);
    }

    public boolean hasTag() {
        return this.tag != null;
    }

    @Nullable
    public CompoundTag getTag() {
        return this.tag;
    }

    public void setTag(@Nullable CompoundTag tag) {
        if (this == cachedEmptyInstance) {
            if (PlatHelper.isDev()) {
                throw new AssertionError();
            }
            return;
        }
        this.tag = tag;
    }

    public CompoundTag getOrCreateTag() {
        if (this.tag == null) {
            this.setTag(new CompoundTag());
        }
        return this.tag;
    }

    public CompoundTag getOrCreateTagElement(String key) {
        if (this.tag != null && this.tag.m_128425_(key, 10)) {
            return this.tag.m_128469_(key);
        }
        CompoundTag compoundTag = new CompoundTag();
        this.addTagElement(key, (Tag)compoundTag);
        return compoundTag;
    }

    public void addTagElement(String key, Tag tag) {
        this.getOrCreateTag().m_128365_(key, tag);
    }

    public SoftFluidStack copy() {
        return SoftFluidStack.of(this.getHolder(), this.count, this.tag == null ? null : this.tag.m_6426_());
    }

    public SoftFluidStack copyWithCount(int count) {
        SoftFluidStack stack = this.copy();
        if (!stack.isEmpty()) {
            stack.setCount(count);
        }
        return stack;
    }

    public SoftFluidStack split(int amount) {
        int i = Math.min(amount, this.getCount());
        SoftFluidStack stack = this.copyWithCount(i);
        if (!this.isEmpty()) {
            this.shrink(i);
        }
        return stack;
    }

    public boolean isFluidEqual(SoftFluidStack other) {
        return this.fluid() == other.fluid() && this.isFluidStackTagEqual(other);
    }

    public boolean isFluidStackTagEqual(SoftFluidStack other) {
        return Objects.equals(this.tag, other.tag);
    }

    public final int hashCode() {
        int code = 1;
        code = 31 * code + this.fluid().hashCode();
        if (this.tag != null) {
            code = 31 * code + this.tag.hashCode();
        }
        return code;
    }

    public final boolean equals(Object o) {
        if (o instanceof SoftFluidStack) {
            SoftFluidStack ss = (SoftFluidStack)o;
            return this.isFluidEqual(ss);
        }
        return false;
    }

    public String toString() {
        String s = this.count + " " + ((ResourceKey)this.getHolder().m_203543_().get()).m_135782_();
        if (this.tag != null) {
            s = s + " [" + this.tag + "]";
        }
        return s;
    }

    @NotNull
    public static SoftFluidStack fromFluid(Fluid fluid, int amount, @Nullable CompoundTag tag) {
        Holder<SoftFluid> f = SoftFluidInternal.FLUID_MAP.get(fluid);
        if (f == null) {
            return SoftFluidStack.empty();
        }
        return SoftFluidStack.of(f, amount, tag);
    }

    @NotNull
    public static SoftFluidStack fromFluid(FluidState fluid) {
        if (fluid.m_205070_(FluidTags.f_13131_)) {
            return SoftFluidStack.fromFluid(fluid.m_76152_(), 3, null);
        }
        return SoftFluidStack.fromFluid(fluid.m_76152_(), SoftFluid.BUCKET_COUNT, null);
    }

    @Nullable
    public static Pair<SoftFluidStack, FluidContainerList.Category> fromItem(ItemStack itemStack) {
        Optional<FluidContainerList.Category> category;
        Item filledContainer = itemStack.m_41720_();
        Holder<SoftFluid> fluid = SoftFluidInternal.ITEM_MAP.get(filledContainer);
        if (fluid != null && !((SoftFluid)fluid.m_203334_()).isEmptyFluid() && (category = ((SoftFluid)fluid.m_203334_()).getContainerList().getCategoryFromFilled(filledContainer)).isPresent()) {
            boolean hasCustomPot;
            int count = category.get().getAmount();
            CompoundTag fluidTag = new CompoundTag();
            CompoundTag itemTag = itemStack.m_41783_();
            Potion potion = PotionUtils.m_43579_((ItemStack)itemStack);
            boolean bl = hasCustomPot = itemTag != null && itemTag.m_128441_("CustomPotionEffects");
            if (potion == Potions.f_43599_ && !hasCustomPot) {
                fluid = BuiltInSoftFluids.WATER.getHolder();
            } else if (potion != Potions.f_43598_ || hasCustomPot) {
                PotionNBTHelper.Type type = PotionNBTHelper.getPotionType(filledContainer);
                if (type == null) {
                    type = PotionNBTHelper.Type.REGULAR;
                }
                type.applyToTag(fluidTag);
            }
            if (itemTag != null) {
                for (String k : ((SoftFluid)fluid.m_203334_()).getNbtKeyFromItem()) {
                    Tag c = itemTag.m_128423_(k);
                    if (c == null) continue;
                    fluidTag.m_128365_(k, c);
                }
            }
            if (fluidTag.m_128456_()) {
                fluidTag = null;
            }
            return Pair.of((Object)SoftFluidStack.of(fluid, count, fluidTag), (Object)category.get());
        }
        return null;
    }

    @Nullable
    public Pair<ItemStack, FluidContainerList.Category> toItem(ItemStack emptyContainer, boolean dontModifyStack) {
        FluidContainerList.Category category;
        int shrinkAmount;
        Optional<FluidContainerList.Category> opt = this.fluid().getContainerList().getCategoryFromEmpty(emptyContainer.m_41720_());
        if (opt.isPresent() && (shrinkAmount = (category = opt.get()).getAmount()) <= this.getCount()) {
            PotionNBTHelper.Type type;
            ItemStack filledStack = new ItemStack((ItemLike)category.getFirstFilled().get());
            if (this.is(BuiltInSoftFluids.POTION.getHolder()) && this.tag != null && (type = PotionNBTHelper.getPotionType(this.tag)) != null && !Utils.getID(emptyContainer.m_41720_()).m_135827_().equals("inspirations") && type != PotionNBTHelper.Type.REGULAR) {
                filledStack = type.getDefaultItem();
            }
            if (emptyContainer.m_150930_(Items.f_42590_) && this.is(BuiltInSoftFluids.WATER.get())) {
                filledStack = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_);
            }
            this.applyNBTtoItemStack(filledStack);
            if (!dontModifyStack) {
                this.shrink(shrinkAmount);
            }
            return Pair.of((Object)filledStack, (Object)category);
        }
        return null;
    }

    protected void applyNBTtoItemStack(ItemStack stack) {
        List<String> nbtKey = this.fluid().getNbtKeyFromItem();
        if (this.tag != null && !this.tag.m_128456_()) {
            CompoundTag newCom = new CompoundTag();
            for (String s : nbtKey) {
                Tag c = this.tag.m_128423_(s);
                if (c == null || s.equals("Bottle")) continue;
                newCom.m_128365_(s, c);
            }
            if (!newCom.m_128456_()) {
                stack.m_41751_(newCom);
            }
        }
    }

    public FluidContainerList getContainerList() {
        return this.fluid().getContainerList();
    }

    public FoodProvider getFoodProvider() {
        return this.fluid().getFoodProvider();
    }

    public boolean isEquivalent(Fluid fluid) {
        return this.fluid().isEquivalent(fluid);
    }

    public Fluid getVanillaFluid() {
        return this.fluid().getVanillaFluid();
    }

    public int getStillColor(@Nullable BlockAndTintGetter world, @Nullable BlockPos pos) {
        SoftFluid fluid = this.fluid();
        SoftFluid.TintMethod method = fluid.getTintMethod();
        if (method == SoftFluid.TintMethod.NO_TINT) {
            return -1;
        }
        int specialColor = SoftFluidColors.getSpecialColor(this, world, pos);
        if (specialColor != 0) {
            return specialColor;
        }
        return fluid.getTintColor();
    }

    public int getFlowingColor(@Nullable BlockAndTintGetter world, @Nullable BlockPos pos) {
        SoftFluid.TintMethod method = this.fluid().getTintMethod();
        if (method == SoftFluid.TintMethod.FLOWING) {
            return this.getParticleColor(world, pos);
        }
        return this.getStillColor(world, pos);
    }

    public int getParticleColor(@Nullable BlockAndTintGetter world, @Nullable BlockPos pos) {
        int tintColor = this.getStillColor(world, pos);
        if (tintColor == -1) {
            return this.fluid().getAverageTextureTintColor();
        }
        return tintColor;
    }
}

