/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.lootjournal.client;

import com.obscuria.lootjournal.LootJournalConfig;
import com.obscuria.lootjournal.client.TabsAccessor;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.CreativeModeTabRegistry;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public final class Filtering {
    public static boolean isAllowed(ItemStack stack) {
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
        if (Filtering.itemsWhitelist().contains(id)) {
            return true;
        }
        if (Filtering.tabsWhitelist().contains(id)) {
            return true;
        }
        if (((Boolean)LootJournalConfig.blacklistedByDefault.get()).booleanValue()) {
            return false;
        }
        if (Filtering.itemsBlacklist().contains(id)) {
            return false;
        }
        return !Filtering.tabsBlacklist().contains(id);
    }

    private static List<ResourceLocation> itemsWhitelist() {
        return Filtering.unwrapIds((List)LootJournalConfig.itemsWhitelist.get()).toList();
    }

    private static List<ResourceLocation> itemsBlacklist() {
        return Filtering.unwrapIds((List)LootJournalConfig.itemsBlacklist.get()).toList();
    }

    private static List<ResourceLocation> tabsWhitelist() {
        return Filtering.unwrapIds((List)LootJournalConfig.tabsWhitelist.get()).flatMap(Filtering::mapToTab).flatMap(Filtering::mapToContent).toList();
    }

    private static List<ResourceLocation> tabsBlacklist() {
        return Filtering.unwrapIds((List)LootJournalConfig.tabsBlacklist.get()).flatMap(Filtering::mapToTab).flatMap(Filtering::mapToContent).toList();
    }

    private static void tryRebuildTabContents() {
        TabsAccessor accessor;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        CreativeModeTabs tabs = new CreativeModeTabs();
        if (player != null && tabs instanceof TabsAccessor && (accessor = (TabsAccessor)tabs).lootJournal$ShouldRebuild()) {
            CreativeModeTabs.m_269226_((FeatureFlagSet)FeatureFlags.f_244332_, (boolean)false, (HolderLookup.Provider)player.m_9236_().m_9598_());
        }
    }

    private static Stream<ResourceLocation> unwrapIds(List<? extends String> list) {
        return list.stream().map(ResourceLocation::new);
    }

    private static Stream<CreativeModeTab> mapToTab(ResourceLocation id) {
        CreativeModeTab result = CreativeModeTabRegistry.getTab((ResourceLocation)id);
        return result == null ? Stream.empty() : Stream.of(result);
    }

    private static Stream<ResourceLocation> mapToContent(CreativeModeTab tab) {
        Filtering.tryRebuildTabContents();
        return tab.m_260957_().stream().map(stack -> ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()));
    }
}

