/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.lootjournal.client.pickup;

import com.obscuria.lootjournal.client.pickup.Pickup;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MoreItemsPickup
extends Pickup {
    protected List<ItemStack> stacks = new ArrayList<ItemStack>();
    protected int count;

    public static MoreItemsPickup of(ItemStack stack) {
        return new MoreItemsPickup(stack);
    }

    protected MoreItemsPickup(ItemStack stack) {
        this.stacks.add(stack);
        this.count = stack.m_41613_();
    }

    @Override
    public boolean merge(Pickup pickup) {
        if (pickup instanceof MoreItemsPickup) {
            MoreItemsPickup other = (MoreItemsPickup)pickup;
            this.stacks.addAll(other.stacks);
            this.count += other.count;
            return true;
        }
        return false;
    }

    @Override
    public MutableComponent getName() {
        return Component.m_237110_((String)"pickup.loot_journal.other_items", (Object[])new Object[]{this.count}).m_130940_(ChatFormatting.WHITE);
    }

    @Override
    public boolean shouldRenderTotal() {
        return false;
    }

    @Override
    public int getTotal() {
        return 0;
    }

    @Override
    public void renderIcon(GuiGraphics graphics, long time) {
        if (this.stacks.isEmpty()) {
            return;
        }
        int interval = Math.max(200, 1000 - 50 * this.stacks.size());
        ItemStack stack = this.stacks.get((int)(time / (long)interval % (long)this.stacks.size()));
        graphics.m_280203_(stack, -8, -8);
    }
}

