/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.lootjournal.client.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.obscuria.lootjournal.client.pickup.Pickup;
import com.obscuria.lootjournal.client.renderer.Anchor;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public enum Style {
    DEFAULT(Style::renderStyleDefault),
    FLAT(Style::renderStyleFlat),
    NO_BACKGROUND(Style::renderStyleNoBackground);

    private static final ResourceLocation DECORATIONS;
    private final RenderFunc renderFunc;

    private Style(RenderFunc renderFunc) {
        this.renderFunc = renderFunc;
    }

    public void render(Pickup pickup, GuiGraphics graphics, Anchor anchor, int x, int y, double factor, long time) {
        Font font = Minecraft.m_91087_().f_91062_;
        double actualX = (double)x + Style.getOffset(factor, anchor.isInverted());
        MutableComponent name = pickup.getName();
        int nameWidth = font.m_92852_((FormattedText)name);
        MutableComponent total = pickup.shouldRenderTotal() ? Component.m_237113_((String)String.valueOf(pickup.getTotal())) : Component.m_237119_();
        int totalWidth = pickup.shouldRenderTotal() ? font.m_92852_((FormattedText)total) + 5 : 0;
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85837_(actualX, (double)y, 400.0);
        RenderSystem.enableBlend();
        this.renderFunc.render(pickup, graphics, anchor, font, name, nameWidth, total, totalWidth, actualX, y, time);
        RenderSystem.disableBlend();
        graphics.m_280168_().m_85849_();
    }

    private static void renderStyleDefault(Pickup pickup, GuiGraphics graphics, Anchor anchor, Font font, MutableComponent name, int nameWidth, MutableComponent total, int totalWidth, double x, double y, long time) {
        if (anchor.isInverted()) {
            graphics.m_280163_(DECORATIONS, -36 - nameWidth - totalWidth, 0, 0.0f, 0.0f, 256, 12, 256, 256);
            graphics.m_280163_(DECORATIONS, -26 - totalWidth, 1, 0.0f, 12.0f, 256, 10, 256, 256);
            graphics.m_280430_(font, (Component)name, -29 - nameWidth - totalWidth, 2, 0xFFFFFF);
            graphics.m_280430_(font, (Component)total.m_130940_(ChatFormatting.GRAY), -totalWidth, 2, 0xFFFFFF);
            Style.renderIcon(pickup, graphics, -11 - totalWidth, 6.0, time);
        } else {
            graphics.m_280163_(DECORATIONS, -218 + nameWidth + totalWidth, 0, 0.0f, 0.0f, 256, 12, 256, 256);
            graphics.m_280163_(DECORATIONS, -230 + totalWidth, 1, 0.0f, 12.0f, 256, 10, 256, 256);
            graphics.m_280430_(font, (Component)name, 30 + totalWidth, 2, 0xFFFFFF);
            graphics.m_280430_(font, (Component)total.m_130940_(ChatFormatting.GRAY), 5, 2, 0xFFFFFF);
            Style.renderIcon(pickup, graphics, 11 + totalWidth, 6.0, time);
        }
    }

    private static void renderStyleFlat(Pickup pickup, GuiGraphics graphics, Anchor anchor, Font font, MutableComponent name, int nameWidth, MutableComponent total, int totalWidth, double x, double y, long time) {
        if (anchor.isInverted()) {
            graphics.m_280509_(-3, 0, -25 - nameWidth - totalWidth, 12, Integer.MIN_VALUE);
            graphics.m_280430_(font, (Component)name, -23 - nameWidth - totalWidth, 2, 0xFFFFFF);
            graphics.m_280430_(font, (Component)total.m_130940_(ChatFormatting.GRAY), -totalWidth, 2, 0xFFFFFF);
            Style.renderIcon(pickup, graphics, -11 - totalWidth, 6.0, time);
        } else {
            graphics.m_280509_(3, 0, 25 + nameWidth + totalWidth, 12, Integer.MIN_VALUE);
            graphics.m_280430_(font, (Component)name, 23 + totalWidth, 2, 0xFFFFFF);
            graphics.m_280430_(font, (Component)total.m_130940_(ChatFormatting.GRAY), 5, 2, 0xFFFFFF);
            Style.renderIcon(pickup, graphics, 11 + totalWidth, 6.0, time);
        }
    }

    private static void renderStyleNoBackground(Pickup pickup, GuiGraphics graphics, Anchor anchor, Font font, MutableComponent name, int nameWidth, MutableComponent total, int totalWidth, double x, double y, long time) {
        if (anchor.isInverted()) {
            graphics.m_280430_(font, (Component)name, -23 - nameWidth - totalWidth, 2, 0xFFFFFF);
            graphics.m_280430_(font, (Component)total.m_130940_(ChatFormatting.GRAY), -totalWidth, 2, 0xFFFFFF);
            Style.renderIcon(pickup, graphics, -11 - totalWidth, 6.0, time);
        } else {
            graphics.m_280430_(font, (Component)name, 23 + totalWidth, 2, 0xFFFFFF);
            graphics.m_280430_(font, (Component)total.m_130940_(ChatFormatting.GRAY), 5, 2, 0xFFFFFF);
            Style.renderIcon(pickup, graphics, 11 + totalWidth, 6.0, time);
        }
    }

    private static void renderIcon(Pickup pickup, GuiGraphics graphics, double x, double y, long time) {
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85837_(x, y, 0.0);
        pickup.renderIcon(graphics, time);
        graphics.m_280168_().m_85849_();
    }

    private static Component getName(String raw, int count) {
        if (((String)raw).length() > 24) {
            raw = ((String)raw).substring(0, 23) + "...";
        }
        return Component.m_237113_((String)((String)raw + " x" + count));
    }

    private static double getOffset(double factor, boolean inverted) {
        double offset = -220.0 + 220.0 * (1.0 - Math.pow(factor - 1.0, 2.0));
        return inverted ? -offset : offset;
    }

    static {
        DECORATIONS = new ResourceLocation("loot_journal:textures/gui/decorations.png");
    }

    @FunctionalInterface
    private static interface RenderFunc {
        public void render(Pickup var1, GuiGraphics var2, Anchor var3, Font var4, MutableComponent var5, int var6, MutableComponent var7, int var8, double var9, double var11, long var13);
    }
}

