/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.books;

import com.google.common.collect.ImmutableList;
import com.verdantartifice.primalmagick.client.books.StyleGuide;
import com.verdantartifice.primalmagick.client.books.StyleGuideManager;
import com.verdantartifice.primalmagick.common.books.BookDefinition;
import com.verdantartifice.primalmagick.common.books.BookHelper;
import com.verdantartifice.primalmagick.common.books.BookLanguage;
import com.verdantartifice.primalmagick.common.books.BookLanguagesPM;
import com.verdantartifice.primalmagick.common.books.BookView;
import com.verdantartifice.primalmagick.common.books.BooksPM;
import com.verdantartifice.primalmagick.common.books.Lexicon;
import com.verdantartifice.primalmagick.common.books.LexiconManager;
import com.verdantartifice.primalmagick.common.registries.RegistryKeysPM;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.util.StringDecomposer;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientBookHelper {
    protected static final Logger LOGGER = LogManager.getLogger();
    public static final int TEXT_WIDTH = 114;
    public static final int TEXT_HEIGHT = 128;
    public static final int LINE_HEIGHT = 9;
    public static final int MAX_LINES_PER_PAGE = 14;
    private static final Style FOREWORD_TEXT_STYLE = Style.f_131099_.m_131155_(Boolean.valueOf(true));
    private static final Style AFTERWORD_TEXT_STYLE = Style.f_131099_.m_131155_(Boolean.valueOf(true));
    private static BiFunction<BookView, Font, List<FormattedCharSequence>> memoizedTextLines = Util.m_143821_(ClientBookHelper::getTextLinesInner);
    private static Function<BookDefinition, List<String>> memoizedUnencodedWords = Util.m_143827_(ClientBookHelper::getUnencodedWordsInner);
    private static Function<BookView, Double> memoizedBookComprehension = Util.m_143827_(ClientBookHelper::getBookComprehensionInner);

    public static void invalidate() {
        memoizedTextLines = Util.m_143821_(ClientBookHelper::getTextLinesInner);
        memoizedUnencodedWords = Util.m_143827_(ClientBookHelper::getUnencodedWordsInner);
        memoizedBookComprehension = Util.m_143827_(ClientBookHelper::getBookComprehensionInner);
    }

    private static String getForewordTranslationKey(ResourceKey<?> bookKey) {
        if (bookKey.m_135783_(RegistryKeysPM.BOOKS)) {
            return String.join((CharSequence)".", "written_book", bookKey.m_135782_().m_135827_(), bookKey.m_135782_().m_135815_(), "foreword");
        }
        return "tooltip.primalmagick.question_marks";
    }

    private static String getAfterwordTranslationKey(ResourceKey<?> bookKey) {
        if (bookKey.m_135783_(RegistryKeysPM.BOOKS)) {
            return String.join((CharSequence)".", "written_book", bookKey.m_135782_().m_135827_(), bookKey.m_135782_().m_135815_(), "afterword");
        }
        return "tooltip.primalmagick.question_marks";
    }

    private static String getAuthorTranslationKey(ResourceKey<?> bookKey) {
        if (bookKey.m_135783_(RegistryKeysPM.BOOKS)) {
            return String.join((CharSequence)".", "written_book", bookKey.m_135782_().m_135827_(), bookKey.m_135782_().m_135815_(), "author");
        }
        return "tooltip.primalmagick.question_marks";
    }

    private static String getTextTranslationKey(ResourceKey<?> bookKey) {
        if (bookKey.m_135783_(RegistryKeysPM.BOOKS)) {
            return String.join((CharSequence)".", "written_book", bookKey.m_135782_().m_135827_(), bookKey.m_135782_().m_135815_(), "text");
        }
        if (bookKey.m_135783_(ForgeRegistries.Keys.ENCHANTMENTS)) {
            String key = String.join((CharSequence)".", "enchantment", bookKey.m_135782_().m_135827_(), bookKey.m_135782_().m_135815_(), "desc");
            if (I18n.m_118936_((String)key)) {
                return key;
            }
            key = String.join((CharSequence)".", "enchantment", bookKey.m_135782_().m_135827_(), bookKey.m_135782_().m_135815_(), "rune_enchantment", "text");
            if (I18n.m_118936_((String)key)) {
                return key;
            }
            return String.join((CharSequence)".", "enchantment", bookKey.m_135782_().m_135827_(), bookKey.m_135782_().m_135815_());
        }
        return "tooltip.primalmagick.question_marks";
    }

    public static List<FormattedCharSequence> getTextLines(BookView view, Font font) {
        return memoizedTextLines.apply(view, font);
    }

    private static List<FormattedCharSequence> getTextLinesInner(BookView view, Font font) {
        String key;
        String key2;
        LOGGER.debug("Calculating text lines for book {}, lang {}, comprehension {}", view.bookKey(), (Object)view.languageId(), (Object)view.comprehension());
        ArrayList<FormattedCharSequence> retVal = new ArrayList<FormattedCharSequence>();
        String textTranslationKey = ClientBookHelper.getTextTranslationKey(view.bookKey());
        BookLanguage lang = BookLanguagesPM.LANGUAGES.get().containsKey(view.languageId()) ? (BookLanguage)BookLanguagesPM.LANGUAGES.get().getValue(view.languageId()) : (BookLanguage)BookLanguagesPM.DEFAULT.get();
        Lexicon langLex = LexiconManager.getLexicon(lang.languageId()).orElseThrow();
        Lexicon loremLex = LexiconManager.getLexicon(LexiconManager.LOREM_IPSUM).orElseThrow();
        Optional<StyleGuide> langStyleGuideOpt = StyleGuideManager.getStyleGuide(lang.languageId());
        if (view.bookKey().m_135783_(RegistryKeysPM.BOOKS) && I18n.m_118936_((String)(key2 = ClientBookHelper.getForewordTranslationKey(view.bookKey())))) {
            retVal.addAll(font.m_92923_((FormattedText)ComponentUtils.m_130748_((Component)Component.m_237115_((String)key2)).m_130948_(FOREWORD_TEXT_STYLE), 114));
            retVal.add(FormattedCharSequence.f_13691_);
        }
        ArrayList words = new ArrayList();
        Stream.of(BookHelper.WORD_BOUNDARY.split(StringDecomposer.m_14326_((FormattedText)Component.m_237115_((String)textTranslationKey)))).forEach(word -> {
            if (BookHelper.SEPARATOR_ONLY.matcher((CharSequence)word).matches()) {
                words.add(Component.m_237113_((String)word).m_130948_(BookHelper.BASE_TEXT_STYLE));
            } else if (lang.isTranslatable() && langLex.isWordTranslated((String)word, view.comprehension(), lang.complexity())) {
                langStyleGuideOpt.ifPresentOrElse(styleGuide -> words.add(Component.m_237113_((String)word).m_130948_(styleGuide.getStyle((String)word, BookHelper.BASE_TEXT_STYLE))), () -> words.add(Component.m_237113_((String)word).m_130948_(BookHelper.BASE_TEXT_STYLE)));
            } else {
                langStyleGuideOpt.ifPresentOrElse(styleGuide -> words.add(Component.m_237113_((String)loremLex.getReplacementWord((String)word)).m_130948_(styleGuide.getStyle((String)word, lang.style()))), () -> words.add(Component.m_237113_((String)loremLex.getReplacementWord((String)word)).m_130948_(lang.style())));
            }
        });
        retVal.addAll(Language.m_128107_().m_128112_(font.m_92865_().m_92414_(FormattedText.m_130768_(words), 114, Style.f_131099_)));
        if (view.bookKey().m_135783_(RegistryKeysPM.BOOKS) && I18n.m_118936_((String)(key = ClientBookHelper.getAfterwordTranslationKey(view.bookKey())))) {
            retVal.add(FormattedCharSequence.f_13691_);
            retVal.addAll(font.m_92923_((FormattedText)ComponentUtils.m_130748_((Component)Component.m_237115_((String)key)).m_130948_(AFTERWORD_TEXT_STYLE), 114));
        }
        return retVal;
    }

    public static List<FormattedCharSequence> getTextPage(BookView view, int page, Font font) {
        List<FormattedCharSequence> lines = ClientBookHelper.getTextLines(view, font);
        int lowLine = Mth.m_14045_((int)(page * 14), (int)0, (int)lines.size());
        int highLine = Mth.m_14045_((int)((page + 1) * 14), (int)0, (int)lines.size());
        return ImmutableList.copyOf(lines.subList(lowLine, highLine));
    }

    public static int getNumPages(BookView view, Font font) {
        return Mth.m_14167_((float)((float)ClientBookHelper.getTextLines(view, font).size() / 14.0f));
    }

    public static List<String> getUnencodedWords(BookDefinition bookDef) {
        return memoizedUnencodedWords.apply(bookDef);
    }

    private static List<String> getUnencodedWordsInner(BookDefinition bookDef) {
        ArrayList<String> words = new ArrayList<String>();
        ResourceKey bookKey = ResourceKey.m_135785_(RegistryKeysPM.BOOKS, (ResourceLocation)bookDef.bookId());
        ClientBookHelper.gatherUnencodedWords(ClientBookHelper.getTextTranslationKey(bookKey), words::add);
        ClientBookHelper.gatherUnencodedWords(BookHelper.getTitleTranslationKey(bookKey), words::add);
        ClientBookHelper.gatherUnencodedWords(ClientBookHelper.getAuthorTranslationKey(bookKey), words::add);
        return words;
    }

    private static void gatherUnencodedWords(String translationKey, Consumer<String> adder) {
        BookHelper.WORD_BOUNDARY.splitAsStream(StringDecomposer.m_14326_((FormattedText)Component.m_237115_((String)translationKey))).filter(word -> !BookHelper.SEPARATOR_ONLY.matcher((CharSequence)word).matches()).forEach(adder);
    }

    public static double getBookComprehension(BookView view) {
        return memoizedBookComprehension.apply(view);
    }

    private static double getBookComprehensionInner(BookView view) {
        BookLanguage bookLang;
        BookDefinition bookDef = BooksPM.BOOKS.get().containsKey(view.bookKey().m_135782_()) ? (BookDefinition)BooksPM.BOOKS.get().getValue(view.bookKey().m_135782_()) : (BookDefinition)BooksPM.TEST_BOOK.get();
        BookLanguage bookLanguage = bookLang = BookLanguagesPM.LANGUAGES.get().containsKey(view.languageId()) ? (BookLanguage)BookLanguagesPM.LANGUAGES.get().getValue(view.languageId()) : (BookLanguage)BookLanguagesPM.DEFAULT.get();
        if (!bookLang.isTranslatable()) {
            return 0.0;
        }
        if (bookLang.complexity() == 0) {
            return 1.0;
        }
        List<String> bookWords = ClientBookHelper.getUnencodedWords(bookDef);
        Lexicon langLex = LexiconManager.getLexicon(bookLang.languageId()).orElseThrow();
        int totalCount = bookWords.size();
        int translatedCount = (int)bookWords.stream().filter(word -> langLex.isWordTranslated((String)word, view.comprehension(), bookLang.complexity())).count();
        return Mth.m_14008_((double)((double)translatedCount / (double)totalCount), (double)0.0, (double)1.0);
    }
}

