/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.books;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.verdantartifice.primalmagick.client.books.ClientBookHelper;
import com.verdantartifice.primalmagick.common.books.BookHelper;
import com.verdantartifice.primalmagick.common.books.BookLanguagesPM;
import com.verdantartifice.primalmagick.common.books.BooksPM;
import com.verdantartifice.primalmagick.common.books.Lexicon;
import com.verdantartifice.primalmagick.common.books.LexiconManager;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LexiconLoader
extends SimpleJsonResourceReloadListener {
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Logger LOGGER = LogManager.getLogger();
    private static LexiconLoader INSTANCE;

    protected LexiconLoader() {
        super(GSON, "lexicons");
    }

    public static LexiconLoader getInstance() {
        if (INSTANCE == null) {
            throw new IllegalStateException("Cannot retrieve LexiconLoader until resources are loaded at least once");
        }
        return INSTANCE;
    }

    public static LexiconLoader getOrCreateInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LexiconLoader();
        }
        return INSTANCE;
    }

    protected void apply(Map<ResourceLocation, JsonElement> pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        pObject.entrySet().forEach(entry -> {
            ResourceLocation location = (ResourceLocation)entry.getKey();
            if (!location.m_135815_().startsWith("_")) {
                try {
                    LexiconManager.setLexicon(location, Lexicon.parse(GsonHelper.m_13918_((JsonElement)((JsonElement)entry.getValue()), (String)"top member")));
                }
                catch (Exception e) {
                    LOGGER.error("Parsing error loading lexicon {}", (Object)location, (Object)e);
                }
            }
        });
        BookHelper.invalidate();
        ClientBookHelper.invalidate();
        LOGGER.info("Loaded {} lexicons", (Object)LexiconManager.getAllLexicons().size());
    }

    public void updateWithTagData() {
        LOGGER.info("Updating lexicons with tagged data");
        BookLanguagesPM.LANGUAGES.get().getValues().stream().forEach(lang -> {
            Lexicon lexicon = new Lexicon();
            BooksPM.BOOKS.get().tags().getTag(lang.booksTag()).forEach(bookDef -> lexicon.addWords(ClientBookHelper.getUnencodedWords(bookDef)));
            LexiconManager.setLexicon(lang.languageId(), lexicon);
        });
    }
}

