/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.books;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.verdantartifice.primalmagick.client.books.StyleGuide;
import com.verdantartifice.primalmagick.client.books.StyleGuideManager;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StyleGuideLoader
extends SimpleJsonResourceReloadListener {
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Logger LOGGER = LogManager.getLogger();
    private static StyleGuideLoader INSTANCE;

    protected StyleGuideLoader() {
        super(GSON, "style_guides");
    }

    public static StyleGuideLoader getInstance() {
        if (INSTANCE == null) {
            throw new IllegalStateException("Cannot retrieve StyleGuideLoader until resources are loaded at least once");
        }
        return INSTANCE;
    }

    public static StyleGuideLoader getOrCreateInstance() {
        if (INSTANCE == null) {
            INSTANCE = new StyleGuideLoader();
        }
        return INSTANCE;
    }

    protected void apply(Map<ResourceLocation, JsonElement> pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        StyleGuideManager.clearStyleGuides();
        pObject.entrySet().forEach(entry -> {
            ResourceLocation location = (ResourceLocation)entry.getKey();
            if (!location.m_135815_().startsWith("_")) {
                StyleGuide.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)entry.getValue())).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(styleGuide -> StyleGuideManager.setStyleGuide(location, styleGuide));
            }
        });
        LOGGER.info("Loaded {} style guides", (Object)StyleGuideManager.getAllStyleGuides().size());
    }
}

