/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.compat.jei;

import com.verdantartifice.primalmagick.client.compat.jei.CategoryRecipeValidatorPM;
import com.verdantartifice.primalmagick.common.crafting.IArcaneRecipe;
import com.verdantartifice.primalmagick.common.crafting.IConcoctingRecipe;
import com.verdantartifice.primalmagick.common.crafting.IDissolutionRecipe;
import com.verdantartifice.primalmagick.common.crafting.IRitualRecipe;
import com.verdantartifice.primalmagick.common.crafting.IRunecarvingRecipe;
import com.verdantartifice.primalmagick.common.crafting.RecipeTypesPM;
import java.util.List;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;

public class CategoryRecipes {
    private final RecipeManager recipeManager;

    public CategoryRecipes() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc == null) {
            throw new IllegalStateException("Minecraft instance not initialized");
        }
        ClientLevel level = mc.f_91073_;
        if (level == null) {
            throw new IllegalStateException("Client level instance not initialized");
        }
        this.recipeManager = level.m_7465_();
        if (this.recipeManager == null) {
            throw new IllegalStateException("Recipe manager instance not initialized");
        }
    }

    public List<IArcaneRecipe> getArcaneRecipes(IRecipeCategory<IArcaneRecipe> category) {
        CategoryRecipeValidatorPM<IArcaneRecipe> validator = new CategoryRecipeValidatorPM<IArcaneRecipe>(category, 9, true);
        return CategoryRecipes.getValidHandledRecipes(this.recipeManager, (RecipeType)RecipeTypesPM.ARCANE_CRAFTING.get(), validator);
    }

    public List<IConcoctingRecipe> getConcoctingRecipes(IRecipeCategory<IConcoctingRecipe> category) {
        CategoryRecipeValidatorPM<IConcoctingRecipe> validator = new CategoryRecipeValidatorPM<IConcoctingRecipe>(category, 9, true);
        return CategoryRecipes.getValidHandledRecipes(this.recipeManager, (RecipeType)RecipeTypesPM.CONCOCTING.get(), validator);
    }

    public List<IRunecarvingRecipe> getRunecarvingRecipes(IRecipeCategory<IRunecarvingRecipe> category) {
        CategoryRecipeValidatorPM<IRunecarvingRecipe> validator = new CategoryRecipeValidatorPM<IRunecarvingRecipe>(category, 2, true);
        return CategoryRecipes.getValidHandledRecipes(this.recipeManager, (RecipeType)RecipeTypesPM.RUNECARVING.get(), validator);
    }

    public List<IDissolutionRecipe> getDissolutionRecipes(IRecipeCategory<IDissolutionRecipe> category) {
        CategoryRecipeValidatorPM<IDissolutionRecipe> validator = new CategoryRecipeValidatorPM<IDissolutionRecipe>(category, 1, true);
        return CategoryRecipes.getValidHandledRecipes(this.recipeManager, (RecipeType)RecipeTypesPM.DISSOLUTION.get(), validator);
    }

    public List<IRitualRecipe> getRitualRecipes(IRecipeCategory<IRitualRecipe> category) {
        CategoryRecipeValidatorPM<IRitualRecipe> validator = new CategoryRecipeValidatorPM<IRitualRecipe>(category, 100, true);
        return CategoryRecipes.getValidHandledRecipes(this.recipeManager, (RecipeType)RecipeTypesPM.RITUAL.get(), validator);
    }

    private static <C extends Container, T extends Recipe<C>> List<T> getValidHandledRecipes(RecipeManager recipeManager, RecipeType<T> recipeType, CategoryRecipeValidatorPM<T> validator) {
        return recipeManager.m_44013_(recipeType).stream().filter(r -> validator.isRecipeValid(r) && validator.isRecipeHandled(r)).toList();
    }
}

