/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.compat.jei;

import com.verdantartifice.primalmagick.PrimalMagick;
import com.verdantartifice.primalmagick.client.compat.jei.CategoryRecipes;
import com.verdantartifice.primalmagick.client.compat.jei.JeiRecipeTypesPM;
import com.verdantartifice.primalmagick.client.compat.jei.arcane_crafting.ArcaneCraftingRecipeCategory;
import com.verdantartifice.primalmagick.client.compat.jei.books.CodexSubtypeInterpreter;
import com.verdantartifice.primalmagick.client.compat.jei.concocting.ConcoctingRecipeCategory;
import com.verdantartifice.primalmagick.client.compat.jei.concocting.ConcoctionSubtypeInterpreter;
import com.verdantartifice.primalmagick.client.compat.jei.dissolution.DissolutionRecipeCategory;
import com.verdantartifice.primalmagick.client.compat.jei.ritual.RitualRecipeCategory;
import com.verdantartifice.primalmagick.client.compat.jei.runecarving.RunecarvingRecipeCategory;
import com.verdantartifice.primalmagick.client.gui.ArcaneWorkbenchScreen;
import com.verdantartifice.primalmagick.client.gui.ConcocterScreen;
import com.verdantartifice.primalmagick.client.gui.DissolutionChamberScreen;
import com.verdantartifice.primalmagick.client.gui.InfernalFurnaceScreen;
import com.verdantartifice.primalmagick.common.blocks.BlocksPM;
import com.verdantartifice.primalmagick.common.crafting.IArcaneRecipe;
import com.verdantartifice.primalmagick.common.crafting.IConcoctingRecipe;
import com.verdantartifice.primalmagick.common.crafting.IDissolutionRecipe;
import com.verdantartifice.primalmagick.common.crafting.IRitualRecipe;
import com.verdantartifice.primalmagick.common.crafting.IRunecarvingRecipe;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.menus.ArcaneWorkbenchMenu;
import com.verdantartifice.primalmagick.common.menus.ConcocterMenu;
import com.verdantartifice.primalmagick.common.menus.DissolutionChamberMenu;
import com.verdantartifice.primalmagick.common.menus.InfernalFurnaceMenu;
import com.verdantartifice.primalmagick.common.menus.MenuTypesPM;
import com.verdantartifice.primalmagick.common.research.CompoundResearchKey;
import com.verdantartifice.primalmagick.common.research.ResearchDiscipline;
import com.verdantartifice.primalmagick.common.research.ResearchDisciplines;
import com.verdantartifice.primalmagick.common.research.ResearchEntries;
import com.verdantartifice.primalmagick.common.research.ResearchEntry;
import com.verdantartifice.primalmagick.common.research.SimpleResearchKey;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class JeiHelper
implements IModPlugin {
    private static final ResourceLocation UID = PrimalMagick.resource("jei");
    @Nullable
    private IRecipeCategory<IArcaneRecipe> arcaneCategory;
    @Nullable
    private IRecipeCategory<IConcoctingRecipe> concoctingCategory;
    @Nullable
    private IRecipeCategory<IRunecarvingRecipe> runecarvingCategory;
    @Nullable
    private IRecipeCategory<IDissolutionRecipe> dissolutionCategory;
    @Nullable
    private IRecipeCategory<IRitualRecipe> ritualCategory;

    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ItemsPM.CONCOCTION.get()), (IIngredientSubtypeInterpreter)ConcoctionSubtypeInterpreter.INSTANCE);
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ItemsPM.ALCHEMICAL_BOMB.get()), (IIngredientSubtypeInterpreter)ConcoctionSubtypeInterpreter.INSTANCE);
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ItemsPM.CODEX.get()), (IIngredientSubtypeInterpreter)CodexSubtypeInterpreter.INSTANCE);
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ItemsPM.CODEX_CREATIVE.get()), (IIngredientSubtypeInterpreter)CodexSubtypeInterpreter.INSTANCE);
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        this.arcaneCategory = new ArcaneCraftingRecipeCategory(guiHelper);
        this.concoctingCategory = new ConcoctingRecipeCategory(guiHelper);
        this.runecarvingCategory = new RunecarvingRecipeCategory(guiHelper);
        this.dissolutionCategory = new DissolutionRecipeCategory(guiHelper);
        this.ritualCategory = new RitualRecipeCategory(guiHelper);
        registration.addRecipeCategories(new IRecipeCategory[]{this.arcaneCategory, this.concoctingCategory, this.runecarvingCategory, this.dissolutionCategory, this.ritualCategory});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        CategoryRecipes categoryRecipes = new CategoryRecipes();
        if (this.arcaneCategory != null) {
            registration.addRecipes(JeiRecipeTypesPM.ARCANE_CRAFTING, categoryRecipes.getArcaneRecipes(this.arcaneCategory));
        }
        if (this.concoctingCategory != null) {
            registration.addRecipes(JeiRecipeTypesPM.CONCOCTING, categoryRecipes.getConcoctingRecipes(this.concoctingCategory));
        }
        if (this.runecarvingCategory != null) {
            registration.addRecipes(JeiRecipeTypesPM.RUNECARVING, categoryRecipes.getRunecarvingRecipes(this.runecarvingCategory));
        }
        if (this.dissolutionCategory != null) {
            registration.addRecipes(JeiRecipeTypesPM.DISSOLUTION, categoryRecipes.getDissolutionRecipes(this.dissolutionCategory));
        }
        if (this.ritualCategory != null) {
            registration.addRecipes(JeiRecipeTypesPM.RITUAL, categoryRecipes.getRitualRecipes(this.ritualCategory));
        }
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlocksPM.ARCANE_WORKBENCH.get()), new RecipeType[]{RecipeTypes.CRAFTING, JeiRecipeTypesPM.ARCANE_CRAFTING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlocksPM.INFERNAL_FURNACE.get()), new RecipeType[]{RecipeTypes.SMELTING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlocksPM.CONCOCTER.get()), new RecipeType[]{JeiRecipeTypesPM.CONCOCTING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlocksPM.RUNECARVING_TABLE.get()), new RecipeType[]{JeiRecipeTypesPM.RUNECARVING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlocksPM.DISSOLUTION_CHAMBER.get()), new RecipeType[]{JeiRecipeTypesPM.DISSOLUTION});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlocksPM.RITUAL_ALTAR.get()), new RecipeType[]{JeiRecipeTypesPM.RITUAL});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(ArcaneWorkbenchMenu.class, (MenuType)MenuTypesPM.ARCANE_WORKBENCH.get(), JeiRecipeTypesPM.ARCANE_CRAFTING, 1, 9, 11, 36);
        registration.addRecipeTransferHandler(ConcocterMenu.class, (MenuType)MenuTypesPM.CONCOCTER.get(), JeiRecipeTypesPM.CONCOCTING, 1, 9, 11, 36);
        registration.addRecipeTransferHandler(DissolutionChamberMenu.class, (MenuType)MenuTypesPM.DISSOLUTION_CHAMBER.get(), JeiRecipeTypesPM.DISSOLUTION, 1, 1, 3, 36);
        registration.addRecipeTransferHandler(InfernalFurnaceMenu.class, (MenuType)MenuTypesPM.INFERNAL_FURNACE.get(), RecipeTypes.SMELTING, 1, 1, 4, 36);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(ArcaneWorkbenchScreen.class, 104, 52, 22, 15, new RecipeType[]{JeiRecipeTypesPM.ARCANE_CRAFTING});
        registration.addRecipeClickArea(ConcocterScreen.class, 104, 35, 22, 15, new RecipeType[]{JeiRecipeTypesPM.CONCOCTING});
        registration.addRecipeClickArea(DissolutionChamberScreen.class, 79, 35, 22, 15, new RecipeType[]{JeiRecipeTypesPM.DISSOLUTION});
        registration.addRecipeClickArea(InfernalFurnaceScreen.class, 79, 35, 22, 15, new RecipeType[]{RecipeTypes.SMELTING});
    }

    public static List<Component> getManaCostTooltipStrings(SourceList manaCosts) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        tooltip.add((Component)Component.m_237115_((String)"label.primalmagick.crafting.mana_cost_header"));
        for (Source source : manaCosts.getSourcesSorted()) {
            tooltip.add((Component)Component.m_237110_((String)"label.primalmagick.crafting.mana", (Object[])new Object[]{manaCosts.getAmount(source), source.getNameText()}));
        }
        return tooltip;
    }

    public static List<Component> getRequiredResearchTooltipStrings(CompoundResearchKey compoundResearch) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        tooltip.add((Component)Component.m_237115_((String)"label.primalmagick.crafting.research_header"));
        for (SimpleResearchKey key : compoundResearch.getKeys()) {
            ResearchEntry entry = ResearchEntries.getEntry(key);
            if (entry == null) {
                tooltip.add((Component)Component.m_237115_((String)("research.primalmagick." + key.getRootKey().toLowerCase() + ".title")));
                continue;
            }
            MutableComponent comp = Component.m_237115_((String)entry.getNameTranslationKey());
            ResearchDiscipline disc = ResearchDisciplines.getDiscipline(entry.getDisciplineKey());
            if (disc != null) {
                comp.m_7220_((Component)Component.m_237113_((String)" ("));
                comp.m_7220_((Component)Component.m_237115_((String)disc.getNameTranslationKey()));
                comp.m_7220_((Component)Component.m_237113_((String)")"));
            }
            tooltip.add((Component)comp);
        }
        return tooltip;
    }
}

