/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.compat.jei.ritual;

import com.verdantartifice.primalmagick.PrimalMagick;
import com.verdantartifice.primalmagick.client.compat.jei.JeiHelper;
import com.verdantartifice.primalmagick.client.compat.jei.JeiRecipeTypesPM;
import com.verdantartifice.primalmagick.client.compat.jei.RecipeCategoryPM;
import com.verdantartifice.primalmagick.client.util.RecipeUtils;
import com.verdantartifice.primalmagick.common.crafting.IRitualRecipe;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.research.CompoundResearchKey;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import java.awt.Color;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class RitualRecipeCategory
extends RecipeCategoryPM<IRitualRecipe> {
    public static final ResourceLocation UID = PrimalMagick.resource("ritual_altar");
    private static final ResourceLocation BACKGROUND_TEXTURE = PrimalMagick.resource("textures/gui/jei/ritual_altar.png");
    private static final ResourceLocation RESEARCH_TEXTURE = PrimalMagick.resource("textures/item/grimoire.png");
    private static final int MANA_COST_X_OFFSET = 118;
    private static final int MANA_COST_Y_OFFSET = 14;
    private static final int RESEARCH_X_OFFSET = 118;
    private static final int RESEARCH_Y_OFFSET = 49;
    private final IDrawableStatic manaCostIcon;
    private final IDrawableStatic researchIcon;

    public RitualRecipeCategory(IGuiHelper guiHelper) {
        super(guiHelper, UID, "block.primalmagick.ritual_altar");
        this.manaCostIcon = guiHelper.createDrawable(BACKGROUND_TEXTURE, 170, 0, 16, 16);
        this.researchIcon = guiHelper.drawableBuilder(RESEARCH_TEXTURE, 0, 0, 32, 32).setTextureSize(32, 32).build();
        this.setBackground((IDrawable)guiHelper.createDrawable(BACKGROUND_TEXTURE, 0, 0, 170, 80));
        this.setIcon(new ItemStack((ItemLike)ItemsPM.RITUAL_ALTAR.get()));
    }

    public void setRecipe(IRecipeLayoutBuilder builder, IRitualRecipe recipe, IFocusGroup focuses) {
        int index;
        NonNullList offerings = recipe.m_7527_();
        List<Ingredient> props = recipe.getProps().stream().map(b -> b.asIngredient()).toList();
        int ingredientCount = recipe.m_7527_().size();
        int propCount = recipe.getProps().size();
        for (index = 0; index < ingredientCount; ++index) {
            builder.addSlot(RecipeIngredientRole.INPUT, 1 + index % 6 * 18, 14 + index / 6 * 18).addIngredients((Ingredient)offerings.get(index));
        }
        for (index = 0; index < propCount; ++index) {
            builder.addSlot(RecipeIngredientRole.INPUT, 1 + index % 6 * 18, 63 + index / 6 * 18).addIngredients(props.get(index));
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 149, 32).addItemStack(RecipeUtils.getResultItem(recipe));
    }

    public void draw(IRitualRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Minecraft mc = Minecraft.m_91087_();
        guiGraphics.m_280614_(mc.f_91062_, (Component)Component.m_237115_((String)"jei.primalmagick.ritual.offerings.header"), 0, 2, Color.BLACK.getRGB(), false);
        guiGraphics.m_280614_(mc.f_91062_, (Component)Component.m_237115_((String)"jei.primalmagick.ritual.props.header"), 0, 51, Color.BLACK.getRGB(), false);
        if (recipe.getManaCosts() != null && !recipe.getManaCosts().isEmpty()) {
            this.manaCostIcon.draw(guiGraphics, 118, 14);
        }
        if (recipe.getRequiredResearch() != null && !recipe.getRequiredResearch().getKeys().isEmpty()) {
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_85841_(0.5f, 0.5f, 0.5f);
            this.researchIcon.draw(guiGraphics, 236, 98);
            guiGraphics.m_280168_().m_85849_();
        }
    }

    public List<Component> getTooltipStrings(IRitualRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        SourceList manaCosts = recipe.getManaCosts();
        CompoundResearchKey compoundResearch = recipe.getRequiredResearch();
        if (manaCosts != null && !manaCosts.isEmpty() && mouseX >= 118.0 && mouseX < (double)(118 + this.manaCostIcon.getWidth()) && mouseY >= 14.0 && mouseY < (double)(14 + this.manaCostIcon.getHeight())) {
            return JeiHelper.getManaCostTooltipStrings(manaCosts);
        }
        if (compoundResearch != null && !compoundResearch.getKeys().isEmpty() && mouseX >= 118.0 && mouseX < (double)(118 + this.researchIcon.getWidth()) && mouseY >= 49.0 && mouseY < (double)(49 + this.researchIcon.getHeight())) {
            return JeiHelper.getRequiredResearchTooltipStrings(compoundResearch);
        }
        return super.getTooltipStrings((Object)recipe, recipeSlotsView, mouseX, mouseY);
    }

    public RecipeType<IRitualRecipe> getRecipeType() {
        return JeiRecipeTypesPM.RITUAL;
    }
}

