/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.compat.jei.runecarving;

import com.verdantartifice.primalmagick.PrimalMagick;
import com.verdantartifice.primalmagick.client.compat.jei.JeiHelper;
import com.verdantartifice.primalmagick.client.compat.jei.JeiRecipeTypesPM;
import com.verdantartifice.primalmagick.client.compat.jei.RecipeCategoryPM;
import com.verdantartifice.primalmagick.client.util.RecipeUtils;
import com.verdantartifice.primalmagick.common.crafting.IRunecarvingRecipe;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.research.CompoundResearchKey;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class RunecarvingRecipeCategory
extends RecipeCategoryPM<IRunecarvingRecipe> {
    public static final ResourceLocation UID = PrimalMagick.resource("runecarving_table");
    private static final ResourceLocation BACKGROUND_TEXTURE = PrimalMagick.resource("textures/gui/jei/runecarving_table.png");
    private static final ResourceLocation RESEARCH_TEXTURE = PrimalMagick.resource("textures/item/grimoire.png");
    private static final int RESEARCH_X_OFFSET = 79;
    private static final int RESEARCH_Y_OFFSET = 19;
    private final IDrawableStatic researchIcon;

    public RunecarvingRecipeCategory(IGuiHelper guiHelper) {
        super(guiHelper, UID, "block.primalmagick.runecarving_table");
        this.researchIcon = guiHelper.drawableBuilder(RESEARCH_TEXTURE, 0, 0, 32, 32).setTextureSize(32, 32).build();
        this.setBackground((IDrawable)guiHelper.createDrawable(BACKGROUND_TEXTURE, 0, 0, 125, 36));
        this.setIcon(new ItemStack((ItemLike)ItemsPM.RUNECARVING_TABLE.get()));
    }

    public void setRecipe(IRecipeLayoutBuilder builder, IRunecarvingRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).addIngredients((Ingredient)recipe.m_7527_().get(0));
        builder.addSlot(RecipeIngredientRole.INPUT, 50, 1).addIngredients((Ingredient)recipe.m_7527_().get(1));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 108, 1).addItemStack(RecipeUtils.getResultItem(recipe));
    }

    public void draw(IRunecarvingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        if (recipe.getRequiredResearch() != null && !recipe.getRequiredResearch().getKeys().isEmpty()) {
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_85841_(0.5f, 0.5f, 0.5f);
            this.researchIcon.draw(guiGraphics, 158, 38);
            guiGraphics.m_280168_().m_85849_();
        }
    }

    public List<Component> getTooltipStrings(IRunecarvingRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        CompoundResearchKey compoundResearch = recipe.getRequiredResearch();
        if (compoundResearch != null && !compoundResearch.getKeys().isEmpty() && mouseX >= 79.0 && mouseX < (double)(79 + this.researchIcon.getWidth()) && mouseY >= 19.0 && mouseY < (double)(19 + this.researchIcon.getHeight())) {
            return JeiHelper.getRequiredResearchTooltipStrings(compoundResearch);
        }
        return super.getTooltipStrings((Object)recipe, recipeSlotsView, mouseX, mouseY);
    }

    public RecipeType<IRunecarvingRecipe> getRecipeType() {
        return JeiRecipeTypesPM.RUNECARVING;
    }
}

