/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.events;

import com.verdantartifice.primalmagick.PrimalMagick;
import com.verdantartifice.primalmagick.client.books.LexiconLoader;
import com.verdantartifice.primalmagick.client.books.StyleGuideLoader;
import com.verdantartifice.primalmagick.client.fx.particles.AirCurrentParticle;
import com.verdantartifice.primalmagick.client.fx.particles.DripParticlePM;
import com.verdantartifice.primalmagick.client.fx.particles.InfernalFlameParticle;
import com.verdantartifice.primalmagick.client.fx.particles.ManaSparkleParticle;
import com.verdantartifice.primalmagick.client.fx.particles.NoteEmitterParticle;
import com.verdantartifice.primalmagick.client.fx.particles.OfferingParticle;
import com.verdantartifice.primalmagick.client.fx.particles.ParticleTypesPM;
import com.verdantartifice.primalmagick.client.fx.particles.PotionExplosionParticle;
import com.verdantartifice.primalmagick.client.fx.particles.PropMarkerParticle;
import com.verdantartifice.primalmagick.client.fx.particles.SpellBoltParticle;
import com.verdantartifice.primalmagick.client.fx.particles.SpellSparkleParticle;
import com.verdantartifice.primalmagick.client.fx.particles.SpellcraftingRuneParticle;
import com.verdantartifice.primalmagick.client.fx.particles.WandPoofParticle;
import com.verdantartifice.primalmagick.client.gui.hud.ManaStorageItemDecorator;
import com.verdantartifice.primalmagick.client.gui.hud.WandHudOverlay;
import com.verdantartifice.primalmagick.client.gui.hud.WardingHudOverlay;
import com.verdantartifice.primalmagick.client.tips.TipLoader;
import com.verdantartifice.primalmagick.client.tooltips.ClientAffinityTooltipComponent;
import com.verdantartifice.primalmagick.common.affinities.AffinityTooltipComponent;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.items.armor.WardingModuleItem;
import com.verdantartifice.primalmagick.common.items.misc.SpellcraftingAltarBlockItem;
import com.verdantartifice.primalmagick.common.items.tools.ForbiddenTridentItem;
import com.verdantartifice.primalmagick.common.items.tools.HallowsteelShieldItem;
import com.verdantartifice.primalmagick.common.items.tools.HallowsteelTridentItem;
import com.verdantartifice.primalmagick.common.items.tools.HexiumShieldItem;
import com.verdantartifice.primalmagick.common.items.tools.HexiumTridentItem;
import com.verdantartifice.primalmagick.common.items.tools.PrimaliteShieldItem;
import com.verdantartifice.primalmagick.common.items.tools.PrimaliteTridentItem;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.wands.WandCap;
import com.verdantartifice.primalmagick.common.wands.WandCore;
import com.verdantartifice.primalmagick.common.wands.WandGem;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RegisterItemDecorationsEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="primalmagick", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientRegistrationEvents {
    protected static final Logger LOGGER = LogManager.getLogger();

    @SubscribeEvent
    public static void onRegisterParticleProviders(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)ParticleTypesPM.WAND_POOF.get(), WandPoofParticle.Factory::new);
        event.registerSpriteSet((ParticleType)ParticleTypesPM.MANA_SPARKLE.get(), ManaSparkleParticle.Factory::new);
        event.registerSpriteSet((ParticleType)ParticleTypesPM.SPELL_SPARKLE.get(), SpellSparkleParticle.Factory::new);
        event.registerSpriteSet((ParticleType)ParticleTypesPM.SPELL_BOLT.get(), SpellBoltParticle.Factory::new);
        event.registerSpriteSet((ParticleType)ParticleTypesPM.OFFERING.get(), OfferingParticle.Factory::new);
        event.registerSpriteSet((ParticleType)ParticleTypesPM.PROP_MARKER.get(), PropMarkerParticle.Factory::new);
        event.registerSpecial((ParticleType)ParticleTypesPM.POTION_EXPLOSION.get(), (ParticleProvider)new PotionExplosionParticle.Factory());
        event.registerSpecial((ParticleType)ParticleTypesPM.NOTE_EMITTER.get(), (ParticleProvider)new NoteEmitterParticle.Factory());
        event.registerSpriteSet((ParticleType)ParticleTypesPM.SPELLCRAFTING_RUNE_U.get(), SpellcraftingRuneParticle.Factory::new);
        event.registerSpriteSet((ParticleType)ParticleTypesPM.SPELLCRAFTING_RUNE_V.get(), SpellcraftingRuneParticle.Factory::new);
        event.registerSpriteSet((ParticleType)ParticleTypesPM.SPELLCRAFTING_RUNE_T.get(), SpellcraftingRuneParticle.Factory::new);
        event.registerSpriteSet((ParticleType)ParticleTypesPM.SPELLCRAFTING_RUNE_D.get(), SpellcraftingRuneParticle.Factory::new);
        event.registerSpriteSet((ParticleType)ParticleTypesPM.INFERNAL_FLAME.get(), InfernalFlameParticle.Factory::new);
        event.registerSpriteSet((ParticleType)ParticleTypesPM.AIR_CURRENT.get(), AirCurrentParticle.Factory::new);
        event.registerSpriteSet((ParticleType)ParticleTypesPM.VOID_SMOKE.get(), AirCurrentParticle.Factory::new);
        event.registerSprite((ParticleType)ParticleTypesPM.DRIPPING_BLOOD_DROP.get(), DripParticlePM::createBloodDropHangParticle);
        event.registerSprite((ParticleType)ParticleTypesPM.FALLING_BLOOD_DROP.get(), DripParticlePM::createBloodDropFallParticle);
        event.registerSprite((ParticleType)ParticleTypesPM.LANDING_BLOOD_DROP.get(), DripParticlePM::createBloodDropLandParticle);
    }

    @SubscribeEvent
    public static void onModelRegister(ModelEvent.RegisterAdditional event) {
        event.register((ResourceLocation)new ModelResourceLocation(PrimalMagick.resource("mundane_wand_core"), ""));
        for (WandCore core : WandCore.getAllWandCores()) {
            event.register((ResourceLocation)new ModelResourceLocation(core.getWandModelResourceLocationNamespace(), ""));
            event.register((ResourceLocation)new ModelResourceLocation(core.getStaffModelResourceLocationNamespace(), ""));
        }
        for (WandCap cap : WandCap.getAllWandCaps()) {
            event.register((ResourceLocation)new ModelResourceLocation(cap.getWandModelResourceLocationNamespace(), ""));
            event.register((ResourceLocation)new ModelResourceLocation(cap.getStaffModelResourceLocationNamespace(), ""));
        }
        for (WandGem gem : WandGem.getAllWandGems()) {
            event.register((ResourceLocation)new ModelResourceLocation(gem.getModelResourceLocationNamespace(), ""));
        }
        for (int index = 0; index <= 4; ++index) {
            event.register((ResourceLocation)new ModelResourceLocation(PrimalMagick.resource("arcanometer_" + index), ""));
        }
    }

    @SubscribeEvent
    public static void onClientReloadListenerRegister(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)((PrimaliteTridentItem)((Object)ItemsPM.PRIMALITE_TRIDENT.get())).getRenderProperties().getCustomRenderer());
        event.registerReloadListener((PreparableReloadListener)((HexiumTridentItem)((Object)ItemsPM.HEXIUM_TRIDENT.get())).getRenderProperties().getCustomRenderer());
        event.registerReloadListener((PreparableReloadListener)((HallowsteelTridentItem)((Object)ItemsPM.HALLOWSTEEL_TRIDENT.get())).getRenderProperties().getCustomRenderer());
        event.registerReloadListener((PreparableReloadListener)((ForbiddenTridentItem)((Object)ItemsPM.FORBIDDEN_TRIDENT.get())).getRenderProperties().getCustomRenderer());
        event.registerReloadListener((PreparableReloadListener)((PrimaliteShieldItem)((Object)ItemsPM.PRIMALITE_SHIELD.get())).getRenderProperties().getCustomRenderer());
        event.registerReloadListener((PreparableReloadListener)((HexiumShieldItem)((Object)ItemsPM.HEXIUM_SHIELD.get())).getRenderProperties().getCustomRenderer());
        event.registerReloadListener((PreparableReloadListener)((HallowsteelShieldItem)((Object)ItemsPM.HALLOWSTEEL_SHIELD.get())).getRenderProperties().getCustomRenderer());
        event.registerReloadListener((PreparableReloadListener)((SpellcraftingAltarBlockItem)((Object)ItemsPM.SPELLCRAFTING_ALTAR.get())).getRenderProperties().getCustomRenderer());
        event.registerReloadListener((PreparableReloadListener)LexiconLoader.getOrCreateInstance());
        event.registerReloadListener((PreparableReloadListener)StyleGuideLoader.getOrCreateInstance());
        event.registerReloadListener((PreparableReloadListener)TipLoader.getOrCreateInstance());
    }

    @SubscribeEvent
    public static void onRegisterGuiOverlays(RegisterGuiOverlaysEvent event) {
        event.registerAbove(VanillaGuiOverlay.HOTBAR.id(), "wand_hud", (IGuiOverlay)new WandHudOverlay());
        event.registerAbove(VanillaGuiOverlay.PLAYER_HEALTH.id(), "warding_hud", (IGuiOverlay)new WardingHudOverlay());
    }

    @SubscribeEvent
    public static void onRegisterClientTooltipComponentFactories(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(AffinityTooltipComponent.class, ClientAffinityTooltipComponent::new);
    }

    @SubscribeEvent
    public static void onRegisterItemDecorations(RegisterItemDecorationsEvent event) {
        ManaStorageItemDecorator wardDecorator = new ManaStorageItemDecorator(Source.EARTH);
        WardingModuleItem.getApplicableItems().forEach(itemSupplier -> event.register((ItemLike)itemSupplier.get(), wardDecorator));
    }
}

