/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.events;

import com.mojang.datafixers.util.Either;
import com.verdantartifice.primalmagick.client.config.KeyBindings;
import com.verdantartifice.primalmagick.client.events.InputEvents;
import com.verdantartifice.primalmagick.client.gui.SpellSelectionRadialScreen;
import com.verdantartifice.primalmagick.client.util.GuiUtils;
import com.verdantartifice.primalmagick.common.affinities.AffinityManager;
import com.verdantartifice.primalmagick.common.affinities.AffinityTooltipComponent;
import com.verdantartifice.primalmagick.common.capabilities.PrimalMagickCapabilities;
import com.verdantartifice.primalmagick.common.config.Config;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.items.armor.IManaDiscountGear;
import com.verdantartifice.primalmagick.common.items.armor.WardingModuleItem;
import com.verdantartifice.primalmagick.common.research.ResearchManager;
import com.verdantartifice.primalmagick.common.runes.RuneManager;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.common.wands.IWand;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="primalmagick", value={Dist.CLIENT})
public class ClientRenderEvents {
    @SubscribeEvent
    public static void renderTooltip(ItemTooltipEvent event) {
        IWand wand;
        Item item = event.getItemStack().m_41720_();
        if (item instanceof IManaDiscountGear) {
            IManaDiscountGear discountItem = (IManaDiscountGear)item;
            int discount = discountItem.getBestManaDiscount(event.getItemStack(), event.getEntity());
            Optional<Source> attunedSource = discountItem.getAttunedSource(event.getItemStack(), event.getEntity());
            attunedSource.ifPresentOrElse(source -> event.getToolTip().add(Component.m_237110_((String)"tooltip.primalmagick.mana_discount_attuned", (Object[])new Object[]{discount, source.getNameText(ChatFormatting.DARK_AQUA)}).m_130940_(ChatFormatting.DARK_AQUA)), () -> event.getToolTip().add(Component.m_237110_((String)"tooltip.primalmagick.mana_discount", (Object[])new Object[]{discount}).m_130940_(ChatFormatting.DARK_AQUA)));
        }
        if (RuneManager.hasRunes(event.getItemStack())) {
            event.getToolTip().add(Component.m_237115_((String)"tooltip.primalmagick.runescribed").m_130940_(ChatFormatting.DARK_AQUA));
        }
        if ((item = event.getItemStack().m_41720_()) instanceof IWand && (wand = (IWand)item).isGlamoured(event.getItemStack())) {
            event.getToolTip().add(Component.m_237115_((String)"tooltip.primalmagick.glamoured").m_130940_(ChatFormatting.DARK_AQUA));
        }
        if (WardingModuleItem.hasWardAttached(event.getItemStack())) {
            MutableComponent levelComponent = Component.m_237115_((String)("enchantment.level." + WardingModuleItem.getAttachedWardLevel(event.getItemStack())));
            event.getToolTip().add(Component.m_237115_((String)"tooltip.primalmagick.warded").m_7220_(CommonComponents.f_263701_).m_7220_((Component)levelComponent).m_130940_(ChatFormatting.DARK_AQUA));
        }
        event.getItemStack().getCapability(PrimalMagickCapabilities.MANA_STORAGE).ifPresent(manaStorage -> Source.SORTED_SOURCES.stream().filter(source -> source.isDiscovered(event.getEntity()) && manaStorage.canStore((Source)source)).forEach(source -> event.getToolTip().add(Component.m_237110_((String)"tooltip.primalmagick.source.mana_container", (Object[])new Object[]{source.getNameText(), (double)manaStorage.getManaStored((Source)source) / 100.0}))));
    }

    @SubscribeEvent
    public static void onRenderTooltipGatherComponents(RenderTooltipEvent.GatherComponents event) {
        Minecraft mc = Minecraft.m_91087_();
        Screen gui = mc.f_91080_;
        if (gui instanceof AbstractContainerScreen && InputEvents.isKeyDown(KeyBindings.VIEW_AFFINITY_KEY) != (Boolean)Config.SHOW_AFFINITIES.get() && !mc.f_91067_.m_91600_() && event.getItemStack() != null && !event.getItemStack().m_41619_()) {
            AffinityManager.getInstance().getAffinityValues(event.getItemStack(), (Level)mc.f_91073_).ifPresentOrElse(sources -> {
                if (sources.isEmpty()) {
                    event.getTooltipElements().add(Either.left((Object)Component.m_237115_((String)"tooltip.primalmagick.affinities.none")));
                } else if (!ResearchManager.isScanned(event.getItemStack(), (Player)mc.f_91074_) && !((Boolean)Config.SHOW_UNSCANNED_AFFINITIES.get()).booleanValue()) {
                    event.getTooltipElements().add(Either.left((Object)Component.m_237115_((String)"tooltip.primalmagick.affinities.unknown")));
                } else {
                    event.getTooltipElements().add(Either.left((Object)Component.m_237115_((String)"tooltip.primalmagick.affinities.label")));
                    event.getTooltipElements().add(Either.right((Object)new AffinityTooltipComponent((SourceList)sources)));
                }
            }, () -> event.getTooltipElements().add(Either.left((Object)Component.m_237115_((String)"tooltip.primalmagick.affinities.calculating"))));
        }
    }

    @SubscribeEvent
    public static void onHighlightEntity(RenderHighlightEvent.Entity event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_.m_21205_().m_41720_() == ItemsPM.ARCANOMETER.get() || mc.f_91074_.m_21206_().m_41720_() == ItemsPM.ARCANOMETER.get()) {
            Entity entity = event.getTarget().m_82443_();
            AffinityManager.getInstance().getAffinityValues(entity.m_6095_(), entity.m_9236_().m_9598_()).ifPresent(affinities -> {
                boolean isScanned = ResearchManager.isScanned(entity.m_6095_(), (Player)mc.f_91074_);
                if (isScanned && affinities != null && !affinities.isEmpty()) {
                    float partialTicks = event.getPartialTick();
                    double interpolatedEntityX = entity.f_19854_ + (double)partialTicks * (entity.m_20185_() - entity.f_19854_);
                    double interpolatedEntityY = entity.f_19855_ + (double)partialTicks * (entity.m_20186_() - entity.f_19855_);
                    double interpolatedEntityZ = entity.f_19856_ + (double)partialTicks * (entity.m_20189_() - entity.f_19856_);
                    GuiUtils.renderSourcesBillboard(event.getPoseStack(), event.getMultiBufferSource(), interpolatedEntityX, interpolatedEntityY + (double)entity.m_20206_(), interpolatedEntityZ, affinities, partialTicks);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onRenderGameOverlayPreLayer(RenderGuiOverlayEvent.Pre event) {
        Minecraft mc = Minecraft.m_91087_();
        if (event.getOverlay() == VanillaGuiOverlay.CROSSHAIR.type() && mc.f_91080_ instanceof SpellSelectionRadialScreen) {
            event.setCanceled(true);
        }
    }
}

