/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.fx;

import com.verdantartifice.primalmagick.client.fx.particles.ParticleTypesPM;
import com.verdantartifice.primalmagick.client.fx.particles.PotionExplosionParticleData;
import com.verdantartifice.primalmagick.client.fx.particles.SpellBoltParticleData;
import com.verdantartifice.primalmagick.common.sounds.SoundsPM;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class FxDispatcher {
    public static final FxDispatcher INSTANCE = new FxDispatcher();
    public static final int DEFAULT_PROP_MARKER_LIFETIME = 6000;
    protected static final Map<BlockPos, Particle> PROP_MARKER_PARTICLES = new HashMap<BlockPos, Particle>();

    protected Level getWorld() {
        Minecraft mc = Minecraft.m_91087_();
        return mc.f_91073_;
    }

    public void wandPoof(double x, double y, double z, int color, boolean sound, Direction side) {
        Color c = new Color(color);
        float r = (float)c.getRed() / 255.0f;
        float g = (float)c.getGreen() / 255.0f;
        float b = (float)c.getBlue() / 255.0f;
        this.wandPoof(x, y, z, r, g, b, sound, side);
    }

    public void wandPoof(double x, double y, double z, float r, float g, float b, boolean sound, Direction side) {
        Minecraft mc = Minecraft.m_91087_();
        Level world = this.getWorld();
        RandomSource rng = world.f_46441_;
        if (sound) {
            this.getWorld().m_7785_(x, y, z, (SoundEvent)SoundsPM.POOF.get(), SoundSource.BLOCKS, 1.0f, 1.0f + (float)rng.m_188583_() * 0.05f, false);
        }
        for (int index = 0; index < 8 + rng.m_188503_(3); ++index) {
            Particle p;
            double dx = (double)rng.m_188501_() * 0.05 * (double)(rng.m_188499_() ? 1 : -1);
            double dy = (double)rng.m_188501_() * 0.05 * (double)(rng.m_188499_() ? 1 : -1);
            double dz = (double)rng.m_188501_() * 0.05 * (double)(rng.m_188499_() ? 1 : -1);
            if (side != null) {
                dx += (double)side.m_122429_() * 0.1;
                dy += (double)side.m_122430_() * 0.1;
                dz += (double)side.m_122431_() * 0.1;
            }
            if ((p = mc.f_91061_.m_107370_((ParticleOptions)ParticleTypesPM.WAND_POOF.get(), x + dx * 2.0, y + dy * 2.0, z + dz * 2.0, dx / 2.0, dy / 2.0, dz / 2.0)) == null) continue;
            p.m_107253_(r, g, b);
        }
    }

    public void manaSparkle(double x1, double y1, double z1, double x2, double y2, double z2, int maxAge, int color) {
        Color c = new Color(color);
        float r = (float)c.getRed() / 255.0f;
        float g = (float)c.getGreen() / 255.0f;
        float b = (float)c.getBlue() / 255.0f;
        this.manaSparkle(x1, y1, z1, x2, y2, z2, maxAge, r, g, b);
    }

    public void manaSparkle(double x1, double y1, double z1, double x2, double y2, double z2, int maxAge, float r, float g, float b) {
        Minecraft mc = Minecraft.m_91087_();
        double vx = (x2 - x1) / (double)maxAge;
        double vy = (y2 - y1) / (double)maxAge;
        double vz = (z2 - z1) / (double)maxAge;
        Particle p = mc.f_91061_.m_107370_((ParticleOptions)ParticleTypesPM.MANA_SPARKLE.get(), x1, y1, z1, vx, vy, vz);
        if (p != null) {
            p.m_107253_(r, g, b);
            p.m_107257_(maxAge);
        }
    }

    public void spellTrail(double x, double y, double z, int color) {
        Color c = new Color(color);
        float r = (float)c.getRed() / 255.0f;
        float g = (float)c.getGreen() / 255.0f;
        float b = (float)c.getBlue() / 255.0f;
        this.spellTrail(x, y, z, r, g, b);
    }

    public void spellTrail(double x, double y, double z, float r, float g, float b) {
        Minecraft mc = Minecraft.m_91087_();
        Particle p = mc.f_91061_.m_107370_((ParticleOptions)ParticleTypesPM.SPELL_SPARKLE.get(), x, y, z, 0.0, 0.0, 0.0);
        if (p != null) {
            p.m_107253_(r, g, b);
        }
    }

    public void spellImpact(double x, double y, double z, int radius, int color) {
        Color c = new Color(color);
        float r = (float)c.getRed() / 255.0f;
        float g = (float)c.getGreen() / 255.0f;
        float b = (float)c.getBlue() / 255.0f;
        this.spellImpact(x, y, z, radius, r, g, b);
    }

    public void spellImpact(double x, double y, double z, int radius, float r, float g, float b) {
        Minecraft mc = Minecraft.m_91087_();
        Level world = this.getWorld();
        RandomSource rng = world.f_46441_;
        int count = (15 + rng.m_188503_(11)) * radius;
        for (int index = 0; index < count; ++index) {
            double dx = (double)rng.m_188501_() * 0.035 * (double)radius * (double)(rng.m_188499_() ? 1 : -1);
            double dy = (double)rng.m_188501_() * 0.035 * (double)radius * (double)(rng.m_188499_() ? 1 : -1);
            double dz = (double)rng.m_188501_() * 0.035 * (double)radius * (double)(rng.m_188499_() ? 1 : -1);
            Particle p = mc.f_91061_.m_107370_((ParticleOptions)ParticleTypesPM.SPELL_SPARKLE.get(), x, y, z, dx, dy, dz);
            if (p == null) continue;
            p.m_107253_(r, g, b);
        }
    }

    public void ritualGlow(BlockPos pos, int color) {
        Minecraft mc = Minecraft.m_91087_();
        Level world = this.getWorld();
        RandomSource rng = world.f_46441_;
        Color c = new Color(color);
        float r = (float)c.getRed() / 255.0f;
        float g = (float)c.getGreen() / 255.0f;
        float b = (float)c.getBlue() / 255.0f;
        int count = 10 + rng.m_188503_(6);
        for (int index = 0; index < count; ++index) {
            Particle p = mc.f_91061_.m_107370_((ParticleOptions)ParticleTypesPM.SPELL_SPARKLE.get(), (double)pos.m_123341_() + rng.m_188500_(), (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + rng.m_188500_(), 0.0, 0.075, 0.0);
            if (p == null) continue;
            p.m_107253_(r, g, b);
        }
    }

    public void spellcraftingGlow(BlockPos pos, int color) {
        Color c = new Color(color);
        float r = (float)c.getRed() / 255.0f;
        float g = (float)c.getGreen() / 255.0f;
        float b = (float)c.getBlue() / 255.0f;
        this.spellcraftingGlow(pos, r, g, b);
    }

    public void spellcraftingGlow(BlockPos pos, float r, float g, float b) {
        Minecraft mc = Minecraft.m_91087_();
        Level world = this.getWorld();
        RandomSource rng = world.f_46441_;
        int count = 3 + rng.m_188503_(3);
        for (int index = 0; index < count; ++index) {
            double x = (double)pos.m_123341_() + 0.40625 + rng.m_188500_() * 0.1875;
            double y = (double)pos.m_123342_() + 1.125;
            double z = (double)pos.m_123343_() + 0.40625 + rng.m_188500_() * 0.1875;
            Particle p = mc.f_91061_.m_107370_((ParticleOptions)ParticleTypesPM.SPELL_SPARKLE.get(), x, y, z, 0.0, 0.0375, 0.0);
            if (p == null) continue;
            p.m_107253_(r, g, b);
        }
    }

    public void teleportArrival(double x, double y, double z) {
        Level world = this.getWorld();
        for (int i = 0; i < 32; ++i) {
            world.m_7106_((ParticleOptions)ParticleTypes.f_123760_, x, y + world.f_46441_.m_188500_() * 2.0, z, world.f_46441_.m_188583_(), 0.0, world.f_46441_.m_188583_());
        }
    }

    public void spellBolt(double sx, double sy, double sz, double tx, double ty, double tz, int color) {
        Color c = new Color(color);
        float r = (float)c.getRed() / 255.0f;
        float g = (float)c.getGreen() / 255.0f;
        float b = (float)c.getBlue() / 255.0f;
        this.spellBolt(sx, sy, sz, tx, ty, tz, r, g, b);
    }

    public void spellBolt(double sx, double sy, double sz, double tx, double ty, double tz, float r, float g, float b) {
        Minecraft mc = Minecraft.m_91087_();
        Particle p = mc.f_91061_.m_107370_((ParticleOptions)new SpellBoltParticleData(tx, ty, tz), sx, sy, sz, 0.0, 0.0, 0.0);
        if (p != null) {
            p.m_107253_(r, g, b);
        }
    }

    public void offeringChannel(double sx, double sy, double sz, double tx, double ty, double tz, ItemStack stack) {
        Minecraft mc = Minecraft.m_91087_();
        mc.f_91061_.m_107370_((ParticleOptions)new ItemParticleOption((ParticleType)ParticleTypesPM.OFFERING.get(), stack), sx, sy, sz, tx, ty, tz);
    }

    public void propMarker(BlockPos pos) {
        this.propMarker(pos, 6000);
    }

    public void propMarker(BlockPos pos, int lifetimeTicks) {
        Minecraft mc = Minecraft.m_91087_();
        Particle p = mc.f_91061_.m_107370_((ParticleOptions)ParticleTypesPM.PROP_MARKER.get(), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.5, (double)pos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
        p.m_107257_(lifetimeTicks);
        this.removePropMarker(pos);
        PROP_MARKER_PARTICLES.put(pos, p);
    }

    public void removePropMarker(BlockPos pos) {
        if (PROP_MARKER_PARTICLES.containsKey(pos)) {
            Particle oldParticle = PROP_MARKER_PARTICLES.remove(pos);
            oldParticle.m_107274_();
        }
    }

    public void pixieDust(double x, double y, double z, int color) {
        Color c = new Color(color);
        float r = (float)c.getRed() / 255.0f;
        float g = (float)c.getGreen() / 255.0f;
        float b = (float)c.getBlue() / 255.0f;
        this.pixieDust(x, y, z, r, g, b);
    }

    public void pixieDust(double x, double y, double z, float r, float g, float b) {
        Minecraft mc = Minecraft.m_91087_();
        Particle p = mc.f_91061_.m_107370_((ParticleOptions)ParticleTypesPM.SPELL_SPARKLE.get(), x, y, z, 0.0, -0.1, 0.0);
        if (p != null) {
            p.m_107253_(r, g, b);
        }
    }

    public void crucibleBubble(double x, double y, double z, int color) {
        Color c = new Color(color);
        float r = (float)c.getRed() / 255.0f;
        float g = (float)c.getGreen() / 255.0f;
        float b = (float)c.getBlue() / 255.0f;
        this.crucibleBubble(x, y, z, r, g, b);
    }

    public void crucibleBubble(double x, double y, double z, float r, float g, float b) {
        Minecraft mc = Minecraft.m_91087_();
        Particle p = mc.f_91061_.m_107370_((ParticleOptions)ParticleTypes.f_123795_, x, y, z, 0.0, 0.0, 0.0);
        if (p != null) {
            p.m_107253_(r, g, b);
        }
    }

    public void potionExplosion(double x, double y, double z, int color, boolean isInstant) {
        Color c = new Color(color);
        float r = (float)c.getRed() / 255.0f;
        float g = (float)c.getGreen() / 255.0f;
        float b = (float)c.getBlue() / 255.0f;
        this.potionExplosion(x, y, z, r, g, b, isInstant);
    }

    public void potionExplosion(double x, double y, double z, float r, float g, float b, boolean isInstant) {
        Minecraft mc = Minecraft.m_91087_();
        Level world = this.getWorld();
        world.m_7785_(x, y, z, SoundEvents.f_11913_, SoundSource.NEUTRAL, 4.0f, (1.0f + (world.f_46441_.m_188501_() - world.f_46441_.m_188501_()) * 0.2f) * 0.7f, false);
        world.m_7106_((ParticleOptions)ParticleTypes.f_123812_, x, y, z, 1.0, 0.0, 0.0);
        Particle p = mc.f_91061_.m_107370_((ParticleOptions)new PotionExplosionParticleData(isInstant), x, y, z, 1.0, 0.0, 0.0);
        if (p != null) {
            p.m_107253_(r, g, b);
        }
    }

    public void manaArrowTrail(double x, double y, double z, double dx, double dy, double dz, int color) {
        Color c = new Color(color);
        float r = (float)c.getRed() / 255.0f;
        float g = (float)c.getGreen() / 255.0f;
        float b = (float)c.getBlue() / 255.0f;
        this.manaArrowTrail(x, y, z, dx, dy, dz, r, g, b);
    }

    public void manaArrowTrail(double x, double y, double z, double dx, double dy, double dz, float r, float g, float b) {
        Minecraft mc = Minecraft.m_91087_();
        Particle p = mc.f_91061_.m_107370_((ParticleOptions)ParticleTypesPM.SPELL_SPARKLE.get(), x, y, z, dx, dy, dz);
        if (p != null) {
            p.m_107253_(r, g, b);
        }
    }

    public void spellcraftingRuneU(double x, double y, double z, double dx, double dy, double dz, int color) {
        Color c = new Color(color);
        float r = (float)c.getRed() / 255.0f;
        float g = (float)c.getGreen() / 255.0f;
        float b = (float)c.getBlue() / 255.0f;
        this.spellcraftingRuneU(x, y, z, dx, dy, dz, r, g, b);
    }

    public void spellcraftingRuneU(double x, double y, double z, double dx, double dy, double dz, float r, float g, float b) {
        Minecraft mc = Minecraft.m_91087_();
        Particle p = mc.f_91061_.m_107370_((ParticleOptions)ParticleTypesPM.SPELLCRAFTING_RUNE_U.get(), x, y, z, dx, dy, dz);
        if (p != null) {
            p.m_107253_(r, g, b);
        }
    }

    public void spellcraftingRuneV(double x, double y, double z, double dx, double dy, double dz, int color) {
        Color c = new Color(color);
        float r = (float)c.getRed() / 255.0f;
        float g = (float)c.getGreen() / 255.0f;
        float b = (float)c.getBlue() / 255.0f;
        this.spellcraftingRuneV(x, y, z, dx, dy, dz, r, g, b);
    }

    public void spellcraftingRuneV(double x, double y, double z, double dx, double dy, double dz, float r, float g, float b) {
        Minecraft mc = Minecraft.m_91087_();
        Particle p = mc.f_91061_.m_107370_((ParticleOptions)ParticleTypesPM.SPELLCRAFTING_RUNE_V.get(), x, y, z, dx, dy, dz);
        if (p != null) {
            p.m_107253_(r, g, b);
        }
    }

    public void spellcraftingRuneT(double x, double y, double z, double dx, double dy, double dz, int color) {
        Color c = new Color(color);
        float r = (float)c.getRed() / 255.0f;
        float g = (float)c.getGreen() / 255.0f;
        float b = (float)c.getBlue() / 255.0f;
        this.spellcraftingRuneT(x, y, z, dx, dy, dz, r, g, b);
    }

    public void spellcraftingRuneT(double x, double y, double z, double dx, double dy, double dz, float r, float g, float b) {
        Minecraft mc = Minecraft.m_91087_();
        Particle p = mc.f_91061_.m_107370_((ParticleOptions)ParticleTypesPM.SPELLCRAFTING_RUNE_T.get(), x, y, z, dx, dy, dz);
        if (p != null) {
            p.m_107253_(r, g, b);
        }
    }

    public void spellcraftingRuneD(double x, double y, double z, double dx, double dy, double dz, int color) {
        Color c = new Color(color);
        float r = (float)c.getRed() / 255.0f;
        float g = (float)c.getGreen() / 255.0f;
        float b = (float)c.getBlue() / 255.0f;
        this.spellcraftingRuneD(x, y, z, dx, dy, dz, r, g, b);
    }

    public void spellcraftingRuneD(double x, double y, double z, double dx, double dy, double dz, float r, float g, float b) {
        Minecraft mc = Minecraft.m_91087_();
        Particle p = mc.f_91061_.m_107370_((ParticleOptions)ParticleTypesPM.SPELLCRAFTING_RUNE_D.get(), x, y, z, dx, dy, dz);
        if (p != null) {
            p.m_107253_(r, g, b);
        }
    }

    public void bloodDrop(double x, double y, double z) {
        Minecraft mc = Minecraft.m_91087_();
        mc.f_91061_.m_107370_((ParticleOptions)ParticleTypesPM.DRIPPING_BLOOD_DROP.get(), x, y, z, 0.0, 0.0, 0.0);
    }
}

