/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.fx.particles;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.phys.Vec3;

public class ManaSparkleParticle
extends TextureSheetParticle {
    protected final SpriteSet spriteSet;
    protected final double initX;
    protected final double initY;
    protected final double initZ;
    protected final double initXSpeed;
    protected final double initYSpeed;
    protected final double initZSpeed;
    protected double sinYaw;
    protected double sinPitch;
    protected double cosYaw;
    protected double cosPitch;
    protected final double loops = 2.0;
    protected double dist = 1.0;

    protected ManaSparkleParticle(ClientLevel world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, SpriteSet spriteSet) {
        super(world, x, y, z, xSpeed, ySpeed, zSpeed);
        this.initX = x;
        this.initY = y;
        this.initZ = z;
        this.f_107215_ = this.initXSpeed = xSpeed;
        this.f_107216_ = this.initYSpeed = ySpeed;
        this.f_107217_ = this.initZSpeed = zSpeed;
        this.f_107663_ = 0.125f;
        this.spriteSet = spriteSet;
        this.m_108339_(this.spriteSet);
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public void m_107257_(int particleLifeTime) {
        super.m_107257_(particleLifeTime);
        double x2 = this.initXSpeed * (double)this.f_107225_ + this.initX;
        double y2 = this.initYSpeed * (double)this.f_107225_ + this.initY;
        double z2 = this.initZSpeed * (double)this.f_107225_ + this.initZ;
        Vec3 start = new Vec3(this.initX, this.initY, this.initZ);
        Vec3 end = new Vec3(x2, y2, z2);
        this.dist = end.m_82546_(start).m_82553_();
        Vec3 unitPath = end.m_82546_(start).m_82541_();
        double pitch = Math.asin(unitPath.f_82480_);
        double yaw = 1.5707963267948966 - Math.atan2(unitPath.f_82479_, unitPath.f_82481_);
        this.sinYaw = Math.sin(yaw);
        this.sinPitch = Math.sin(pitch);
        this.cosYaw = Math.cos(yaw);
        this.cosPitch = Math.cos(pitch);
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107224_ >= this.f_107225_) {
            this.m_107274_();
        } else {
            double t = (double)this.f_107224_ / (double)this.f_107225_;
            double tpl = Math.PI * 2 * this.loops;
            double theta = tpl * t;
            double radius = 0.5 * Math.sin(Math.PI * t);
            ++this.f_107224_;
            this.f_107212_ = this.initX + this.dist * this.cosYaw * this.cosPitch * t + radius * this.cosYaw * this.sinPitch * Math.sin(theta) + radius * this.sinYaw * this.cosPitch * Math.sin(theta);
            this.f_107213_ = this.initY + radius * this.cosPitch * Math.cos(theta) + this.dist * this.sinPitch * t;
            this.f_107214_ = this.initZ - radius * this.cosYaw * this.cosPitch * Math.sin(theta) - radius * this.cosYaw * this.sinPitch * Math.cos(theta) + this.dist * this.sinYaw * this.cosPitch * t;
        }
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        protected final SpriteSet spriteSet;

        public Factory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new ManaSparkleParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
        }
    }
}

