/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.fx.particles;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.client.fx.particles.ParticleTypesPM;
import java.util.Locale;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.registries.ForgeRegistries;

public class NoteEmitterParticleData
implements ParticleOptions {
    public static final Codec<NoteEmitterParticleData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.fieldOf("hue").forGetter(data -> data.hue), (App)Codec.INT.fieldOf("duration").forGetter(data -> data.duration)).apply((Applicative)instance, NoteEmitterParticleData::new));
    public static final ParticleOptions.Deserializer<NoteEmitterParticleData> DESERIALIZER = new ParticleOptions.Deserializer<NoteEmitterParticleData>(){

        public NoteEmitterParticleData fromCommand(ParticleType<NoteEmitterParticleData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            double hue = reader.readDouble();
            reader.expect(' ');
            int duration = reader.readInt();
            return new NoteEmitterParticleData(hue, duration);
        }

        public NoteEmitterParticleData fromNetwork(ParticleType<NoteEmitterParticleData> particleTypeIn, FriendlyByteBuf buffer) {
            return new NoteEmitterParticleData(buffer.readDouble(), buffer.readInt());
        }
    };
    protected final double hue;
    protected final int duration;

    public NoteEmitterParticleData(double hue, int duration) {
        this.hue = hue;
        this.duration = duration;
    }

    public ParticleType<?> m_6012_() {
        return (ParticleType)ParticleTypesPM.NOTE_EMITTER.get();
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeDouble(this.hue);
        buffer.writeInt(this.duration);
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %d %d", ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()), this.hue, this.duration);
    }

    public double getHue() {
        return this.hue;
    }

    public int getDuration() {
        return this.duration;
    }
}

