/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.fx.particles;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.verdantartifice.primalmagick.client.fx.particles.SpellBoltParticleData;
import com.verdantartifice.primalmagick.client.renderers.types.ThickLinesRenderType;
import com.verdantartifice.primalmagick.common.util.LineSegment;
import com.verdantartifice.primalmagick.common.util.VectorUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.phys.Vec3;

public class SpellBoltParticle
extends Particle {
    protected static final float WIDTH = 6.0f;
    protected static final double MAX_DISPLACEMENT = 0.5;
    protected static final double PERTURB_DISTANCE = 0.002;
    protected static final int GENERATIONS = 5;
    protected final Vec3 delta;
    protected final List<LineSegment> segmentList;
    protected final List<Vec3> perturbList;

    protected SpellBoltParticle(ClientLevel world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, Vec3 target) {
        super(world, x, y, z, xSpeed, ySpeed, zSpeed);
        this.delta = target.m_82546_(new Vec3(x, y, z));
        this.f_107215_ = 0.0;
        this.f_107216_ = 0.0;
        this.f_107217_ = 0.0;
        this.f_107225_ = 10;
        this.segmentList = this.calcSegments();
        this.perturbList = this.calcPerturbs();
    }

    @Nonnull
    protected List<LineSegment> calcSegments() {
        ArrayList<LineSegment> retVal = new ArrayList<LineSegment>();
        double curDisplacement = 0.5;
        retVal.add(new LineSegment(Vec3.f_82478_, this.delta));
        for (int gen = 0; gen < 5; ++gen) {
            ArrayList<LineSegment> tempList = new ArrayList<LineSegment>();
            for (LineSegment segment : retVal) {
                Vec3 midpoint = segment.getMiddle();
                midpoint = midpoint.m_82549_(VectorUtils.getRandomOrthogonalUnitVector(segment.getDelta(), this.f_107208_.f_46441_).m_82490_(curDisplacement));
                tempList.add(new LineSegment(segment.getStart(), midpoint));
                tempList.add(new LineSegment(midpoint, segment.getEnd()));
            }
            retVal = tempList;
            curDisplacement /= 2.0;
        }
        return retVal;
    }

    @Nonnull
    protected List<Vec3> calcPerturbs() {
        ArrayList<Vec3> retVal = new ArrayList<Vec3>();
        retVal.add(Vec3.f_82478_);
        for (LineSegment segment : this.segmentList) {
            retVal.add(segment.getEnd().equals((Object)this.delta) ? Vec3.f_82478_ : VectorUtils.getRandomUnitVector(this.f_107208_.f_46441_).m_82490_(0.002 * this.f_107208_.f_46441_.m_188500_()));
        }
        return retVal;
    }

    public void m_5744_(VertexConsumer builder, Camera entityIn, float partialTicks) {
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)1);
        RenderSystem.disableCull();
        PoseStack stack = RenderSystem.getModelViewStack();
        stack.m_85836_();
        stack.m_85837_(this.f_107212_ - entityIn.m_90583_().f_82479_, this.f_107213_ - entityIn.m_90583_().f_82480_, this.f_107214_ - entityIn.m_90583_().f_82481_);
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        VertexConsumer lineBuilder = buffer.m_6299_(ThickLinesRenderType.THICK_LINES);
        for (int index = 0; index < this.segmentList.size(); ++index) {
            LineSegment segment = this.segmentList.get(index);
            segment.perturb(this.perturbList.get(index), this.perturbList.get(index + 1));
            lineBuilder.m_5483_(segment.getStart().f_82479_, segment.getStart().f_82480_, segment.getStart().f_82481_).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, 0.5f).m_5752_();
            lineBuilder.m_5483_(segment.getEnd().f_82479_, segment.getEnd().f_82480_, segment.getEnd().f_82481_).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, 0.5f).m_5752_();
        }
        buffer.m_109912_(ThickLinesRenderType.THICK_LINES);
        RenderSystem.enableCull();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        stack.m_85849_();
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107433_;
    }

    public static class Factory
    implements ParticleProvider<SpellBoltParticleData> {
        public Factory(SpriteSet spriteSet) {
        }

        public Particle createParticle(SpellBoltParticleData typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new SpellBoltParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, typeIn.getTargetVec());
        }
    }
}

