/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.fx.particles;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.client.fx.particles.ParticleTypesPM;
import java.util.Locale;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class SpellBoltParticleData
implements ParticleOptions {
    public static final Codec<SpellBoltParticleData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.fieldOf("x").forGetter(data -> data.target.f_82479_), (App)Codec.DOUBLE.fieldOf("y").forGetter(data -> data.target.f_82480_), (App)Codec.DOUBLE.fieldOf("z").forGetter(data -> data.target.f_82481_)).apply((Applicative)instance, SpellBoltParticleData::new));
    public static final ParticleOptions.Deserializer<SpellBoltParticleData> DESERIALIZER = new ParticleOptions.Deserializer<SpellBoltParticleData>(){

        public SpellBoltParticleData fromCommand(ParticleType<SpellBoltParticleData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            double x = reader.readDouble();
            reader.expect(' ');
            double y = reader.readDouble();
            reader.expect(' ');
            double z = reader.readDouble();
            return new SpellBoltParticleData(x, y, z);
        }

        public SpellBoltParticleData fromNetwork(ParticleType<SpellBoltParticleData> particleTypeIn, FriendlyByteBuf buffer) {
            return new SpellBoltParticleData(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        }
    };
    protected final Vec3 target;

    public SpellBoltParticleData(Vec3 target) {
        this(target.f_82479_, target.f_82480_, target.f_82481_);
    }

    public SpellBoltParticleData(double targetX, double targetY, double targetZ) {
        this.target = new Vec3(targetX, targetY, targetZ);
    }

    public ParticleType<?> m_6012_() {
        return (ParticleType)ParticleTypesPM.SPELL_BOLT.get();
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeDouble(this.target.f_82479_);
        buffer.writeDouble(this.target.f_82480_);
        buffer.writeDouble(this.target.f_82481_);
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %d %d %d", ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()), this.target.f_82479_, this.target.f_82480_, this.target.f_82481_);
    }

    public Vec3 getTargetVec() {
        return this.target;
    }
}

