/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui;

import com.verdantartifice.primalmagick.PrimalMagick;
import com.verdantartifice.primalmagick.client.gui.widgets.AffinityWidget;
import com.verdantartifice.primalmagick.client.gui.widgets.research_table.KnowledgeTotalWidget;
import com.verdantartifice.primalmagick.common.affinities.AffinityManager;
import com.verdantartifice.primalmagick.common.menus.AnalysisTableMenu;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.misc.AnalysisActionPacket;
import com.verdantartifice.primalmagick.common.research.KnowledgeType;
import com.verdantartifice.primalmagick.common.sources.Source;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.mutable.MutableObject;

public class AnalysisTableScreen
extends AbstractContainerScreen<AnalysisTableMenu> {
    private static final ResourceLocation TEXTURE = PrimalMagick.resource("textures/gui/analysis_table.png");
    protected Level world;
    protected final List<AffinityWidget> affinityWidgets = new ArrayList<AffinityWidget>();

    public AnalysisTableScreen(AnalysisTableMenu screenMenu, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenMenu, inv, titleIn);
        this.world = inv.f_35978_.m_9236_();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.initControlWidgets();
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.initAffinityWidgets();
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        guiGraphics.m_280218_(TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        MutableObject text = new MutableObject(null);
        ItemStack lastScannedStack = ((AnalysisTableMenu)this.f_97732_).getLastScannedStack();
        if (lastScannedStack == null || lastScannedStack.m_41619_()) {
            text.setValue((Object)Component.m_237115_((String)"label.primalmagick.analysis.no_item"));
        } else {
            AffinityManager.getInstance().getAffinityValues(lastScannedStack, this.world).ifPresentOrElse(sources -> {
                if (sources == null || sources.isEmpty()) {
                    text.setValue((Object)Component.m_237115_((String)"label.primalmagick.analysis.no_affinities"));
                }
            }, () -> text.setValue((Object)Component.m_237115_((String)"label.primalmagick.analysis.calculating")));
        }
        if (text.getValue() != null) {
            int width = this.f_96547_.m_92895_(((Component)text.getValue()).getString());
            int x = 1 + (this.getXSize() - width) / 2;
            Objects.requireNonNull(this.f_96547_);
            int y = 10 + (16 - 9) / 2;
            guiGraphics.m_280614_(this.f_96547_, (Component)text.getValue(), x, y, Color.BLACK.getRGB(), false);
        }
    }

    protected void initControlWidgets() {
        this.m_142416_((GuiEventListener)new AnalyzeButton((AnalysisTableMenu)this.f_97732_, this.f_97735_, this.f_97736_));
        this.m_142416_((GuiEventListener)new KnowledgeTotalWidget(this.f_97735_ + 8, this.f_97736_ + 60, KnowledgeType.OBSERVATION));
    }

    protected void initAffinityWidgets() {
        this.affinityWidgets.forEach(widget -> this.m_169411_((GuiEventListener)widget));
        this.affinityWidgets.clear();
        ItemStack lastScannedStack = ((AnalysisTableMenu)this.f_97732_).getLastScannedStack();
        if (lastScannedStack != null && !lastScannedStack.m_41619_()) {
            AffinityManager.getInstance().getAffinityValues(lastScannedStack, this.world).ifPresent(sources -> {
                if (!sources.isEmpty()) {
                    int widgetSetWidth = sources.getSourcesSorted().size() * 18;
                    int x = this.f_97735_ + 1 + (this.getXSize() - widgetSetWidth) / 2;
                    int y = this.f_97736_ + 10;
                    for (Source source : sources.getSourcesSorted()) {
                        this.affinityWidgets.add((AffinityWidget)this.m_142416_((GuiEventListener)new AffinityWidget(source, sources.getAmount(source), x, y)));
                        x += 18;
                    }
                }
            });
        }
    }

    protected static class AnalyzeButton
    extends ImageButton {
        private static final ResourceLocation BUTTON_TEXTURE = PrimalMagick.resource("textures/gui/analysis_button.png");
        protected static final Component ANALYZE_BUTTON_TOOLTIP_1 = Component.m_237115_((String)"tooltip.primalmagick.analyze_button.1");
        protected static final Component ANALYZE_BUTTON_TOOLTIP_2 = Component.m_237115_((String)"tooltip.primalmagick.analyze_button.2").m_130940_(ChatFormatting.RED);

        public AnalyzeButton(AnalysisTableMenu menu, int leftPos, int topPos) {
            super(leftPos + 78, topPos + 34, 20, 18, 0, 0, 19, BUTTON_TEXTURE, 256, 256, button -> PacketHandler.sendToServer(new AnalysisActionPacket(menu.f_38840_)));
            this.m_257544_(Tooltip.m_257550_((Component)CommonComponents.m_178396_((Component[])new Component[]{ANALYZE_BUTTON_TOOLTIP_1, ANALYZE_BUTTON_TOOLTIP_2})));
        }
    }
}

