/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui;

import com.verdantartifice.primalmagick.PrimalMagick;
import com.verdantartifice.primalmagick.client.gui.recipe_book.ArcaneRecipeBookComponent;
import com.verdantartifice.primalmagick.client.gui.recipe_book.ArcaneRecipeUpdateListener;
import com.verdantartifice.primalmagick.client.gui.widgets.ManaCostWidget;
import com.verdantartifice.primalmagick.common.crafting.IArcaneRecipe;
import com.verdantartifice.primalmagick.common.menus.ArcaneWorkbenchMenu;
import com.verdantartifice.primalmagick.common.menus.base.IArcaneRecipeBookMenu;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ArcaneWorkbenchScreen
extends AbstractContainerScreen<ArcaneWorkbenchMenu>
implements ArcaneRecipeUpdateListener {
    protected static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation TEXTURE = PrimalMagick.resource("textures/gui/arcane_workbench.png");
    private static final ResourceLocation RECIPE_BUTTON_LOCATION = new ResourceLocation("textures/gui/recipe_button.png");
    protected final ArcaneRecipeBookComponent recipeBookComponent = new ArcaneRecipeBookComponent();
    protected List<ManaCostWidget> costWidgets = new ArrayList<ManaCostWidget>();
    protected boolean widthTooNarrow;

    public ArcaneWorkbenchScreen(ArcaneWorkbenchMenu screenMenu, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenMenu, inv, titleIn);
        this.f_97727_ = 183;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.widthTooNarrow = this.f_96543_ < 379;
        this.recipeBookComponent.init(this.f_96543_, this.f_96544_, this.f_96541_, this.widthTooNarrow, false, (IArcaneRecipeBookMenu)this.f_97732_);
        this.f_97735_ = this.recipeBookComponent.updateScreenPosition(this.f_96543_, this.f_97726_);
        this.initCostWidgets();
        this.m_142416_((GuiEventListener)new ImageButton(this.f_97735_ + 105, this.f_97736_ + 69, 20, 18, 0, 0, 19, RECIPE_BUTTON_LOCATION, button -> {
            this.recipeBookComponent.toggleVisibility();
            this.f_97735_ = this.recipeBookComponent.updateScreenPosition(this.f_96543_, this.f_97726_);
            ((ImageButton)button).m_264152_(this.f_97735_ + 105, this.f_97736_ + 69);
        }));
        this.m_7787_(this.recipeBookComponent);
        this.m_264313_(this.recipeBookComponent);
        this.f_97728_ = 29;
    }

    protected void m_181908_() {
        super.m_181908_();
        this.recipeBookComponent.tick();
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.adjustCostWidgets();
        this.m_280273_(guiGraphics);
        if (this.recipeBookComponent.isVisible() && this.widthTooNarrow) {
            this.m_7286_(guiGraphics, partialTicks, mouseX, mouseY);
            this.recipeBookComponent.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        } else {
            this.recipeBookComponent.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
            super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
            this.recipeBookComponent.renderGhostRecipe(guiGraphics, this.f_97735_, this.f_97736_, true, partialTicks);
        }
        this.m_280072_(guiGraphics, mouseX, mouseY);
        this.recipeBookComponent.renderTooltip(guiGraphics, this.f_97735_, this.f_97736_, mouseX, mouseY);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        guiGraphics.m_280218_(TEXTURE, this.f_97735_, (this.f_96544_ - this.f_97727_) / 2, 0, 0, this.f_97726_, this.f_97727_);
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        IArcaneRecipe activeArcaneRecipe = ((ArcaneWorkbenchMenu)this.f_97732_).getActiveArcaneRecipe();
        if (activeArcaneRecipe == null || activeArcaneRecipe.getManaCosts() == null || activeArcaneRecipe.getManaCosts().isEmpty()) {
            MutableComponent text = Component.m_237115_((String)"label.primalmagick.crafting.no_mana");
            int width = this.f_96547_.m_92895_(text.getString());
            int x = 1 + (this.getXSize() - width) / 2;
            Objects.requireNonNull(this.f_96547_);
            int y = 10 + (16 - 9) / 2;
            guiGraphics.m_280614_(this.f_96547_, (Component)text, x, y, Color.BLACK.getRGB(), false);
        }
    }

    protected void initCostWidgets() {
        this.costWidgets.clear();
        int widgetSetWidth = Source.SORTED_SOURCES.size() * 18;
        int x = this.f_97735_ + 1 + (this.getXSize() - widgetSetWidth) / 2;
        int y = this.f_97736_ + 10;
        for (Source source : Source.SORTED_SOURCES) {
            this.costWidgets.add((ManaCostWidget)this.m_142416_((GuiEventListener)new ManaCostWidget(source, 0, x, y, ((ArcaneWorkbenchMenu)this.f_97732_)::getWand, ((ArcaneWorkbenchMenu)this.f_97732_).getPlayer())));
            x += 18;
        }
    }

    protected void adjustCostWidgets() {
        IArcaneRecipe activeArcaneRecipe = ((ArcaneWorkbenchMenu)this.f_97732_).getActiveArcaneRecipe();
        if (activeArcaneRecipe != null) {
            SourceList manaCosts = activeArcaneRecipe.getManaCosts();
            int widgetSetWidth = manaCosts.getSourcesSorted().size() * 18;
            int dx = 0;
            for (ManaCostWidget widget2 : this.costWidgets) {
                int amount = manaCosts.getAmount(widget2.getSource());
                boolean bl = widget2.f_93624_ = amount > 0;
                if (!widget2.f_93624_) continue;
                widget2.setAmount(amount);
                widget2.m_252865_(this.f_97735_ + 1 + dx + (this.getXSize() - widgetSetWidth) / 2);
                dx += 18;
            }
        } else {
            this.costWidgets.forEach(widget -> {
                widget.f_93624_ = false;
            });
        }
    }

    protected boolean m_6774_(int p_97768_, int p_97769_, int p_97770_, int p_97771_, double p_97772_, double p_97773_) {
        return (!this.widthTooNarrow || !this.recipeBookComponent.isVisible()) && super.m_6774_(p_97768_, p_97769_, p_97770_, p_97771_, p_97772_, p_97773_);
    }

    public boolean m_6375_(double mouseX, double mouseY, int buttonIndex) {
        if (this.recipeBookComponent.m_6375_(mouseX, mouseY, buttonIndex)) {
            this.m_7522_(this.recipeBookComponent);
            return true;
        }
        return this.widthTooNarrow && this.recipeBookComponent.isVisible() ? true : super.m_6375_(mouseX, mouseY, buttonIndex);
    }

    protected boolean m_7467_(double mouseX, double mouseY, int leftPos, int topPos, int buttonIndex) {
        boolean flag = mouseX < (double)leftPos || mouseY < (double)topPos || mouseX >= (double)(leftPos + this.f_97726_) || mouseY >= (double)(topPos + this.f_97727_);
        return this.recipeBookComponent.hasClickedOutside(mouseX, mouseY, this.f_97735_, this.f_97736_, this.f_97726_, this.f_97727_, buttonIndex) && flag;
    }

    protected void m_6597_(Slot p_97778_, int p_97779_, int p_97780_, ClickType p_97781_) {
        super.m_6597_(p_97778_, p_97779_, p_97780_, p_97781_);
        this.recipeBookComponent.slotClicked(p_97778_);
    }

    @Override
    public void recipesUpdated() {
        this.recipeBookComponent.recipesUpdated();
    }

    @Override
    public ArcaneRecipeBookComponent getRecipeBookComponent() {
        return this.recipeBookComponent;
    }
}

