/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui;

import com.verdantartifice.primalmagick.PrimalMagick;
import com.verdantartifice.primalmagick.client.gui.widgets.EssenceCaskWidget;
import com.verdantartifice.primalmagick.common.items.essence.EssenceType;
import com.verdantartifice.primalmagick.common.menus.EssenceCaskMenu;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.misc.WithdrawCaskEssencePacket;
import com.verdantartifice.primalmagick.common.sources.Source;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class EssenceCaskScreen
extends AbstractContainerScreen<EssenceCaskMenu> {
    protected static final ResourceLocation TEXTURE = PrimalMagick.resource("textures/gui/essence_cask.png");
    protected final List<EssenceCaskWidget> caskWidgets = new ArrayList<EssenceCaskWidget>();
    protected long lastCheck = 0L;
    protected int lastTotalEssence = 0;

    public EssenceCaskScreen(EssenceCaskMenu screenMenu, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenMenu, inv, titleIn);
        this.f_97726_ = 176;
        this.f_97727_ = 222;
        this.f_97731_ = this.f_97727_ - 94;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.lastTotalEssence = ((EssenceCaskMenu)this.f_97732_).getTotalEssenceCount();
        this.initWidgets();
    }

    protected void initWidgets() {
        Minecraft mc = Minecraft.m_91087_();
        this.m_169413_();
        this.caskWidgets.clear();
        int visibleRows = Arrays.stream(EssenceType.values()).mapToInt(t -> ((EssenceCaskMenu)this.f_97732_).isEssenceTypeVisible((EssenceType)((Object)t), (Player)mc.f_91074_) ? 1 : 0).sum();
        int visibleCols = Source.SORTED_SOURCES.stream().mapToInt(s -> ((EssenceCaskMenu)this.f_97732_).isEssenceSourceVisible((Source)s, (Player)mc.f_91074_) ? 1 : 0).sum();
        int startX = this.f_97735_ + 8 + (Source.SORTED_SOURCES.size() - visibleCols) * 18 / 2;
        int startY = this.f_97736_ + 18 + (EssenceType.values().length - visibleRows) * 18 / 2;
        int index = 0;
        int xPos = startX;
        int yPos = startY;
        for (int row = 0; row < EssenceType.values().length; ++row) {
            boolean rowPopulated = false;
            for (int col = 0; col < Source.SORTED_SOURCES.size(); ++col) {
                EssenceType cellType = EssenceType.values()[row];
                Source cellSource = Source.SORTED_SOURCES.get(col);
                if (((EssenceCaskMenu)this.f_97732_).isEssenceTypeVisible(cellType, (Player)mc.f_91074_) && ((EssenceCaskMenu)this.f_97732_).isEssenceSourceVisible(cellSource, (Player)mc.f_91074_)) {
                    int count = ((EssenceCaskMenu)this.f_97732_).getEssenceCount(index);
                    this.caskWidgets.add((EssenceCaskWidget)this.m_142416_((GuiEventListener)new EssenceCaskWidget(index, cellType, cellSource, count, xPos, yPos, this::onWidgetClicked)));
                    xPos += 18;
                    rowPopulated = true;
                }
                ++index;
            }
            xPos = startX;
            if (!rowPopulated) continue;
            yPos += 18;
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        long millis = System.currentTimeMillis();
        if (millis > this.lastCheck || this.lastTotalEssence != ((EssenceCaskMenu)this.f_97732_).getTotalEssenceCount()) {
            this.lastCheck = millis + 2000L;
            this.lastTotalEssence = ((EssenceCaskMenu)this.f_97732_).getTotalEssenceCount();
            this.initWidgets();
        }
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.m_280072_(guiGraphics, mouseX, mouseY);
        for (EssenceCaskWidget widget : this.caskWidgets) {
            if (!widget.m_274382_()) continue;
            EssenceCaskScreen.renderSlotHighlight((GuiGraphics)guiGraphics, (int)widget.m_252754_(), (int)widget.m_252907_(), (int)0, (int)this.slotColor);
        }
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        guiGraphics.m_280218_(TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.m_280003_(guiGraphics, mouseX, mouseY);
        MutableComponent contentsLabel = Component.m_237110_((String)"label.primalmagick.essence_cask.contents", (Object[])new Object[]{((EssenceCaskMenu)this.f_97732_).getTotalEssenceCount(), ((EssenceCaskMenu)this.f_97732_).getTotalEssenceCapacity()});
        guiGraphics.m_280614_(this.f_96547_, (Component)contentsLabel, 8, 92, 0x404040, false);
    }

    protected void onWidgetClicked(EssenceCaskWidget widget, int clickButton) {
        int toRemove = clickButton == 1 ? 1 : 64;
        PacketHandler.sendToServer(new WithdrawCaskEssencePacket(widget.getEssenceType(), widget.getSource(), toRemove, ((EssenceCaskMenu)this.f_97732_).getTilePos()));
    }
}

