/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui;

import com.verdantartifice.primalmagick.PrimalMagick;
import com.verdantartifice.primalmagick.client.config.KeyBindings;
import com.verdantartifice.primalmagick.client.gui.grimoire.AbstractPage;
import com.verdantartifice.primalmagick.client.gui.grimoire.AbstractRecipePage;
import com.verdantartifice.primalmagick.client.gui.grimoire.AttunementGainPage;
import com.verdantartifice.primalmagick.client.gui.grimoire.AttunementIndexPage;
import com.verdantartifice.primalmagick.client.gui.grimoire.AttunementPage;
import com.verdantartifice.primalmagick.client.gui.grimoire.DisciplineIndexPage;
import com.verdantartifice.primalmagick.client.gui.grimoire.DisciplinePage;
import com.verdantartifice.primalmagick.client.gui.grimoire.IPageElement;
import com.verdantartifice.primalmagick.client.gui.grimoire.OtherIndexPage;
import com.verdantartifice.primalmagick.client.gui.grimoire.PageImage;
import com.verdantartifice.primalmagick.client.gui.grimoire.PageString;
import com.verdantartifice.primalmagick.client.gui.grimoire.RecipeIndexPage;
import com.verdantartifice.primalmagick.client.gui.grimoire.RecipeMetadataPage;
import com.verdantartifice.primalmagick.client.gui.grimoire.RecipePageFactory;
import com.verdantartifice.primalmagick.client.gui.grimoire.RequirementsPage;
import com.verdantartifice.primalmagick.client.gui.grimoire.RuneEnchantmentIndexPage;
import com.verdantartifice.primalmagick.client.gui.grimoire.RuneEnchantmentPage;
import com.verdantartifice.primalmagick.client.gui.grimoire.StagePage;
import com.verdantartifice.primalmagick.client.gui.grimoire.StatisticsPage;
import com.verdantartifice.primalmagick.client.gui.grimoire.TipsPage;
import com.verdantartifice.primalmagick.client.gui.widgets.grimoire.BackButton;
import com.verdantartifice.primalmagick.client.gui.widgets.grimoire.MainIndexButton;
import com.verdantartifice.primalmagick.client.gui.widgets.grimoire.PageButton;
import com.verdantartifice.primalmagick.client.tips.TipManager;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerKnowledge;
import com.verdantartifice.primalmagick.common.capabilities.PrimalMagickCapabilities;
import com.verdantartifice.primalmagick.common.crafting.IHasRequiredResearch;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.data.SetResearchTopicHistoryPacket;
import com.verdantartifice.primalmagick.common.research.CompoundResearchKey;
import com.verdantartifice.primalmagick.common.research.ResearchAddendum;
import com.verdantartifice.primalmagick.common.research.ResearchDiscipline;
import com.verdantartifice.primalmagick.common.research.ResearchDisciplines;
import com.verdantartifice.primalmagick.common.research.ResearchEntry;
import com.verdantartifice.primalmagick.common.research.ResearchManager;
import com.verdantartifice.primalmagick.common.research.ResearchStage;
import com.verdantartifice.primalmagick.common.research.SimpleResearchKey;
import com.verdantartifice.primalmagick.common.research.topics.AbstractResearchTopic;
import com.verdantartifice.primalmagick.common.research.topics.DisciplineResearchTopic;
import com.verdantartifice.primalmagick.common.research.topics.EnchantmentResearchTopic;
import com.verdantartifice.primalmagick.common.research.topics.EntryResearchTopic;
import com.verdantartifice.primalmagick.common.research.topics.MainIndexResearchTopic;
import com.verdantartifice.primalmagick.common.research.topics.OtherResearchTopic;
import com.verdantartifice.primalmagick.common.research.topics.SourceResearchTopic;
import com.verdantartifice.primalmagick.common.runes.RuneManager;
import com.verdantartifice.primalmagick.common.runes.RuneType;
import com.verdantartifice.primalmagick.common.sounds.SoundsPM;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.common.stats.Stat;
import com.verdantartifice.primalmagick.common.stats.StatsManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.StringDecomposer;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GrimoireScreen
extends Screen {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation TEXTURE = PrimalMagick.resource("textures/gui/grimoire.png");
    private static final PageImage IMAGE_LINE = PageImage.parse("primalmagick:textures/gui/grimoire.png:24:184:95:6:1");
    private static final float SCALE = 1.3f;
    private static final int HISTORY_LIMIT = 64;
    private static final int BG_WIDTH = 256;
    private static final int BG_HEIGHT = 181;
    protected int leftPos;
    protected int topPos;
    protected int scaledLeft;
    protected int scaledTop;
    protected int currentPage = 0;
    protected int currentStageIndex = 0;
    protected int lastStageIndex = 0;
    protected long lastCheck = 0L;
    protected boolean progressing = false;
    protected List<AbstractPage> pages = new ArrayList<AbstractPage>();
    protected IPlayerKnowledge knowledge;
    protected NavigableMap<String, List<Recipe<?>>> indexMap;
    protected Component cachedTip = null;
    protected Optional<String> lastRecipeSearch = Optional.empty();
    protected PageButton nextPageButton;
    protected PageButton prevPageButton;
    protected BackButton backButton;

    public GrimoireScreen() {
        super((Component)Component.m_237119_());
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        long millis = System.currentTimeMillis();
        if ((this.isProgressing() || this.currentStageIndex > this.lastStageIndex) && millis > this.lastCheck) {
            if (this.currentStageIndex > this.lastStageIndex) {
                this.progressing = false;
                this.lastStageIndex = this.currentStageIndex;
                this.currentPage = 0;
                this.updateNavButtonVisibility();
            }
            this.lastCheck = millis + 250L;
            this.initPages();
            this.initButtons();
        }
        this.m_280273_(guiGraphics);
        this.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public boolean isProgressing() {
        return this.progressing;
    }

    public void setProgressing() {
        this.progressing = true;
        this.lastCheck = 0L;
        this.lastStageIndex = this.currentStageIndex;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.leftPos = (this.f_96543_ - 256) / 2;
        this.topPos = (this.f_96544_ - 181) / 2;
        this.scaledLeft = (int)((float)this.f_96543_ - 332.8f) / 2;
        this.scaledTop = (int)((float)this.f_96544_ - 235.29999f) / 2;
        Minecraft mc = this.getMinecraft();
        this.knowledge = (IPlayerKnowledge)PrimalMagickCapabilities.getKnowledge((Player)mc.f_91074_).orElseThrow(() -> new IllegalStateException("No knowledge provider found for player"));
        this.generateIndexMap();
        this.initPages();
        this.initButtons();
        this.setCurrentPage(this.knowledge.getLastResearchTopic().getPage());
        PacketHandler.sendToServer(new SetResearchTopicHistoryPacket(this.knowledge.getLastResearchTopic(), this.getHistoryView()));
    }

    protected void initPages() {
        this.pages.clear();
        AbstractResearchTopic topic = this.knowledge.getLastResearchTopic();
        if (topic instanceof MainIndexResearchTopic) {
            this.parseIndexPages();
        } else if (topic instanceof DisciplineResearchTopic) {
            DisciplineResearchTopic discTopic = (DisciplineResearchTopic)topic;
            this.parseDisciplinePages(discTopic.getData());
        } else if (topic instanceof EntryResearchTopic) {
            EntryResearchTopic entryTopic = (EntryResearchTopic)topic;
            this.parseEntryPages(entryTopic.getData());
        } else if (topic instanceof SourceResearchTopic) {
            SourceResearchTopic sourceTopic = (SourceResearchTopic)topic;
            this.parseAttunementPage(sourceTopic.getData());
        } else if (topic instanceof EnchantmentResearchTopic) {
            EnchantmentResearchTopic enchTopic = (EnchantmentResearchTopic)topic;
            this.parseRuneEnchantmentPage(enchTopic.getData());
        } else if (topic instanceof OtherResearchTopic) {
            OtherResearchTopic otherTopic = (OtherResearchTopic)topic;
            String data = otherTopic.getData();
            if (this.isIndexKey(data)) {
                this.parseRecipeEntryPages(data);
            } else if (StatisticsPage.TOPIC.getData().equals(data)) {
                this.parseStatsPages();
            } else if (AttunementIndexPage.TOPIC.getData().equals(data)) {
                this.parseAttunementIndexPages();
            } else if (RuneEnchantmentIndexPage.TOPIC.getData().equals(data)) {
                this.parseRuneEnchantmentIndexPages();
            } else if (RecipeIndexPage.TOPIC.getData().equals(data)) {
                this.parseRecipeIndexPages();
            } else if (TipsPage.TOPIC.getData().equals(data)) {
                this.parseTipsPages();
            } else {
                LOGGER.warn("Unexpected OtherResearchTopic data {}", (Object)data);
            }
        } else {
            LOGGER.warn("Unexpected research topic type {}", (Object)topic.getType().toString());
        }
    }

    protected void initButtons() {
        int current = 0;
        this.m_169413_();
        for (AbstractPage page : this.pages) {
            if ((current == this.currentPage || current == this.currentPage + 1) && current < this.pages.size()) {
                this.initPageButtons(page, current % 2, this.scaledLeft + 23, this.scaledTop + 9);
            }
            if (++current <= this.currentPage + 1) continue;
            break;
        }
        this.nextPageButton = new PageButton(this.leftPos + 258, this.topPos + 172, this, true);
        this.prevPageButton = new PageButton(this.leftPos - 12, this.topPos + 172, this, false);
        this.backButton = new BackButton(this.leftPos + 120, this.topPos + 172, this);
        this.m_142416_((GuiEventListener)this.nextPageButton);
        this.m_142416_((GuiEventListener)this.prevPageButton);
        this.m_142416_((GuiEventListener)this.backButton);
        this.m_142416_((GuiEventListener)new MainIndexButton(this.leftPos + 142, this.topPos + 177, this));
        this.updateNavButtonVisibility();
    }

    public <T extends AbstractWidget> T addWidgetToScreen(T widget) {
        return (T)((AbstractWidget)this.m_142416_((GuiEventListener)widget));
    }

    private void initPageButtons(AbstractPage abstractPage, int side, int x, int y) {
        if (this.currentPage == 0 && side == 0) {
            y += 53;
        }
        if (this.currentPage > 0 || side == 1) {
            y += 29;
        }
        abstractPage.initWidgets(this, side, x, y);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)this.scaledLeft, (float)this.scaledTop, 0.0f);
        guiGraphics.m_280168_().m_85841_(1.3f, 1.3f, 1.0f);
        guiGraphics.m_280218_(TEXTURE, 0, 0, 0, 0, 256, 181);
        guiGraphics.m_280168_().m_85849_();
        int current = 0;
        for (AbstractPage page : this.pages) {
            if ((current == this.currentPage || current == this.currentPage + 1) && current < this.pages.size()) {
                page.render(guiGraphics, current % 2, this.leftPos, this.topPos - 10, mouseX, mouseY);
            }
            if (++current <= this.currentPage + 1) continue;
            break;
        }
    }

    public void m_86600_() {
        super.m_86600_();
        this.pages.forEach(p -> p.tick());
    }

    private List<ResearchDiscipline> buildDisciplineList() {
        return ResearchDisciplines.getAllDisciplinesSorted();
    }

    private List<ResearchEntry> buildEntryList(ResearchDiscipline discipline) {
        return discipline.getEntries().stream().sorted(Comparator.comparing(e -> Component.m_237115_((String)e.getNameTranslationKey()).getString())).collect(Collectors.toList());
    }

    protected void parseIndexPages() {
        this.currentStageIndex = 0;
        List<ResearchDiscipline> disciplines = this.buildDisciplineList();
        if (disciplines.isEmpty()) {
            return;
        }
        int heightRemaining = 182;
        DisciplineIndexPage tempPage = new DisciplineIndexPage(true);
        for (ResearchDiscipline discipline : disciplines) {
            if (discipline.getKey().equals("SCANS") || discipline.getUnlockResearchKey() != null && !discipline.getUnlockResearchKey().isKnownByStrict((Player)Minecraft.m_91087_().f_91074_)) continue;
            tempPage.addDiscipline(discipline);
            if ((heightRemaining -= 12) >= 12 || tempPage.getDisciplines().isEmpty()) continue;
            heightRemaining = 210;
            this.pages.add(tempPage);
            tempPage = new DisciplineIndexPage();
        }
        if (!tempPage.getDisciplines().isEmpty()) {
            this.pages.add(tempPage);
        }
        this.pages.add(new OtherIndexPage());
    }

    protected void parseDisciplinePages(ResearchDiscipline discipline) {
        Minecraft mc = this.getMinecraft();
        this.currentStageIndex = 0;
        if (discipline == null) {
            return;
        }
        List<ResearchEntry> entries = this.buildEntryList(discipline);
        if (entries.isEmpty()) {
            return;
        }
        ArrayList<ResearchEntry> newList = new ArrayList<ResearchEntry>();
        ArrayList<ResearchEntry> updatedList = new ArrayList<ResearchEntry>();
        ArrayList<ResearchEntry> completeList = new ArrayList<ResearchEntry>();
        ArrayList<ResearchEntry> inProgressList = new ArrayList<ResearchEntry>();
        ArrayList<ResearchEntry> availableList = new ArrayList<ResearchEntry>();
        ArrayList<ResearchEntry> upcomingList = new ArrayList<ResearchEntry>();
        for (ResearchEntry entry : entries) {
            if (entry.isNew((Player)mc.f_91074_)) {
                newList.add(entry);
                continue;
            }
            if (entry.isUpdated((Player)mc.f_91074_)) {
                updatedList.add(entry);
                continue;
            }
            if (entry.isComplete((Player)mc.f_91074_)) {
                completeList.add(entry);
                continue;
            }
            if (entry.isInProgress((Player)mc.f_91074_)) {
                inProgressList.add(entry);
                continue;
            }
            if (!entry.isHidden() && entry.isAvailable((Player)mc.f_91074_)) {
                availableList.add(entry);
                continue;
            }
            if (entry.isHidden() || !entry.isUpcoming((Player)mc.f_91074_)) continue;
            upcomingList.add(entry);
        }
        DisciplinePageProperties properties = new DisciplinePageProperties();
        properties.heightRemaining = 137;
        properties.firstSection = true;
        properties.page = new DisciplinePage(discipline, true);
        if (!updatedList.isEmpty()) {
            this.parseDisciplinePageSection(updatedList, "updated", discipline, properties);
        }
        if (!newList.isEmpty()) {
            this.parseDisciplinePageSection(newList, "new", discipline, properties);
        }
        if (!inProgressList.isEmpty()) {
            this.parseDisciplinePageSection(inProgressList, "in_progress", discipline, properties);
        }
        if (!availableList.isEmpty()) {
            this.parseDisciplinePageSection(availableList, "available", discipline, properties);
        }
        if (!upcomingList.isEmpty()) {
            this.parseDisciplinePageSection(upcomingList, "upcoming", discipline, properties);
        }
        if (!completeList.isEmpty()) {
            this.parseDisciplinePageSection(completeList, "complete", discipline, properties);
        }
        if (!properties.page.getContents().isEmpty()) {
            this.pages.add(properties.page);
        }
    }

    protected void parseDisciplinePageSection(List<ResearchEntry> researchList, String headerName, ResearchDiscipline discipline, DisciplinePageProperties properties) {
        MutableComponent headerText = Component.m_237115_((String)("grimoire.primalmagick.section_header." + headerName)).m_130940_(ChatFormatting.UNDERLINE);
        if (properties.heightRemaining < 36 && !properties.page.getContents().isEmpty()) {
            properties.heightRemaining = 156;
            this.pages.add(properties.page);
            properties.page = new DisciplinePage(discipline);
            properties.page.addContent(headerText);
        } else {
            if (!properties.firstSection && !properties.page.getContents().isEmpty()) {
                properties.page.addContent(Component.m_237113_((String)""));
                properties.heightRemaining -= 12;
            }
            properties.page.addContent(headerText);
            properties.heightRemaining -= 12;
        }
        properties.firstSection = false;
        for (ResearchEntry entry : researchList) {
            properties.page.addContent(entry);
            properties.heightRemaining -= 12;
            if (properties.heightRemaining > 12 || properties.page.getContents().isEmpty()) continue;
            properties.heightRemaining = 156;
            this.pages.add(properties.page);
            properties.page = new DisciplinePage(discipline);
        }
    }

    private Tuple<List<String>, List<PageImage>> parseText(String rawText) {
        String[] imgSplit;
        rawText = rawText.replaceAll("<BR>", "~B\n\n");
        rawText = rawText.replaceAll("<LINE>", "~L");
        rawText = rawText.replaceAll("<PAGE>", "~P");
        ArrayList<PageImage> images = new ArrayList<PageImage>();
        for (String imgStr : imgSplit = rawText.split("<IMG>")) {
            int index = imgStr.indexOf("</IMG>");
            if (index < 0) continue;
            String cleanStr = imgStr.substring(0, index);
            PageImage newImage = PageImage.parse(cleanStr);
            if (newImage == null) {
                rawText = rawText.replaceFirst(cleanStr, "\n");
                continue;
            }
            images.add(newImage);
            rawText = rawText.replaceFirst(cleanStr, "~I");
        }
        rawText = rawText.replaceAll("<IMG>", "");
        rawText = rawText.replaceAll("</IMG>", "");
        ArrayList<String> firstPassText = new ArrayList<String>();
        String[] pageTokens = rawText.split("~P");
        for (int i = 0; i < pageTokens.length; ++i) {
            String[] lineTokens = pageTokens[i].split("~L");
            for (int j = 0; j < lineTokens.length; ++j) {
                String[] imgTokens = lineTokens[j].split("~I");
                for (int k = 0; k < imgTokens.length; ++k) {
                    firstPassText.add(imgTokens[k]);
                    if (k == imgTokens.length - 1) continue;
                    firstPassText.add("~I");
                }
                if (j == lineTokens.length - 1) continue;
                firstPassText.add("~L");
            }
            if (i == pageTokens.length - 1) continue;
            firstPassText.add("~P");
        }
        ArrayList parsedText = new ArrayList();
        for (String str : firstPassText) {
            parsedText.addAll(this.f_96547_.m_92865_().m_92414_(FormattedText.m_130775_((String)str), 124, Style.f_131099_));
        }
        return new Tuple(parsedText.stream().map(t -> t.getString()).collect(Collectors.toList()), images);
    }

    protected void parseEntryPages(ResearchEntry entry) {
        if (entry == null || entry.getStages().isEmpty()) {
            return;
        }
        boolean complete = false;
        this.currentStageIndex = this.knowledge.getResearchStage(entry.getKey());
        if (this.currentStageIndex >= entry.getStages().size()) {
            this.currentStageIndex = entry.getStages().size() - 1;
            complete = true;
        }
        if (this.currentStageIndex < 0) {
            this.currentStageIndex = 0;
        }
        ResearchStage stage = entry.getStages().get(this.currentStageIndex);
        List<Object> addenda = complete ? entry.getAddenda() : Collections.emptyList();
        Object rawText = Component.m_237115_((String)stage.getTextTranslationKey()).getString();
        int addendumCount = 0;
        for (ResearchAddendum researchAddendum : addenda) {
            if (researchAddendum.getRequiredResearch() == null || !researchAddendum.getRequiredResearch().isKnownByStrict((Player)this.getMinecraft().f_91074_)) continue;
            MutableComponent headerText = Component.m_237110_((String)"grimoire.primalmagick.addendum_header", (Object[])new Object[]{++addendumCount});
            MutableComponent addendumText = Component.m_237115_((String)researchAddendum.getTextTranslationKey());
            rawText = (String)rawText + "<PAGE>" + headerText.getString() + "<BR>" + addendumText.getString();
        }
        Objects.requireNonNull(this.f_96547_);
        int lineHeight = 9;
        Tuple<List<String>, List<PageImage>> tuple = this.parseText((String)rawText);
        List parsedText = (List)tuple.m_14418_();
        List images = (List)tuple.m_14419_();
        int heightRemaining = 137;
        StagePage tempPage = new StagePage(stage, true);
        ArrayList<PageImage> tempImages = new ArrayList<PageImage>();
        for (Object line : parsedText) {
            if (((String)line).contains("~I")) {
                if (!images.isEmpty()) {
                    tempImages.add((PageImage)images.remove(0));
                }
                line = "";
            }
            if (((String)line).contains("~L")) {
                tempImages.add(IMAGE_LINE);
                line = "";
            }
            if (((String)line).contains("~P")) {
                this.pages.add(tempPage);
                tempPage = new StagePage(stage);
                heightRemaining = 165;
                line = "";
            }
            if (!((String)line).isEmpty()) {
                line = ((String)line).trim();
                tempPage.addElement(new PageString((String)line));
                heightRemaining -= lineHeight;
                if (((String)line).endsWith("~B")) {
                    heightRemaining -= (int)((double)lineHeight * 0.66);
                }
            }
            while (!tempImages.isEmpty() && heightRemaining >= ((PageImage)tempImages.get((int)0)).adjustedHeight + 2) {
                heightRemaining -= ((PageImage)tempImages.get((int)0)).adjustedHeight + 2;
                tempPage.addElement((IPageElement)tempImages.remove(0));
            }
            if (heightRemaining >= lineHeight || tempPage.getElements().isEmpty()) continue;
            heightRemaining = 165;
            this.pages.add(tempPage);
            tempPage = new StagePage(stage);
        }
        if (!tempPage.getElements().isEmpty()) {
            this.pages.add(tempPage);
        }
        tempPage = new StagePage(stage);
        heightRemaining = 165;
        while (!tempImages.isEmpty()) {
            if (heightRemaining < ((PageImage)tempImages.get((int)0)).adjustedHeight + 2) {
                heightRemaining = 165;
                this.pages.add(tempPage);
                tempPage = new StagePage(stage);
                continue;
            }
            heightRemaining -= ((PageImage)tempImages.get((int)0)).adjustedHeight + 2;
            tempPage.addElement((IPageElement)tempImages.remove(0));
        }
        if (!tempPage.getElements().isEmpty()) {
            this.pages.add(tempPage);
        }
        SourceList attunements = stage.getAttunements();
        for (ResearchAddendum researchAddendum : addenda) {
            if (researchAddendum.getRequiredResearch() != null && !researchAddendum.getRequiredResearch().isKnownByStrict((Player)this.getMinecraft().f_91074_)) continue;
            attunements = attunements.merge(researchAddendum.getAttunements());
        }
        if (!attunements.isEmpty()) {
            this.pages.add(new AttunementGainPage(attunements));
        }
        if (!entry.getKey().isKnownByStrict((Player)this.f_96541_.f_91074_) && stage.hasPrerequisites()) {
            this.pages.add(new RequirementsPage(stage));
        }
        ArrayList<ResourceLocation> locList = new ArrayList<ResourceLocation>();
        for (ResourceLocation resourceLocation : stage.getRecipes()) {
            if (locList.contains(resourceLocation)) continue;
            locList.add(resourceLocation);
        }
        for (ResearchAddendum researchAddendum : addenda) {
            if (researchAddendum.getRequiredResearch() != null && !researchAddendum.getRequiredResearch().isKnownByStrict((Player)this.getMinecraft().f_91074_)) continue;
            for (ResourceLocation loc : researchAddendum.getRecipes()) {
                if (locList.contains(loc)) continue;
                locList.add(loc);
            }
        }
        for (ResourceLocation resourceLocation : locList) {
            Optional opt = this.f_96541_.f_91073_.m_7465_().m_44043_(resourceLocation);
            if (opt.isPresent()) {
                AbstractRecipePage page = RecipePageFactory.createPage((Recipe)opt.get(), this.f_96541_.f_91073_.m_9598_());
                if (page == null) continue;
                this.pages.add(page);
                continue;
            }
            LOGGER.warn("Unable to find recipe definition for {}", (Object)resourceLocation.toString());
        }
    }

    protected void parseStatsPages() {
        this.currentStageIndex = 0;
        List<Stat> stats = StatsManager.getDisplayStats();
        if (stats.isEmpty()) {
            return;
        }
        int heightRemaining = 137;
        int dotWidth = this.f_96547_.m_92895_(".");
        StatisticsPage tempPage = new StatisticsPage(true);
        Minecraft mc = this.getMinecraft();
        for (Stat stat : stats) {
            String statFormattedValueStr;
            int statFormattedValueStrWidth;
            int statValue = StatsManager.getValue((Player)mc.f_91074_, stat);
            if (stat.isHidden() && statValue <= 0) continue;
            MutableComponent statText = Component.m_237115_((String)stat.getTranslationKey());
            ArrayList<FormattedText> statTextSegments = new ArrayList<FormattedText>(this.f_96547_.m_92865_().m_92414_((FormattedText)statText, 124, Style.f_131099_));
            FormattedText lastStatTextSegment = (FormattedText)statTextSegments.get(statTextSegments.size() - 1);
            int lastStatTextSegmentWidth = this.f_96547_.m_92852_(lastStatTextSegment);
            int remainingWidth = 124 - lastStatTextSegmentWidth - (statFormattedValueStrWidth = this.f_96547_.m_92895_(statFormattedValueStr = stat.getFormatter().m_12886_(statValue)));
            if (remainingWidth < 10) {
                String joiner1 = String.join((CharSequence)"", Collections.nCopies((124 - lastStatTextSegmentWidth) / dotWidth, "."));
                String joiner2 = String.join((CharSequence)"", Collections.nCopies((124 - statFormattedValueStrWidth) / dotWidth, "."));
                statTextSegments.set(statTextSegments.size() - 1, FormattedText.m_130775_((String)(lastStatTextSegment.getString() + joiner1)));
                statTextSegments.add(FormattedText.m_130775_((String)(joiner2 + statFormattedValueStr + "~B")));
            } else {
                String joiner = String.join((CharSequence)"", Collections.nCopies(remainingWidth / dotWidth, "."));
                statTextSegments.set(statTextSegments.size() - 1, FormattedText.m_130775_((String)(lastStatTextSegment.getString() + joiner + statFormattedValueStr + "~B")));
            }
            Objects.requireNonNull(this.f_96547_);
            int totalHeight = 9 * statTextSegments.size();
            if (heightRemaining < totalHeight && !tempPage.getElements().isEmpty()) {
                heightRemaining = 165;
                this.pages.add(tempPage);
                tempPage = new StatisticsPage();
            }
            for (FormattedText str : statTextSegments) {
                tempPage.addElement(new PageString(str.getString()));
                Objects.requireNonNull(this.f_96547_);
                heightRemaining -= 9;
            }
            Objects.requireNonNull(this.f_96547_);
            heightRemaining -= (int)(9.0 * 0.66);
        }
        if (!tempPage.getElements().isEmpty()) {
            this.pages.add(tempPage);
        }
    }

    protected void parseAttunementIndexPages() {
        this.currentStageIndex = 0;
        this.pages.add(new AttunementIndexPage(true));
    }

    protected void parseAttunementPage(Source source) {
        this.currentStageIndex = 0;
        this.pages.add(new AttunementPage(source, true));
        String rawText = Component.m_237115_((String)("source.primalmagick." + source.getTag() + ".attunement.text")).getString();
        Objects.requireNonNull(this.f_96547_);
        int lineHeight = 9;
        Tuple<List<String>, List<PageImage>> parsedData = this.parseText(rawText);
        List parsedText = (List)parsedData.m_14418_();
        List images = (List)parsedData.m_14419_();
        int heightRemaining = 165;
        AttunementPage tempPage = new AttunementPage(source);
        ArrayList<PageImage> tempImages = new ArrayList<PageImage>();
        for (String line : parsedText) {
            if (line.contains("~I")) {
                if (!images.isEmpty()) {
                    tempImages.add((PageImage)images.remove(0));
                }
                line = "";
            }
            if (line.contains("~L")) {
                tempImages.add(IMAGE_LINE);
                line = "";
            }
            if (line.contains("~P")) {
                this.pages.add(tempPage);
                tempPage = new AttunementPage(source);
                heightRemaining = 165;
                line = "";
            }
            if (!line.isEmpty()) {
                line = line.trim();
                tempPage.addElement(new PageString(line));
                heightRemaining -= lineHeight;
                if (line.endsWith("~B")) {
                    heightRemaining -= (int)((double)lineHeight * 0.66);
                }
            }
            while (!tempImages.isEmpty() && heightRemaining >= ((PageImage)tempImages.get((int)0)).adjustedHeight + 2) {
                heightRemaining -= ((PageImage)tempImages.get((int)0)).adjustedHeight + 2;
                tempPage.addElement((IPageElement)tempImages.remove(0));
            }
            if (heightRemaining >= lineHeight || tempPage.getElements().isEmpty()) continue;
            heightRemaining = 165;
            this.pages.add(tempPage);
            tempPage = new AttunementPage(source);
        }
        if (!tempPage.getElements().isEmpty()) {
            this.pages.add(tempPage);
        }
        tempPage = new AttunementPage(source);
        heightRemaining = 165;
        while (!tempImages.isEmpty()) {
            if (heightRemaining < ((PageImage)tempImages.get((int)0)).adjustedHeight + 2) {
                heightRemaining = 165;
                this.pages.add(tempPage);
                tempPage = new AttunementPage(source);
                continue;
            }
            heightRemaining -= ((PageImage)tempImages.get((int)0)).adjustedHeight + 2;
            tempPage.addElement((IPageElement)tempImages.remove(0));
        }
        if (!tempPage.getElements().isEmpty()) {
            this.pages.add(tempPage);
        }
    }

    protected void parseRuneEnchantmentPage(Enchantment enchant) {
        Minecraft mc = Minecraft.m_91087_();
        ResourceLocation enchantKey = ForgeRegistries.ENCHANTMENTS.getKey((Object)enchant);
        String rawText = ResearchManager.isResearchComplete((Player)mc.f_91074_, SimpleResearchKey.parseRuneEnchantment(enchant)) ? Component.m_237115_((String)String.join((CharSequence)".", "enchantment", enchantKey.m_135827_(), enchantKey.m_135815_(), "rune_enchantment", "text")).getString() : Component.m_237115_((String)String.join((CharSequence)".", "enchantment", enchantKey.m_135827_(), enchantKey.m_135815_(), "rune_enchantment", "partial_text")).getString();
        Objects.requireNonNull(this.f_96547_);
        int lineHeight = 9;
        Tuple<List<String>, List<PageImage>> parsedData = this.parseText(rawText);
        List parsedText = (List)parsedData.m_14418_();
        List images = (List)parsedData.m_14419_();
        int heightRemaining = 113;
        RuneEnchantmentPage tempPage = new RuneEnchantmentPage(enchant, true);
        ArrayList<PageImage> tempImages = new ArrayList<PageImage>();
        for (String line : parsedText) {
            if (line.contains("~I")) {
                if (!images.isEmpty()) {
                    tempImages.add((PageImage)images.remove(0));
                }
                line = "";
            }
            if (line.contains("~L")) {
                tempImages.add(IMAGE_LINE);
                line = "";
            }
            if (line.contains("~P")) {
                this.pages.add(tempPage);
                tempPage = new RuneEnchantmentPage(enchant);
                heightRemaining = 165;
                line = "";
            }
            if (!line.isEmpty()) {
                line = line.trim();
                tempPage.addElement(new PageString(line));
                heightRemaining -= lineHeight;
                if (line.endsWith("~B")) {
                    heightRemaining -= (int)((double)lineHeight * 0.66);
                }
            }
            while (!tempImages.isEmpty() && heightRemaining >= ((PageImage)tempImages.get((int)0)).adjustedHeight + 2) {
                heightRemaining -= ((PageImage)tempImages.get((int)0)).adjustedHeight + 2;
                tempPage.addElement((IPageElement)tempImages.remove(0));
            }
            if (heightRemaining >= lineHeight || tempPage.getElements().isEmpty()) continue;
            heightRemaining = 165;
            this.pages.add(tempPage);
            tempPage = new RuneEnchantmentPage(enchant);
        }
        if (!tempPage.getElements().isEmpty()) {
            this.pages.add(tempPage);
        }
        tempPage = new RuneEnchantmentPage(enchant);
        heightRemaining = 165;
        while (!tempImages.isEmpty()) {
            if (heightRemaining < ((PageImage)tempImages.get((int)0)).adjustedHeight + 2) {
                heightRemaining = 165;
                this.pages.add(tempPage);
                tempPage = new RuneEnchantmentPage(enchant);
                continue;
            }
            heightRemaining -= ((PageImage)tempImages.get((int)0)).adjustedHeight + 2;
            tempPage.addElement((IPageElement)tempImages.remove(0));
        }
        if (!tempPage.getElements().isEmpty()) {
            this.pages.add(tempPage);
        }
    }

    protected void parseRuneEnchantmentIndexPages() {
        this.currentStageIndex = 0;
        int heightRemaining = 137;
        RuneEnchantmentIndexPage tempPage = new RuneEnchantmentIndexPage(true);
        Minecraft mc = Minecraft.m_91087_();
        for (Enchantment enchant : RuneManager.getRuneEnchantmentsSorted()) {
            List<SimpleResearchKey> researchKeys = List.of(SimpleResearchKey.parseRuneEnchantment(enchant), SimpleResearchKey.parsePartialRuneEnchantment(enchant, RuneType.VERB), SimpleResearchKey.parsePartialRuneEnchantment(enchant, RuneType.NOUN), SimpleResearchKey.parsePartialRuneEnchantment(enchant, RuneType.SOURCE));
            if (!researchKeys.stream().anyMatch(key -> ResearchManager.isResearchComplete((Player)mc.f_91074_, key))) continue;
            tempPage.addEnchantment(enchant);
            if ((heightRemaining -= 12) >= 12 || tempPage.getEnchantments().isEmpty()) continue;
            heightRemaining = 156;
            this.pages.add(tempPage);
            tempPage = new RuneEnchantmentIndexPage();
        }
        if (!tempPage.getEnchantments().isEmpty()) {
            this.pages.add(tempPage);
        }
    }

    protected void generateIndexMap() {
        Minecraft mc = this.getMinecraft();
        Comparator<Recipe> displayNameComparator = Comparator.comparing(r -> r.m_8043_(mc.f_91073_.m_9598_()).m_41786_().getString());
        Comparator<Recipe> recipeIdComparator = Comparator.comparing(r -> r.m_6423_());
        List processedRecipes = mc.f_91073_.m_7465_().m_44051_().stream().filter(GrimoireScreen::isValidRecipeIndexEntry).sorted(displayNameComparator.thenComparing(recipeIdComparator)).collect(Collectors.toList());
        this.indexMap = new TreeMap();
        for (Recipe recipe : processedRecipes) {
            String recipeName = recipe.m_8043_(mc.f_91073_.m_9598_()).m_41786_().getString();
            if (!this.indexMap.containsKey(recipeName)) {
                this.indexMap.put(recipeName, new ArrayList());
            }
            ((List)this.indexMap.get(recipeName)).add(recipe);
        }
    }

    public boolean isIndexKey(String name) {
        return this.indexMap.containsKey(name);
    }

    public void checkRecipeSearchStringUpdate(String newString) {
        if (!newString.equals(this.lastRecipeSearch.orElse(""))) {
            this.lastRecipeSearch = Optional.ofNullable(newString);
            this.initPages();
            this.initButtons();
        }
    }

    protected void parseRecipeIndexPages() {
        this.currentStageIndex = 0;
        Minecraft mc = this.getMinecraft();
        int heightRemaining = 113;
        RecipeIndexPage tempPage = new RecipeIndexPage(true, this.lastRecipeSearch);
        for (String recipeName : this.indexMap.navigableKeySet()) {
            if (!recipeName.toLowerCase(Locale.ROOT).contains(this.lastRecipeSearch.orElse("").toLowerCase(Locale.ROOT))) continue;
            tempPage.addContent(recipeName, ((Recipe)((List)this.indexMap.get(recipeName)).get(0)).m_8043_(mc.f_91073_.m_9598_()));
            if ((heightRemaining -= 12) >= 12 || tempPage.getContents().isEmpty()) continue;
            heightRemaining = 156;
            this.pages.add(tempPage);
            tempPage = new RecipeIndexPage();
        }
        if (!tempPage.getContents().isEmpty() || tempPage.getContents().isEmpty() && tempPage.isFirstPage()) {
            this.pages.add(tempPage);
        }
        if (this.pages.isEmpty()) {
            LOGGER.warn("Finished parsing recipe index pages without adding any!");
        }
    }

    protected static boolean isValidRecipeIndexEntry(Recipe<?> recipe) {
        Minecraft mc = Minecraft.m_91087_();
        if (!recipe.m_6423_().m_135827_().equals("primalmagick") || RecipePageFactory.createPage(recipe, mc.f_91073_.m_9598_()) == null) {
            return false;
        }
        if (recipe instanceof IHasRequiredResearch) {
            IHasRequiredResearch hrr = (IHasRequiredResearch)recipe;
            CompoundResearchKey parents = hrr.getRequiredResearch();
            return parents == null || parents.isKnownByStrict((Player)mc.f_91074_);
        }
        return ResearchManager.isRecipeVisible(recipe.m_6423_(), (Player)mc.f_91074_);
    }

    protected void parseRecipeEntryPages(String recipeName) {
        Minecraft mc = Minecraft.m_91087_();
        this.currentStageIndex = 0;
        boolean firstPage = true;
        List recipes = this.indexMap.getOrDefault(recipeName, Collections.emptyList());
        for (Recipe recipe : recipes) {
            AbstractRecipePage page = RecipePageFactory.createPage(recipe, mc.f_91073_.m_9598_());
            if (page == null) continue;
            this.pages.add(new RecipeMetadataPage(recipe, mc.f_91073_.m_9598_(), firstPage));
            this.pages.add(page);
            firstPage = false;
        }
    }

    protected Component getCurrentTip() {
        if (this.cachedTip == null) {
            Minecraft mc = Minecraft.m_91087_();
            this.cachedTip = TipManager.getRandomTipForPlayer((Player)mc.f_91074_, mc.f_91074_.m_217043_()).getText();
        }
        return this.cachedTip;
    }

    public void invalidateCurrentTip() {
        this.cachedTip = null;
    }

    protected void parseTipsPages() {
        TipsPage lastPage;
        int contentHeight;
        String rawText = StringDecomposer.m_14326_((FormattedText)this.getCurrentTip());
        Objects.requireNonNull(this.f_96547_);
        int lineHeight = 9;
        Tuple<List<String>, List<PageImage>> parsedData = this.parseText(rawText);
        List parsedText = (List)parsedData.m_14418_();
        List images = (List)parsedData.m_14419_();
        int heightRemaining = 137;
        TipsPage tempPage = new TipsPage(true);
        ArrayList<PageImage> tempImages = new ArrayList<PageImage>();
        for (String line : parsedText) {
            if (line.contains("~I")) {
                if (!images.isEmpty()) {
                    tempImages.add((PageImage)images.remove(0));
                }
                line = "";
            }
            if (line.contains("~L")) {
                tempImages.add(IMAGE_LINE);
                line = "";
            }
            if (line.contains("~P")) {
                this.pages.add(tempPage);
                tempPage = new TipsPage();
                heightRemaining = 165;
                line = "";
            }
            if (!line.isEmpty()) {
                line = line.trim();
                tempPage.addElement(new PageString(line));
                heightRemaining -= lineHeight;
                if (line.endsWith("~B")) {
                    heightRemaining -= (int)((double)lineHeight * 0.66);
                }
            }
            while (!tempImages.isEmpty() && heightRemaining >= ((PageImage)tempImages.get((int)0)).adjustedHeight + 2) {
                heightRemaining -= ((PageImage)tempImages.get((int)0)).adjustedHeight + 2;
                tempPage.addElement((IPageElement)tempImages.remove(0));
            }
            if (heightRemaining >= lineHeight || tempPage.getElements().isEmpty()) continue;
            heightRemaining = 165;
            this.pages.add(tempPage);
            tempPage = new TipsPage();
        }
        if (!tempPage.getElements().isEmpty()) {
            this.pages.add(tempPage);
        }
        tempPage = new TipsPage();
        heightRemaining = 165;
        while (!tempImages.isEmpty()) {
            if (heightRemaining < ((PageImage)tempImages.get((int)0)).adjustedHeight + 2) {
                heightRemaining = 165;
                this.pages.add(tempPage);
                tempPage = new TipsPage();
                continue;
            }
            heightRemaining -= ((PageImage)tempImages.get((int)0)).adjustedHeight + 2;
            tempPage.addElement((IPageElement)tempImages.remove(0));
        }
        if (!tempPage.getElements().isEmpty()) {
            this.pages.add(tempPage);
        }
        if ((contentHeight = (lastPage = (TipsPage)this.pages.get(this.pages.size() - 1)).getElements().stream().mapToInt(IPageElement::getHeight).sum()) > (lastPage.isFirstPage() ? 112 : 140)) {
            lastPage = new TipsPage();
            this.pages.add(lastPage);
        }
        lastPage.setLastPage(true);
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(int newPage) {
        this.currentPage = newPage;
        this.lastStageIndex = this.currentStageIndex;
    }

    public boolean nextPage() {
        if (this.currentPage < this.pages.size() - 2) {
            this.currentPage += 2;
            this.initButtons();
            return true;
        }
        return false;
    }

    public boolean prevPage() {
        if (this.currentPage >= 2) {
            this.currentPage -= 2;
            this.initButtons();
            return true;
        }
        return false;
    }

    public boolean goBack() {
        if (!this.knowledge.getResearchTopicHistory().isEmpty()) {
            AbstractResearchTopic lastTopic = this.knowledge.getResearchTopicHistory().pop();
            this.knowledge.setLastResearchTopic(lastTopic);
            this.getMinecraft().m_91152_((Screen)new GrimoireScreen());
            return true;
        }
        return false;
    }

    public void gotoTopic(AbstractResearchTopic newTopic) {
        this.gotoTopic(newTopic, true);
    }

    public void gotoTopic(AbstractResearchTopic newTopic, boolean allowRepeatInHistory) {
        if (allowRepeatInHistory || !this.knowledge.getLastResearchTopic().equals(newTopic)) {
            this.pushCurrentHistoryTopic();
        }
        this.setTopic(newTopic);
        this.getMinecraft().m_91152_((Screen)new GrimoireScreen());
    }

    protected void updateNavButtonVisibility() {
        this.prevPageButton.f_93624_ = this.currentPage >= 2;
        this.nextPageButton.f_93624_ = this.currentPage < this.pages.size() - 2;
        this.backButton.f_93624_ = !this.knowledge.getResearchTopicHistory().isEmpty();
    }

    public boolean m_5534_(char pCodePoint, int pModifiers) {
        for (AbstractPage page : this.pages) {
            if (!page.m_5534_(pCodePoint, pModifiers)) continue;
            return true;
        }
        return super.m_5534_(pCodePoint, pModifiers);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        for (AbstractPage page : this.pages) {
            if (!page.m_7933_(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        if (keyCode == KeyBindings.GRIMOIRE_PREV_TOPIC.getKey().m_84873_()) {
            if (this.goBack()) {
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)((SoundEvent)SoundsPM.PAGE.get()), (float)1.0f, (float)1.0f));
                return true;
            }
        } else if (keyCode == KeyBindings.GRIMOIRE_PREV_PAGE.getKey().m_84873_()) {
            if (this.prevPage()) {
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)((SoundEvent)SoundsPM.PAGE.get()), (float)1.0f, (float)1.0f));
                return true;
            }
        } else if (keyCode == KeyBindings.GRIMOIRE_NEXT_PAGE.getKey().m_84873_() && this.nextPage()) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)((SoundEvent)SoundsPM.PAGE.get()), (float)1.0f, (float)1.0f));
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_6375_(double xPos, double yPos, int keyCode) {
        boolean retVal = super.m_6375_(xPos, yPos, keyCode);
        if (keyCode == 1) {
            if (this.goBack()) {
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)((SoundEvent)SoundsPM.PAGE.get()), (float)1.0f, (float)1.0f));
            }
        } else {
            for (AbstractPage page : this.pages) {
                if (!page.m_6375_(xPos, yPos, keyCode)) continue;
                this.m_7522_(page);
                return true;
            }
            this.m_7522_(null);
        }
        return retVal;
    }

    public void pushCurrentHistoryTopic() {
        this.knowledge.getResearchTopicHistory().push(this.knowledge.getLastResearchTopic().withPage(this.getCurrentPage()));
    }

    public void setTopic(AbstractResearchTopic newTopic) {
        this.knowledge.setLastResearchTopic(newTopic);
    }

    public List<AbstractResearchTopic> getHistoryView() {
        return this.knowledge.getResearchTopicHistory().subList(0, Math.min(this.knowledge.getResearchTopicHistory().size(), 64));
    }

    protected static class DisciplinePageProperties {
        public DisciplinePage page;
        public int heightRemaining;
        public boolean firstSection;

        protected DisciplinePageProperties() {
        }
    }
}

