/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui;

import com.verdantartifice.primalmagick.PrimalMagick;
import com.verdantartifice.primalmagick.client.gui.widgets.ManaGaugeWidget;
import com.verdantartifice.primalmagick.common.menus.ManaBatteryMenu;
import com.verdantartifice.primalmagick.common.sources.Source;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class ManaBatteryScreen
extends AbstractContainerScreen<ManaBatteryMenu> {
    protected static final ResourceLocation TEXTURE = PrimalMagick.resource("textures/gui/mana_battery.png");
    protected static final int AVAILABLE_GAUGE_WIDTH = 116;
    protected static final int GAUGE_START_X = 57;
    protected static final int GAUGE_WIDTH = 12;
    protected final Map<Source, ManaGaugeWidget> manaGauges = new HashMap<Source, ManaGaugeWidget>();

    public ManaBatteryScreen(ManaBatteryMenu screenMenu, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenMenu, inv, titleIn);
        this.f_97726_ = 230;
        this.f_97727_ = 164;
        this.f_97730_ = 34;
    }

    protected void m_7856_() {
        super.m_7856_();
        Minecraft mc = Minecraft.m_91087_();
        List<Source> knownSources = Source.SORTED_SOURCES.stream().filter(s -> s.isDiscovered((Player)mc.f_91074_)).toList();
        int gapWidth = (116 - 12 * knownSources.size()) / (knownSources.size() - 1);
        int bonusEdge = 116 - 12 * knownSources.size() - gapWidth * (knownSources.size() - 1);
        int xOffset = 57 + bonusEdge / 2;
        for (Source source : knownSources) {
            this.manaGauges.put(source, (ManaGaugeWidget)this.m_142416_((GuiEventListener)new ManaGaugeWidget(this.f_97735_ + xOffset, this.f_97736_ + 16, source, ((ManaBatteryMenu)this.f_97732_).getCurrentMana(source), ((ManaBatteryMenu)this.f_97732_).getMaxMana(source))));
            xOffset += 12 + gapWidth;
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.manaGauges.forEach((source, gauge) -> {
            gauge.setCurrentMana(((ManaBatteryMenu)this.f_97732_).getCurrentMana((Source)source));
            gauge.setMaxMana(((ManaBatteryMenu)this.f_97732_).getMaxMana((Source)source));
        });
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        guiGraphics.m_280218_(TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        int charge = ((ManaBatteryMenu)this.f_97732_).getChargeProgressionScaled();
        guiGraphics.m_280218_(TEXTURE, this.f_97735_ + 29, this.f_97736_ + 34, 230, 0, charge + 1, 16);
    }
}

