/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui;

import com.verdantartifice.primalmagick.PrimalMagick;
import com.verdantartifice.primalmagick.client.gui.widgets.InactiveWidget;
import com.verdantartifice.primalmagick.client.gui.widgets.research_table.AidListWidget;
import com.verdantartifice.primalmagick.client.gui.widgets.research_table.AidUnlockWidget;
import com.verdantartifice.primalmagick.client.gui.widgets.research_table.KnowledgeTotalWidget;
import com.verdantartifice.primalmagick.client.gui.widgets.research_table.OtherRewardWidget;
import com.verdantartifice.primalmagick.client.gui.widgets.research_table.ProjectMaterialSelectionCheckbox;
import com.verdantartifice.primalmagick.client.gui.widgets.research_table.ProjectMaterialWidgetFactory;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerKnowledge;
import com.verdantartifice.primalmagick.common.capabilities.PrimalMagickCapabilities;
import com.verdantartifice.primalmagick.common.menus.ResearchTableMenu;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.theorycrafting.CompleteProjectPacket;
import com.verdantartifice.primalmagick.common.network.packets.theorycrafting.SetProjectMaterialSelectionPacket;
import com.verdantartifice.primalmagick.common.network.packets.theorycrafting.StartProjectPacket;
import com.verdantartifice.primalmagick.common.research.KnowledgeType;
import com.verdantartifice.primalmagick.common.theorycrafting.AbstractProjectMaterial;
import com.verdantartifice.primalmagick.common.theorycrafting.Project;
import com.verdantartifice.primalmagick.common.theorycrafting.TheorycraftManager;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.Block;

public class ResearchTableScreen
extends AbstractContainerScreen<ResearchTableMenu> {
    private static final ResourceLocation TEXTURE = PrimalMagick.resource("textures/gui/research_table.png");
    private static final ResourceLocation OVERLAY = PrimalMagick.resource("textures/gui/research_table_overlay.png");
    private static final DecimalFormat FORMATTER = new DecimalFormat("###.#");
    protected long lastCheck = 0L;
    protected boolean progressing = false;
    protected boolean writingReady = false;
    protected boolean lastWritingReady = false;
    protected IPlayerKnowledge knowledge;
    protected Project project = null;
    protected Project lastProject = null;
    protected Button completeProjectButton = null;

    public ResearchTableScreen(ResearchTableMenu screenMenu, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenMenu, inv, titleIn);
        this.f_97726_ = 230;
        this.f_97727_ = 222;
    }

    protected void m_7856_() {
        super.m_7856_();
        Minecraft mc = this.getMinecraft();
        this.knowledge = (IPlayerKnowledge)PrimalMagickCapabilities.getKnowledge((Player)mc.f_91074_).orElseThrow(() -> new IllegalStateException("No knowledge provider found for player"));
        this.project = this.knowledge.getActiveResearchProject();
        this.lastWritingReady = this.writingReady = ((ResearchTableMenu)this.f_97732_).isWritingReady();
        this.initButtons();
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        long millis = System.currentTimeMillis();
        this.lastWritingReady = this.writingReady;
        this.writingReady = ((ResearchTableMenu)this.f_97732_).isWritingReady();
        if (millis > this.lastCheck || this.lastWritingReady != this.writingReady) {
            this.lastCheck = this.progressing ? millis + 250L : millis + 2000L;
            this.lastProject = this.project;
            this.project = this.knowledge.getActiveResearchProject();
            if (this.lastProject != this.project) {
                this.progressing = false;
            }
            this.initButtons();
        }
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Minecraft mc = Minecraft.m_91087_();
        if (this.isProjectReady()) {
            int y = 11;
            MutableComponent titleText = Component.m_237115_((String)this.project.getNameTranslationKey()).m_130940_(ChatFormatting.BOLD);
            int titleWidth = mc.f_91062_.m_92852_((FormattedText)titleText);
            guiGraphics.m_280614_(mc.f_91062_, (Component)titleText, 34 + (162 - titleWidth) / 2, y, Color.BLACK.getRGB(), false);
            Objects.requireNonNull(mc.f_91062_);
            y += (int)(9.0 * 1.66);
            MutableComponent descText = Component.m_237115_((String)this.project.getTextTranslationKey());
            List descLines = mc.f_91062_.m_92865_().m_92414_((FormattedText)descText, 154, Style.f_131099_);
            for (FormattedText line : descLines) {
                guiGraphics.m_280056_(mc.f_91062_, line.getString(), 38, y, Color.BLACK.getRGB(), false);
                Objects.requireNonNull(mc.f_91062_);
                y += 9;
            }
        } else if (!((ResearchTableMenu)this.f_97732_).isWritingReady()) {
            MutableComponent text = Component.m_237115_((String)"label.primalmagick.research_table.missing_writing_supplies");
            int width = mc.f_91062_.m_92895_(text.getString());
            Font font = mc.f_91062_;
            int n = 34 + (162 - width) / 2;
            Objects.requireNonNull(mc.f_91062_);
            guiGraphics.m_280614_(font, (Component)text, n, 7 + (128 - 9) / 2, Color.BLACK.getRGB(), false);
        } else {
            MutableComponent text = Component.m_237115_((String)"label.primalmagick.research_table.ready");
            int width = mc.f_91062_.m_92895_(text.getString());
            Font font = mc.f_91062_;
            int n = 34 + (162 - width) / 2;
            Objects.requireNonNull(mc.f_91062_);
            guiGraphics.m_280614_(font, (Component)text, n, 7 + (128 - 9) / 2, Color.BLACK.getRGB(), false);
        }
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        guiGraphics.m_280218_(TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        if (this.isProjectReady()) {
            guiGraphics.m_280218_(OVERLAY, this.f_97735_ + 34, this.f_97736_ + 7, 0, 0, 162, 128);
        }
    }

    protected boolean isProjectReady() {
        return this.project != null && ((ResearchTableMenu)this.f_97732_).isWritingReady();
    }

    public void setProgressing() {
        this.progressing = true;
        this.lastCheck = 0L;
    }

    public void setMaterialSelection(int index, boolean selected) {
        if (this.project != null && index >= 0 && index < this.project.getMaterials().size()) {
            this.project.getMaterials().get(index).setSelected(selected);
            PacketHandler.sendToServer(new SetProjectMaterialSelectionPacket(index, selected));
            this.lastCheck = 0L;
        }
    }

    protected void initButtons() {
        this.m_169413_();
        this.completeProjectButton = null;
        if (this.project == null && ((ResearchTableMenu)this.f_97732_).isWritingReady()) {
            this.m_142416_((GuiEventListener)new KnowledgeTotalWidget(this.f_97735_ + 203, this.f_97736_ + 116, KnowledgeType.THEORY));
            if (this.progressing) {
                MutableComponent text = Component.m_237115_((String)"label.primalmagick.research_table.starting");
                this.m_142416_((GuiEventListener)new InactiveWidget(this.f_97735_ + 38, this.f_97736_ + 111, 154, 20, (Component)text));
            } else {
                MutableComponent text = Component.m_237115_((String)"label.primalmagick.research_table.start");
                this.m_142416_((GuiEventListener)new StartProjectButton(this.f_97735_ + 38, this.f_97736_ + 111, (Component)text, this));
            }
        } else if (this.isProjectReady()) {
            this.m_142416_((GuiEventListener)new KnowledgeTotalWidget(this.f_97735_ + 203, this.f_97736_ + 116, KnowledgeType.THEORY, OptionalInt.of(this.project.getTheoryPointReward())));
            if (!this.project.getOtherRewards().isEmpty()) {
                this.m_142416_((GuiEventListener)new OtherRewardWidget(this.project.getOtherRewards(), this.f_97735_ + 203, this.f_97736_ + 97));
            }
            if (this.progressing) {
                MutableComponent text = Component.m_237115_((String)"label.primalmagick.research_table.completing");
                this.m_142416_((GuiEventListener)new InactiveWidget(this.f_97735_ + 38, this.f_97736_ + 111, 154, 20, (Component)text));
            } else {
                ((ResearchTableMenu)this.f_97732_).getContainerLevelAccess().m_39292_((level, tablePos) -> {
                    AbstractProjectMaterial material;
                    LocalPlayer player = this.f_96541_.f_91074_;
                    double chance = 100.0 * this.project.getSuccessChance();
                    Set<Block> surroundings = TheorycraftManager.getSurroundings(level, tablePos);
                    MutableComponent text = Component.m_237110_((String)"label.primalmagick.research_table.complete", (Object[])new Object[]{FORMATTER.format(chance)});
                    this.completeProjectButton = (Button)this.m_142416_((GuiEventListener)new CompleteProjectButton(this.f_97735_ + 38, this.f_97736_ + 111, (Component)text, this));
                    this.completeProjectButton.f_93623_ = this.project.isSatisfied((Player)player, surroundings);
                    List<Component> aidNames = ((ResearchTableMenu)this.f_97732_).getNearbyAidBlockNames();
                    if (!aidNames.isEmpty()) {
                        this.m_142416_((GuiEventListener)new AidListWidget(this.f_97735_ + 36, this.f_97736_ + 9, aidNames));
                    }
                    if (this.project.getAidBlock() != null) {
                        this.m_142416_((GuiEventListener)new AidUnlockWidget(this.f_97735_ + 186, this.f_97736_ + 9, this.project.getAidBlock()));
                    }
                    int materialCount = this.project.getMaterials().size();
                    int startX = (152 - 38 * materialCount) / 2;
                    int index = 0;
                    int x = startX;
                    while (index < materialCount) {
                        material = this.project.getMaterials().get(index);
                        this.m_142416_((GuiEventListener)new ProjectMaterialSelectionCheckbox(this.f_97735_ + 42 + x, this.f_97736_ + 93, this, material.isSelected(), index));
                        ++index;
                        x += 38;
                    }
                    index = 0;
                    x = startX;
                    while (index < materialCount) {
                        material = this.project.getMaterials().get(index);
                        this.m_142416_((GuiEventListener)ProjectMaterialWidgetFactory.create(material, this.f_97735_ + 58 + x, this.f_97736_ + 93, surroundings));
                        ++index;
                        x += 38;
                    }
                });
            }
        }
        this.m_142416_((GuiEventListener)new KnowledgeTotalWidget(this.f_97735_ + 11, this.f_97736_ + 116, KnowledgeType.OBSERVATION));
    }

    protected static class StartProjectButton
    extends Button {
        protected ResearchTableScreen screen;

        public StartProjectButton(int xIn, int yIn, Component text, ResearchTableScreen screen) {
            super(Button.m_253074_((Component)text, (Button.OnPress)new Handler()).m_252987_(xIn, yIn, 154, 20));
            this.screen = screen;
        }

        public ResearchTableScreen getScreen() {
            return this.screen;
        }

        private static class Handler
        implements Button.OnPress {
            private Handler() {
            }

            public void m_93750_(Button button) {
                if (button instanceof StartProjectButton) {
                    StartProjectButton spb = (StartProjectButton)button;
                    PacketHandler.sendToServer(new StartProjectPacket(((ResearchTableMenu)((ResearchTableScreen)spb.getScreen()).f_97732_).f_38840_));
                    spb.getScreen().setProgressing();
                }
            }
        }
    }

    protected static class CompleteProjectButton
    extends Button {
        protected ResearchTableScreen screen;

        public CompleteProjectButton(int xIn, int yIn, Component text, ResearchTableScreen screen) {
            super(Button.m_253074_((Component)text, (Button.OnPress)new Handler()).m_252987_(xIn, yIn, 154, 20));
            this.screen = screen;
        }

        public ResearchTableScreen getScreen() {
            return this.screen;
        }

        private static class Handler
        implements Button.OnPress {
            private Handler() {
            }

            public void m_93750_(Button button) {
                if (button instanceof CompleteProjectButton) {
                    CompleteProjectButton cpb = (CompleteProjectButton)button;
                    PacketHandler.sendToServer(new CompleteProjectPacket(((ResearchTableMenu)((ResearchTableScreen)cpb.getScreen()).f_97732_).f_38840_));
                    cpb.getScreen().setProgressing();
                }
            }
        }
    }
}

