/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui;

import com.verdantartifice.primalmagick.PrimalMagick;
import com.verdantartifice.primalmagick.client.util.GuiUtils;
import com.verdantartifice.primalmagick.common.crafting.IRunecarvingRecipe;
import com.verdantartifice.primalmagick.common.menus.RunecarvingTableMenu;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class RunecarvingTableScreen
extends AbstractContainerScreen<RunecarvingTableMenu> {
    protected static final ResourceLocation TEXTURE = PrimalMagick.resource("textures/gui/runecarving_table.png");
    protected float sliderProgress;
    protected boolean clickedOnSroll;
    protected int recipeIndexOffset;
    protected boolean hasItemsInInputSlot;

    public RunecarvingTableScreen(RunecarvingTableMenu screenMenu, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenMenu, inv, titleIn);
        screenMenu.setInventoryUpdateListener(this::onInventoryUpdate);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        int i = this.f_97735_;
        int j = this.f_97736_;
        guiGraphics.m_280218_(TEXTURE, i, j, 0, 0, this.f_97726_, this.f_97727_);
        int k = (int)(41.0f * this.sliderProgress);
        guiGraphics.m_280218_(TEXTURE, i + 119, j + 15 + k, 176 + (this.canScroll() ? 0 : 12), 0, 12, 15);
        int l = this.f_97735_ + 52;
        int i1 = this.f_97736_ + 14;
        int j1 = this.recipeIndexOffset + 12;
        this.drawRecipesBackground(guiGraphics, mouseX, mouseY, l, i1, j1);
        this.drawRecipesItems(guiGraphics, mouseX, mouseY, l, i1, j1);
    }

    protected void drawRecipesBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, int left, int top, int recipeIndexOffsetMax) {
        for (int i = this.recipeIndexOffset; i < recipeIndexOffsetMax && i < ((RunecarvingTableMenu)this.f_97732_).getRecipeListSize(); ++i) {
            int j = i - this.recipeIndexOffset;
            int k = left + j % 4 * 16;
            int l = j / 4;
            int i1 = top + l * 18 + 2;
            int j1 = this.f_97727_;
            if (i == ((RunecarvingTableMenu)this.f_97732_).getSelectedRecipe()) {
                j1 += 18;
            } else if (mouseX >= k && mouseY >= i1 && mouseX < k + 16 && mouseY < i1 + 18) {
                j1 += 36;
            }
            guiGraphics.m_280218_(TEXTURE, k, i1 - 1, 0, j1, 16, 18);
        }
    }

    protected void drawRecipesItems(GuiGraphics guiGraphics, int mouseX, int mouseY, int left, int top, int recipeIndexOffsetMax) {
        List<IRunecarvingRecipe> list = ((RunecarvingTableMenu)this.f_97732_).getRecipeList();
        for (int i = this.recipeIndexOffset; i < recipeIndexOffsetMax && i < ((RunecarvingTableMenu)this.f_97732_).getRecipeListSize(); ++i) {
            int j = i - this.recipeIndexOffset;
            int k = left + j % 4 * 16;
            int l = j / 4;
            int i1 = top + l * 18 + 2;
            ItemStack output = list.get(i).m_8043_(this.f_96541_.f_91073_.m_9598_());
            guiGraphics.m_280480_(output, k, i1);
        }
    }

    protected void m_280072_(GuiGraphics pGuiGraphics, int pX, int pY) {
        super.m_280072_(pGuiGraphics, pX, pY);
        List<IRunecarvingRecipe> list = ((RunecarvingTableMenu)this.f_97732_).getRecipeList();
        for (int i = this.recipeIndexOffset; i < this.recipeIndexOffset + 12 && i < ((RunecarvingTableMenu)this.f_97732_).getRecipeListSize(); ++i) {
            int j = i - this.recipeIndexOffset;
            int k = this.f_97735_ + 52 + j % 4 * 16;
            int l = j / 4;
            int i1 = this.f_97736_ + 14 + l * 18 + 2;
            ItemStack output = list.get(i).m_8043_(this.f_96541_.f_91073_.m_9598_());
            if (pX < k || pX >= k + 16 || pY < i1 || pY >= i1 + 18) continue;
            GuiUtils.renderItemTooltip(pGuiGraphics, output, pX, pY);
        }
    }

    public boolean m_6375_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        this.clickedOnSroll = false;
        if (this.hasItemsInInputSlot) {
            int i = this.f_97735_ + 52;
            int j = this.f_97736_ + 14;
            int k = this.recipeIndexOffset + 12;
            for (int l = this.recipeIndexOffset; l < k; ++l) {
                int i1 = l - this.recipeIndexOffset;
                double d0 = p_mouseClicked_1_ - (double)(i + i1 % 4 * 16);
                double d1 = p_mouseClicked_3_ - (double)(j + i1 / 4 * 18);
                if (!(d0 >= 0.0) || !(d1 >= 0.0) || !(d0 < 16.0) || !(d1 < 18.0) || !((RunecarvingTableMenu)this.f_97732_).m_6366_((Player)this.f_96541_.f_91074_, l)) continue;
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12495_, (float)1.0f));
                this.f_96541_.f_91072_.m_105208_(((RunecarvingTableMenu)this.f_97732_).f_38840_, l);
                return true;
            }
            i = this.f_97735_ + 119;
            j = this.f_97736_ + 9;
            if (p_mouseClicked_1_ >= (double)i && p_mouseClicked_1_ < (double)(i + 12) && p_mouseClicked_3_ >= (double)j && p_mouseClicked_3_ < (double)(j + 54)) {
                this.clickedOnSroll = true;
            }
        }
        return super.m_6375_(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
    }

    public boolean m_7979_(double p_mouseDragged_1_, double p_mouseDragged_3_, int p_mouseDragged_5_, double p_mouseDragged_6_, double p_mouseDragged_8_) {
        if (this.clickedOnSroll && this.canScroll()) {
            int i = this.f_97736_ + 14;
            int j = i + 54;
            this.sliderProgress = ((float)p_mouseDragged_3_ - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.sliderProgress = Mth.m_14036_((float)this.sliderProgress, (float)0.0f, (float)1.0f);
            this.recipeIndexOffset = (int)((double)(this.sliderProgress * (float)this.getHiddenRows()) + 0.5) * 4;
            return true;
        }
        return super.m_7979_(p_mouseDragged_1_, p_mouseDragged_3_, p_mouseDragged_5_, p_mouseDragged_6_, p_mouseDragged_8_);
    }

    public boolean m_6050_(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double p_mouseScrolled_5_) {
        if (this.canScroll()) {
            int i = this.getHiddenRows();
            this.sliderProgress = (float)((double)this.sliderProgress - p_mouseScrolled_5_ / (double)i);
            this.sliderProgress = Mth.m_14036_((float)this.sliderProgress, (float)0.0f, (float)1.0f);
            this.recipeIndexOffset = (int)((double)(this.sliderProgress * (float)i) + 0.5) * 4;
        }
        return true;
    }

    protected boolean canScroll() {
        return this.hasItemsInInputSlot && ((RunecarvingTableMenu)this.f_97732_).getRecipeListSize() > 12;
    }

    protected int getHiddenRows() {
        return (((RunecarvingTableMenu)this.f_97732_).getRecipeListSize() + 4 - 1) / 4 - 3;
    }

    protected void onInventoryUpdate() {
        this.hasItemsInInputSlot = ((RunecarvingTableMenu)this.f_97732_).hasItemsInInputSlot();
        if (!this.hasItemsInInputSlot) {
            this.sliderProgress = 0.0f;
            this.recipeIndexOffset = 0;
        }
    }
}

