/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui;

import com.verdantartifice.primalmagick.client.config.KeyBindings;
import com.verdantartifice.primalmagick.client.events.InputEvents;
import com.verdantartifice.primalmagick.client.gui.radial.GenericRadialMenu;
import com.verdantartifice.primalmagick.client.gui.radial.IRadialMenuHost;
import com.verdantartifice.primalmagick.client.gui.radial.ImageRadialMenuItem;
import com.verdantartifice.primalmagick.client.gui.radial.RadialMenuItem;
import com.verdantartifice.primalmagick.client.gui.radial.SpellPackageRadialMenuItem;
import com.verdantartifice.primalmagick.common.config.Config;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.misc.SetActiveSpellPacket;
import com.verdantartifice.primalmagick.common.spells.SpellPackage;
import com.verdantartifice.primalmagick.common.wands.IWand;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class SpellSelectionRadialScreen
extends Screen {
    private ItemStack stackEquipped = ItemStack.f_41583_;
    private boolean needsRecheckSpells = true;
    private final GenericRadialMenu menu;
    private final List<RadialMenuItem> cachedMenuItems = new ArrayList<RadialMenuItem>();
    private final ImageRadialMenuItem noSpellMenuItem;

    public SpellSelectionRadialScreen() {
        super((Component)Component.m_237119_());
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_.m_21205_().m_41720_() instanceof IWand) {
            this.stackEquipped = mc.f_91074_.m_21205_();
        } else if (mc.f_91074_.m_21206_().m_41720_() instanceof IWand) {
            this.stackEquipped = mc.f_91074_.m_21206_();
        }
        this.menu = new GenericRadialMenu(mc, new IRadialMenuHost(){

            @Override
            public void renderTooltip(GuiGraphics guiGraphics, ItemStack stack, int mouseX, int mouseY) {
                guiGraphics.m_280153_(SpellSelectionRadialScreen.this.f_96547_, stack, mouseX, mouseY);
            }

            @Override
            public void renderTooltip(GuiGraphics guiGraphics, List<Component> textComponents, int mouseX, int mouseY) {
                guiGraphics.m_280677_(SpellSelectionRadialScreen.this.f_96547_, textComponents, Optional.empty(), mouseX, mouseY);
            }

            @Override
            public Screen getScreen() {
                return SpellSelectionRadialScreen.this;
            }

            @Override
            public Font getFontRenderer() {
                return SpellSelectionRadialScreen.this.f_96547_;
            }
        }){

            @Override
            public void onClickOutside() {
                this.close();
            }
        };
        this.noSpellMenuItem = new ImageRadialMenuItem(this.menu, -1, new ResourceLocation("textures/item/barrier.png"), (Component)Component.m_237115_((String)"tooltip.primalmagick.spells.no_spell_selection")){

            @Override
            public boolean onClick() {
                return SpellSelectionRadialScreen.this.trySwitch(this.getSlot());
            }
        };
    }

    public void m_7861_() {
        super.m_7861_();
        InputEvents.wipeOpen();
    }

    public void m_86600_() {
        super.m_86600_();
        this.menu.tick();
        if (this.menu.isClosed()) {
            this.f_96541_.m_91152_(null);
            InputEvents.wipeOpen();
        }
        if (!this.menu.isReady()) {
            return;
        }
        ItemStack inMainHand = this.f_96541_.f_91074_.m_21205_();
        ItemStack inOffHand = this.f_96541_.f_91074_.m_21206_();
        if (inMainHand.m_41720_() instanceof IWand) {
            if (this.stackEquipped != inMainHand) {
                this.stackEquipped = inMainHand;
                this.needsRecheckSpells = true;
            }
        } else if (inOffHand.m_41720_() instanceof IWand) {
            if (this.stackEquipped != inOffHand) {
                this.stackEquipped = inOffHand;
                this.needsRecheckSpells = true;
            }
        } else {
            this.stackEquipped = ItemStack.f_41583_;
        }
        if (this.stackEquipped.m_41619_()) {
            this.f_96541_.m_91152_(null);
        } else if (!InputEvents.isKeyDown(KeyBindings.CHANGE_SPELL_KEY)) {
            if (((Boolean)Config.RADIAL_RELEASE_TO_SWITCH.get()).booleanValue()) {
                this.processClick(false);
            } else {
                this.menu.close();
            }
        }
    }

    public boolean m_6348_(double p_94722_, double p_94723_, int p_94724_) {
        this.processClick(true);
        return super.m_6348_(p_94722_, p_94723_, p_94724_);
    }

    protected void processClick(boolean triggeredByMouse) {
        this.menu.clickItem();
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.m_280168_().m_85836_();
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.m_280168_().m_85849_();
        if (this.stackEquipped.m_41619_()) {
            return;
        }
        IWand wand = (IWand)this.stackEquipped.m_41720_();
        if (this.needsRecheckSpells) {
            this.cachedMenuItems.clear();
            List<SpellPackage> spells = wand.getSpells(this.stackEquipped);
            for (int index = 0; index < spells.size(); ++index) {
                SpellPackage spell = spells.get(index);
                SpellPackageRadialMenuItem item = new SpellPackageRadialMenuItem(this.menu, index, spell){

                    @Override
                    public boolean onClick() {
                        return SpellSelectionRadialScreen.this.trySwitch(this.getSlot());
                    }
                };
                item.setVisible(true);
                this.cachedMenuItems.add(item);
            }
            this.menu.clear();
            this.menu.addAll(this.cachedMenuItems);
            this.noSpellMenuItem.setVisible(true);
            this.menu.add(this.noSpellMenuItem);
            this.needsRecheckSpells = false;
        }
        this.menu.draw(guiGraphics, partialTick, mouseX, mouseY);
    }

    private boolean trySwitch(int slotNumber) {
        ItemStack inMainHand = this.f_96541_.f_91074_.m_21205_();
        ItemStack inOffHand = this.f_96541_.f_91074_.m_21206_();
        if (!(inMainHand.m_41720_() instanceof IWand) && !(inOffHand.m_41720_() instanceof IWand)) {
            return false;
        }
        PacketHandler.sendToServer(new SetActiveSpellPacket(slotNumber));
        this.menu.close();
        return true;
    }

    public boolean m_7043_() {
        return false;
    }
}

