/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.verdantartifice.primalmagick.PrimalMagick;
import com.verdantartifice.primalmagick.client.gui.widgets.ManaCostWidget;
import com.verdantartifice.primalmagick.common.menus.SpellcraftingAltarMenu;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.spellcrafting.SetSpellComponentPropertyPacket;
import com.verdantartifice.primalmagick.common.network.packets.spellcrafting.SetSpellComponentTypeIndexPacket;
import com.verdantartifice.primalmagick.common.network.packets.spellcrafting.SetSpellNamePacket;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.common.spells.SpellComponent;
import com.verdantartifice.primalmagick.common.spells.SpellManager;
import com.verdantartifice.primalmagick.common.spells.SpellProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class SpellcraftingAltarScreen
extends AbstractContainerScreen<SpellcraftingAltarMenu> {
    private static final ResourceLocation TEXTURE = PrimalMagick.resource("textures/gui/spellcrafting_altar.png");
    private final Map<Vec3i, Component> texts = new HashMap<Vec3i, Component>();
    private final List<GuiEventListener> localWidgets = new ArrayList<GuiEventListener>();
    private EditBox nameField;

    public SpellcraftingAltarScreen(SpellcraftingAltarMenu screenMenu, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenMenu, inv, titleIn);
        this.f_97726_ = 230;
        this.f_97727_ = 222;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.nameField = new EditBox(this.f_96547_, this.f_97735_ + 49, this.f_97736_ + 12, 103, 12, (Component)Component.m_237119_());
        this.nameField.m_94190_(false);
        this.nameField.m_93692_(true);
        this.nameField.m_94202_(-1);
        this.nameField.m_94205_(-1);
        this.nameField.m_94182_(false);
        this.nameField.m_94199_(50);
        this.nameField.m_94151_(this::updateName);
        this.nameField.m_94144_(((SpellcraftingAltarMenu)this.f_97732_).getDefaultSpellName().getString());
        this.m_7787_((GuiEventListener)this.nameField);
        this.m_264313_((GuiEventListener)this.nameField);
    }

    public void m_6574_(Minecraft p_resize_1_, int p_resize_2_, int p_resize_3_) {
        String str = this.nameField.m_94155_();
        this.m_6575_(p_resize_1_, p_resize_2_, p_resize_3_);
        this.nameField.m_94144_(str);
    }

    public boolean m_7933_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (p_keyPressed_1_ == 256) {
            this.f_96541_.f_91074_.m_6915_();
        }
        return !this.nameField.m_7933_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_) && !this.nameField.m_94204_() ? super.m_7933_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_) : true;
    }

    protected void m_181908_() {
        super.m_181908_();
        this.nameField.m_94120_();
    }

    protected void regenerateWidgets() {
        for (GuiEventListener widget : this.localWidgets) {
            this.m_169411_(widget);
        }
        this.localWidgets.clear();
        this.texts.clear();
        if (!this.nameField.m_93696_()) {
            this.m_264313_((GuiEventListener)this.nameField);
        }
        int startX = this.f_97735_ + 7;
        int startY = this.f_97736_ + 32;
        int x = startX;
        int y = startY;
        int vehicleMax = SpellManager.getVehicleTypes(((SpellcraftingAltarMenu)this.f_97732_).getPlayer()).size() - 1;
        int payloadMax = SpellManager.getPayloadTypes(((SpellcraftingAltarMenu)this.f_97732_).getPlayer()).size() - 1;
        int modMax = SpellManager.getModTypes(((SpellcraftingAltarMenu)this.f_97732_).getPlayer()).size() - 1;
        SourceList manaCost = ((SpellcraftingAltarMenu)this.f_97732_).getSpellPackage().getManaCost();
        if (manaCost != null && !manaCost.isEmpty()) {
            Source source = manaCost.getSourcesSorted().get(0);
            this.localWidgets.add(this.m_142416_((GuiEventListener)new ManaCostWidget(source, manaCost.getAmount(source), this.f_97735_ + 28, this.f_97736_ + 8, ((SpellcraftingAltarMenu)this.f_97732_)::getWand, ((SpellcraftingAltarMenu)this.f_97732_).getPlayer())));
        }
        this.texts.put(new Vec3i(x, y + 2, 106), (Component)Component.m_237115_((String)"spells.primalmagick.vehicle.header"));
        this.localWidgets.add(this.m_142416_((GuiEventListener)new CyclicBoundedSpinnerButton(x, y += 12, false, 0, vehicleMax, ((SpellcraftingAltarMenu)this.f_97732_)::getSpellVehicleTypeIndex, this::updateSpellVehicleTypeIndex)));
        this.texts.put(new Vec3i(x + 8, y + 2, 90), ((SpellcraftingAltarMenu)this.f_97732_).getSpellPackage().getVehicle().getTypeName());
        this.localWidgets.add(this.m_142416_((GuiEventListener)new CyclicBoundedSpinnerButton(x + 99, y, true, 0, vehicleMax, ((SpellcraftingAltarMenu)this.f_97732_)::getSpellVehicleTypeIndex, this::updateSpellVehicleTypeIndex)));
        for (SpellProperty property : ((SpellcraftingAltarMenu)this.f_97732_).getSpellPackage().getVehicle().getProperties()) {
            this.localWidgets.add(this.m_142416_((GuiEventListener)new CyclicBoundedSpinnerButton(x + 8, y += 12, false, property.getMin(), property.getMax(), ((SpellcraftingAltarMenu)this.f_97732_).getSpellPackage().getVehicle().getProperty(property.getName())::getValue, v -> this.updateSpellPropertyValue(SpellComponent.VEHICLE, property.getName(), (int)v))));
            this.texts.put(new Vec3i(x + 18, y + 2, 7), (Component)Component.m_237113_((String)Integer.toString(property.getValue())));
            this.localWidgets.add(this.m_142416_((GuiEventListener)new CyclicBoundedSpinnerButton(x + 26, y, true, property.getMin(), property.getMax(), ((SpellcraftingAltarMenu)this.f_97732_).getSpellPackage().getVehicle().getProperty(property.getName())::getValue, v -> this.updateSpellPropertyValue(SpellComponent.VEHICLE, property.getName(), (int)v))));
            this.texts.put(new Vec3i(x + 35, y + 2, Math.min(71, this.f_96547_.m_92895_(property.getDescription().getString()))), property.getDescription());
        }
        y = startY + 48;
        this.texts.put(new Vec3i(x, y + 2, 106), (Component)Component.m_237115_((String)"spells.primalmagick.payload.header"));
        this.localWidgets.add(this.m_142416_((GuiEventListener)new CyclicBoundedSpinnerButton(x, y += 12, false, 0, payloadMax, ((SpellcraftingAltarMenu)this.f_97732_)::getSpellPayloadTypeIndex, this::updateSpellPayloadTypeIndex)));
        this.texts.put(new Vec3i(x + 8, y + 2, 90), ((SpellcraftingAltarMenu)this.f_97732_).getSpellPackage().getPayload().getTypeName());
        this.localWidgets.add(this.m_142416_((GuiEventListener)new CyclicBoundedSpinnerButton(x + 99, y, true, 0, payloadMax, ((SpellcraftingAltarMenu)this.f_97732_)::getSpellPayloadTypeIndex, this::updateSpellPayloadTypeIndex)));
        for (SpellProperty property : ((SpellcraftingAltarMenu)this.f_97732_).getSpellPackage().getPayload().getProperties()) {
            this.localWidgets.add(this.m_142416_((GuiEventListener)new CyclicBoundedSpinnerButton(x + 8, y += 12, false, property.getMin(), property.getMax(), ((SpellcraftingAltarMenu)this.f_97732_).getSpellPackage().getPayload().getProperty(property.getName())::getValue, v -> this.updateSpellPropertyValue(SpellComponent.PAYLOAD, property.getName(), (int)v))));
            this.texts.put(new Vec3i(x + 18, y + 2, 7), (Component)Component.m_237113_((String)Integer.toString(property.getValue())));
            this.localWidgets.add(this.m_142416_((GuiEventListener)new CyclicBoundedSpinnerButton(x + 26, y, true, property.getMin(), property.getMax(), ((SpellcraftingAltarMenu)this.f_97732_).getSpellPackage().getPayload().getProperty(property.getName())::getValue, v -> this.updateSpellPropertyValue(SpellComponent.PAYLOAD, property.getName(), (int)v))));
            this.texts.put(new Vec3i(x + 35, y + 2, Math.min(71, this.f_96547_.m_92895_(property.getDescription().getString()))), property.getDescription());
        }
        y = startY;
        this.texts.put(new Vec3i(x += 110, y + 2, 106), (Component)Component.m_237115_((String)"spells.primalmagick.primary_mod.header"));
        this.localWidgets.add(this.m_142416_((GuiEventListener)new CyclicBoundedSpinnerButton(x, y += 12, false, 0, modMax, ((SpellcraftingAltarMenu)this.f_97732_)::getSpellPrimaryModTypeIndex, this::updateSpellPrimaryModTypeIndex)));
        this.texts.put(new Vec3i(x + 8, y + 2, 90), ((SpellcraftingAltarMenu)this.f_97732_).getSpellPackage().getPrimaryMod().getTypeName());
        this.localWidgets.add(this.m_142416_((GuiEventListener)new CyclicBoundedSpinnerButton(x + 99, y, true, 0, modMax, ((SpellcraftingAltarMenu)this.f_97732_)::getSpellPrimaryModTypeIndex, this::updateSpellPrimaryModTypeIndex)));
        for (SpellProperty property : ((SpellcraftingAltarMenu)this.f_97732_).getSpellPackage().getPrimaryMod().getProperties()) {
            this.localWidgets.add(this.m_142416_((GuiEventListener)new CyclicBoundedSpinnerButton(x + 8, y += 12, false, property.getMin(), property.getMax(), ((SpellcraftingAltarMenu)this.f_97732_).getSpellPackage().getPrimaryMod().getProperty(property.getName())::getValue, v -> this.updateSpellPropertyValue(SpellComponent.PRIMARY_MOD, property.getName(), (int)v))));
            this.texts.put(new Vec3i(x + 18, y + 2, 7), (Component)Component.m_237113_((String)Integer.toString(property.getValue())));
            this.localWidgets.add(this.m_142416_((GuiEventListener)new CyclicBoundedSpinnerButton(x + 26, y, true, property.getMin(), property.getMax(), ((SpellcraftingAltarMenu)this.f_97732_).getSpellPackage().getPrimaryMod().getProperty(property.getName())::getValue, v -> this.updateSpellPropertyValue(SpellComponent.PRIMARY_MOD, property.getName(), (int)v))));
            this.texts.put(new Vec3i(x + 35, y + 2, Math.min(71, this.f_96547_.m_92895_(property.getDescription().getString()))), property.getDescription());
        }
        y = startY + 48;
        this.texts.put(new Vec3i(x, y + 2, 106), (Component)Component.m_237115_((String)"spells.primalmagick.secondary_mod.header"));
        this.localWidgets.add(this.m_142416_((GuiEventListener)new CyclicBoundedSpinnerButton(x, y += 12, false, 0, modMax, ((SpellcraftingAltarMenu)this.f_97732_)::getSpellSecondaryModTypeIndex, this::updateSpellSecondaryModTypeIndex)));
        this.texts.put(new Vec3i(x + 8, y + 2, 90), ((SpellcraftingAltarMenu)this.f_97732_).getSpellPackage().getSecondaryMod().getTypeName());
        this.localWidgets.add(this.m_142416_((GuiEventListener)new CyclicBoundedSpinnerButton(x + 99, y, true, 0, modMax, ((SpellcraftingAltarMenu)this.f_97732_)::getSpellSecondaryModTypeIndex, this::updateSpellSecondaryModTypeIndex)));
        for (SpellProperty property : ((SpellcraftingAltarMenu)this.f_97732_).getSpellPackage().getSecondaryMod().getProperties()) {
            this.localWidgets.add(this.m_142416_((GuiEventListener)new CyclicBoundedSpinnerButton(x + 8, y += 12, false, property.getMin(), property.getMax(), ((SpellcraftingAltarMenu)this.f_97732_).getSpellPackage().getSecondaryMod().getProperty(property.getName())::getValue, v -> this.updateSpellPropertyValue(SpellComponent.SECONDARY_MOD, property.getName(), (int)v))));
            this.texts.put(new Vec3i(x + 18, y + 2, 7), (Component)Component.m_237113_((String)Integer.toString(property.getValue())));
            this.localWidgets.add(this.m_142416_((GuiEventListener)new CyclicBoundedSpinnerButton(x + 26, y, true, property.getMin(), property.getMax(), ((SpellcraftingAltarMenu)this.f_97732_).getSpellPackage().getSecondaryMod().getProperty(property.getName())::getValue, v -> this.updateSpellPropertyValue(SpellComponent.SECONDARY_MOD, property.getName(), (int)v))));
            this.texts.put(new Vec3i(x + 35, y + 2, Math.min(71, this.f_96547_.m_92895_(property.getDescription().getString()))), property.getDescription());
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.regenerateWidgets();
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.m_280072_(guiGraphics, mouseX, mouseY);
        RenderSystem.disableBlend();
        this.nameField.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        guiGraphics.m_280218_(TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        guiGraphics.m_280218_(TEXTURE, this.f_97735_ + 46, this.f_97736_ + 8, 0, this.f_97727_, 110, 16);
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int color = 0x404040;
        for (Map.Entry<Vec3i, Component> entry : this.texts.entrySet()) {
            String str = this.f_96547_.m_92834_(entry.getValue().getString(), entry.getKey().m_123343_());
            int strWidth = this.f_96547_.m_92895_(str);
            guiGraphics.m_280056_(this.f_96541_.f_91062_, str, entry.getKey().m_123341_() - this.f_97735_ + (entry.getKey().m_123343_() - strWidth) / 2, entry.getKey().m_123342_() - this.f_97736_, color, false);
        }
    }

    private void updateName(String name) {
        if (name.isEmpty()) {
            name = ((SpellcraftingAltarMenu)this.f_97732_).getDefaultSpellName().getString();
        }
        ((SpellcraftingAltarMenu)this.f_97732_).setSpellName(name);
        PacketHandler.sendToServer(new SetSpellNamePacket(((SpellcraftingAltarMenu)this.f_97732_).f_38840_, name));
    }

    private void updateSpellVehicleTypeIndex(int index) {
        boolean recalcName = this.nameField.m_94155_().isEmpty() || this.nameField.m_94155_().equals(((SpellcraftingAltarMenu)this.f_97732_).getDefaultSpellName().getString());
        ((SpellcraftingAltarMenu)this.f_97732_).setSpellVehicleTypeIndex(index);
        PacketHandler.sendToServer(new SetSpellComponentTypeIndexPacket(((SpellcraftingAltarMenu)this.f_97732_).f_38840_, SpellComponent.VEHICLE, index));
        if (recalcName) {
            this.nameField.m_94144_(((SpellcraftingAltarMenu)this.f_97732_).getDefaultSpellName().getString());
        }
    }

    private void updateSpellPayloadTypeIndex(int index) {
        boolean recalcName = this.nameField.m_94155_().isEmpty() || this.nameField.m_94155_().equals(((SpellcraftingAltarMenu)this.f_97732_).getDefaultSpellName().getString());
        ((SpellcraftingAltarMenu)this.f_97732_).setSpellPayloadTypeIndex(index);
        PacketHandler.sendToServer(new SetSpellComponentTypeIndexPacket(((SpellcraftingAltarMenu)this.f_97732_).f_38840_, SpellComponent.PAYLOAD, index));
        if (recalcName) {
            this.nameField.m_94144_(((SpellcraftingAltarMenu)this.f_97732_).getDefaultSpellName().getString());
        }
    }

    private void updateSpellPrimaryModTypeIndex(int index) {
        boolean recalcName = this.nameField.m_94155_().isEmpty() || this.nameField.m_94155_().equals(((SpellcraftingAltarMenu)this.f_97732_).getDefaultSpellName().getString());
        ((SpellcraftingAltarMenu)this.f_97732_).setSpellPrimaryModTypeIndex(index);
        PacketHandler.sendToServer(new SetSpellComponentTypeIndexPacket(((SpellcraftingAltarMenu)this.f_97732_).f_38840_, SpellComponent.PRIMARY_MOD, index));
        if (recalcName) {
            this.nameField.m_94144_(((SpellcraftingAltarMenu)this.f_97732_).getDefaultSpellName().getString());
        }
    }

    private void updateSpellSecondaryModTypeIndex(int index) {
        boolean recalcName = this.nameField.m_94155_().isEmpty() || this.nameField.m_94155_().equals(((SpellcraftingAltarMenu)this.f_97732_).getDefaultSpellName().getString());
        ((SpellcraftingAltarMenu)this.f_97732_).setSpellSecondaryModTypeIndex(index);
        PacketHandler.sendToServer(new SetSpellComponentTypeIndexPacket(((SpellcraftingAltarMenu)this.f_97732_).f_38840_, SpellComponent.SECONDARY_MOD, index));
        if (recalcName) {
            this.nameField.m_94144_(((SpellcraftingAltarMenu)this.f_97732_).getDefaultSpellName().getString());
        }
    }

    private void updateSpellPropertyValue(SpellComponent component, String name, int value) {
        ((SpellcraftingAltarMenu)this.f_97732_).setSpellPropertyValue(component, name, value);
        PacketHandler.sendToServer(new SetSpellComponentPropertyPacket(((SpellcraftingAltarMenu)this.f_97732_).f_38840_, component, name, value));
    }

    protected static class CyclicBoundedSpinnerButton
    extends Button {
        protected final boolean isIncrement;
        protected final int min;
        protected final int max;
        protected final Supplier<Integer> getter;
        protected final Consumer<Integer> setter;

        public CyclicBoundedSpinnerButton(int x, int y, boolean increment, int min, int max, Supplier<Integer> getter, Consumer<Integer> setter) {
            super(Button.m_253074_((Component)Component.m_237119_(), (Button.OnPress)new Handler()).m_252987_(x, y, 7, 11));
            this.isIncrement = increment;
            this.min = min;
            this.max = max;
            this.getter = getter;
            this.setter = setter;
        }

        public void m_87963_(GuiGraphics guiGraphics, int p_renderButton_1_, int p_renderButton_2_, float p_renderButton_3_) {
            guiGraphics.m_280218_(TEXTURE, this.m_252754_(), this.m_252907_(), this.isIncrement ? 230 : 237, this.m_198029_() ? 11 : 0, this.f_93618_, this.f_93619_);
        }

        public boolean isIncrement() {
            return this.isIncrement;
        }

        public int getMin() {
            return this.min;
        }

        public int getMax() {
            return this.max;
        }

        public Supplier<Integer> getGetter() {
            return this.getter;
        }

        public Consumer<Integer> getSetter() {
            return this.setter;
        }

        private static class Handler
        implements Button.OnPress {
            private Handler() {
            }

            public void m_93750_(Button button) {
                if (button instanceof CyclicBoundedSpinnerButton) {
                    CyclicBoundedSpinnerButton spinner = (CyclicBoundedSpinnerButton)button;
                    int newVal = spinner.getGetter().get() + (spinner.isIncrement() ? 1 : -1);
                    if (newVal < spinner.getMin()) {
                        newVal = spinner.getMax();
                    } else if (newVal > spinner.getMax()) {
                        newVal = spinner.getMin();
                    }
                    spinner.getSetter().accept(newVal);
                }
            }
        }
    }
}

